/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

(function($, api) {
	var $document = $(document);

	api.bind("preview-ready", function() {
		var defaultTarget = window.parent === window ? null : window.parent;

		// for custom when click on preview
		$document.on(
			"click",
			".builder-item-focus .customize-partial-edit",
			function(e) {
				e.preventDefault();
				var p = $(this).closest(".builder-item-focus");
				var section_id = p.attr("data-section") || "";
				if (section_id) {
					if (defaultTarget.wp.customize.section(section_id)) {
						defaultTarget.wp.customize.section(section_id).focus();
					}
				}
			}
		);

	});

})(jQuery, wp.customize);
