// Utility function to add and remove classes
function addClass(element, className) {
    if (element && !element.classList.contains(className)) {
        element.classList.add(className);
    }
}

function removeClass(element, className) {
    if (element && element.classList.contains(className)) {
        element.classList.remove(className);
    }
}

// Add loading class to offcanvas-cart
document.body.addEventListener('adding_to_cart', function () {
    addClass(document.querySelector('.header-min-cart'), 'loading');
});

document.body.addEventListener('added_to_cart', function () {
    var headerMinCart = document.querySelector('.header-min-cart');
    if (headerMinCart) {
        setTimeout(function () {
            removeClass(headerMinCart, 'loading');
        }, 1500);
    }
});

// Update label when select value changes
document.querySelectorAll('.variations_form td.value select').forEach(function (selectElement) {
    selectElement.addEventListener('change', function () {
        var value = this.options[this.selectedIndex].text;
        var labelContainer = this.closest('tr').querySelector('td.label .mf-attr-value');
        if (labelContainer) {
            labelContainer.innerHTML = value;
        }
    });
    selectElement.dispatchEvent(new Event('change'));
});

// Add loading class to offcanvas-cart End

// Utility function to set cookie
function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + exdays * 24 * 60 * 60 * 1000);
    var expires = 'expires=' + d.toUTCString();
    document.cookie = cname + '=' + cvalue + ';' + expires + ';path=/';
}

// Switch View mod
document.body.addEventListener('click', function (e) {
    var target = e.target;
    if (target && target.classList.contains('product-view-button')) {
        e.preventDefault();
        var mod = target.dataset.mod || 'grid';
        var viewButtons = document.querySelectorAll('.product-view-switcher .product-view-button');
        viewButtons.forEach(function (button) {
            removeClass(button, 'color-primary', 'active');
        });
        addClass(target, 'color-primary', 'active');
        var productList = document.querySelector('ul.products');
        if (productList) {
            productList.className = 'product-' + mod + '-view';
        }
        setCookie('nevo_product_archive_view_mod', mod, 360);
    }
});

document.addEventListener('click', function (e) {
    var target = e.target;
    if (target && (target.classList.contains('plus') || target.classList.contains('minus'))) {
        var qtyElement = target.closest('.quantity').querySelector('.qty');
        var currentVal = parseFloat(qtyElement.value);
        var max = parseFloat(qtyElement.getAttribute('max'));
        var min = parseFloat(qtyElement.getAttribute('min'));
        var step = qtyElement.getAttribute('step');

        if (!currentVal || isNaN(currentVal)) {
            currentVal = 0;
        }
        if (isNaN(max)) {
            max = null;
        }
        if (isNaN(min)) {
            min = 0;
        }
        if (step === 'any' || step === '' || step === undefined || isNaN(parseFloat(step))) {
            step = 1;
        }

        if (target.classList.contains('plus')) {
            if (max !== null && (max === currentVal || currentVal > max)) {
                qtyElement.value = max;
            } else {
                qtyElement.value = currentVal + parseFloat(step);
            }
        } else {
            if (min !== null && (min === currentVal || currentVal < min)) {
                qtyElement.value = min;
            } else if (currentVal > 0) {
                qtyElement.value = currentVal - parseFloat(step);
            }
        }

        qtyElement.dispatchEvent(new Event('change'));
    }
});
