<?php
class Nevo_Customizer_Control_Icon extends Nevo_Customizer_Control_Base {
	static function field_template() {
		echo '<script type="text/html" id="tmpl-field-nevo-icon">';
		self::before_field();
		?>
		<#
		if ( ! _.isObject( field.value ) ) {
			field.value = { };
		}
		#>
		<?php echo self::field_header(); ?>
		<div class="nevo-field-settings-inner">
			<div class="nevo--icon-picker">
				<div class="nevo--icon-preview">
					<input type="hidden" class="nevo-input nevo--input-icon-type" data-name="{{ field.name }}-type" value="{{ field.value.type }}">
					<div class="nevo--icon-preview-icon nevo--pick-icon">
						<# if ( field.value.icon ) {  #>
							<i class="{{ field.value.icon }}"></i>
						<# }  #>
					</div>
				</div>
				<input type="text" readonly class="nevo-input nevo--pick-icon nevo--input-icon-name" placeholder="<?php esc_attr_e( 'Pick an icon', 'nevo' ); ?>" data-name="{{ field.name }}" value="{{ field.value.icon }}">
				<span class="nevo--icon-remove" title="<?php esc_attr_e( 'Remove', 'nevo' ); ?>">
					<span class="dashicons dashicons-no-alt"></span>
					<span class="screen-reader-text">
					<?php _e( 'Remove', 'nevo' ); ?></span>
				</span>
			</div>
		</div>
		<?php
		self::after_field();
		echo '</script>';
		?>
		<div id="nevo--sidebar-icons">
			<div class="nevo--sidebar-header">
				<a class="customize-controls-icon-close" href="#">
					<span class="screen-reader-text"><?php _e( 'Cancel', 'nevo' ); ?></span>
				</a>
				<div class="nevo--icon-type-inner">
					<select id="nevo--sidebar-icon-type">
						<option value="all"><?php _e( 'All Icon Types', 'nevo' ); ?></option>
					</select>
				</div>
			</div>
			<div class="nevo--sidebar-search">
				<input type="text" id="nevo--icon-search" placeholder="<?php esc_attr_e( 'Type icon name', 'nevo' ); ?>">
			</div>
			<div id="nevo--icon-browser"></div>
		</div>
		<?php
	}
}
