<?php
class Nevo_Customizer_Control_Shadow extends Nevo_Customizer_Control_Base {
	static function field_template() {
		echo '<script type="text/html" id="tmpl-field-nevo-shadow">';
		self::before_field();
		?>
		<#
			if ( ! _.isObject( field.value ) ) {
			field.value = { };
			}

			var uniqueID = field.name + ( new Date().getTime() );
		#>
			<?php echo self::field_header(); ?>
			<div class="nevo-field-settings-inner">

				<div class="nevo-input-color" data-default="{{ field.default }}">
					<input type="hidden" class="nevo-input nevo-input--color" data-name="{{ field.name }}-color" value="{{ field.value.color }}">
					<input type="text" class="nevo--color-panel" data-alpha="true" value="{{ field.value.color }}">
				</div>

				<div class="nevo--gr-inputs">
					<span>
						<input type="number" class="nevo-input nevo-input-css change-by-js"  data-name="{{ field.name }}-x" value="{{ field.value.x }}">
						<span class="nevo--small-label"><?php _e( 'X', 'nevo' ); ?></span>
					</span>
					<span>
						<input type="number" class="nevo-input nevo-input-css change-by-js"  data-name="{{ field.name }}-y" value="{{ field.value.y }}">
						<span class="nevo--small-label"><?php _e( 'Y', 'nevo' ); ?></span>
					</span>
					<span>
						<input type="number" class="nevo-input nevo-input-css change-by-js" data-name="{{ field.name }}-blur" value="{{ field.value.blur }}">
						<span class="nevo--small-label"><?php _e( 'Blur', 'nevo' ); ?></span>
					</span>
					<span>
						<input type="number" class="nevo-input nevo-input-css change-by-js" data-name="{{ field.name }}-spread" value="{{ field.value.spread }}">
						<span class="nevo--small-label"><?php _e( 'Spread', 'nevo' ); ?></span>
					</span>
					<span>
						<span class="input">
							<input type="checkbox" class="nevo-input nevo-input-css change-by-js" <# if ( field.value.inset == 1 ){ #> checked="checked" <# } #> data-name="{{ field.name }}-inset" value="{{ field.value.inset }}">
						</span>
						<span class="nevo--small-label"><?php _e( 'inset', 'nevo' ); ?></span>
					</span>
				</div>
			</div>
			<?php
			self::after_field();
			echo '</script>';
	}
}
