<?php
/**
 * Nevo Customizer Builder
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! function_exists( 'nevo_sanitize_field_recursive' ) ) {

    function nevo_sanitize_field_recursive( $value ) {
        if ( ! is_array( $value ) ) {
            $value = wp_kses_post( $value );
        } else {
            if ( is_array( $value ) ) {
                foreach ( $value as $k => $v ) {
                    $value[ $k ] = nevo_sanitize_field_recursive( $v );
                }
            }
        }
        return $value;
    }
}

if ( ! function_exists( 'nevo_sanitize_field' ) ) {

    function nevo_sanitize_field( $input ) {
        $input = wp_unslash( $input );
        if ( ! is_array( $input ) ) {
            $input = json_decode( urldecode_deep( $input ), true );
        }
        $output = nevo_sanitize_field_recursive( $input );
        $output = json_encode( $output );
        return $output;
    }
}

/**
 * Add Builder to WP Customize
 *
 * Class Nevo_Customizer_Builder
 */
class Nevo_Customizer_Builder {

    /**
     * Main Instance
     *
     * Insures that only one instance of Nevo_Customizer_Builder exists in memory at any one
     * time. Also prevents needing to define globals all over the place.
     *
     *
     *
     * @return object
     */
    public static function instance() {

        // Store the instance locally to avoid private static replication
        static $instance = null;

        // Only run these methods if they haven't been ran previously
        if ( null === $instance ) {
            $instance = new Nevo_Customizer_Builder;
        }

        // Always return the instance
        return $instance;
    }

    /**
     * Run functionality with hooks
     *
     *
     *
     * @return void
     */
    function run() {

        if ( is_admin() ) {
            add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue' ) );
            add_action( 'customize_controls_print_footer_scripts', array( $this, 'builder_template' ) );
        }

    }

    /**
     * Get all builders registered.
     *
     * Insures that every builder is registered by nevo_builders filter
     *
     *
     *
     * @return array
     */
    public function get_builders() {
        $builders = array();
        $builders = apply_filters( 'nevo_builders', $builders );
        return $builders;
    }

    /**
     * Callback functions for customize_controls_enqueue_scripts,
     * Enqueue script and style for builder
     *
     *
     *
     * @return void
     */
    function enqueue() {
		$theme_dir = get_template_directory_uri();
		$suffix = Nevo()->get_asset_suffix();
        // Enqueue customizer styles.
        wp_enqueue_style(
            'customizer-builder',
            $theme_dir . '/assets/css/admin/customizer/builder' . $suffix . '.css',
            array(),
            Nevo::$version,
            'all'
        );

        wp_enqueue_script(
            'customizer-builder',
            $theme_dir . '/assets/js/customizer/builder' . $suffix . '.js',
            [
                'customize-controls',
                'jquery-ui-droppable'
            ],
            Nevo::$version,
            true
        );

        wp_localize_script(
            'customizer-builder',
            'Nevo_Customizer_Builder',
            array(
				'is_rtl'                    => is_rtl(),
                'footer_moved_widgets_text' => '',
                'builders'                  => $this->get_builders(),
                'desktop_label'             => esc_html__( 'Desktop', 'nevo' ),
                'mobile_tablet_label'       => esc_html__( 'Mobile/Tablet', 'nevo' ),
            )
        );
    }
    /**
     * Callback functions for customize_controls_print_footer_scripts,
     * Add Builder Template
     *
     * @access   public
     *
     * @return void
     */
    function builder_template() {
		$theme_dir = get_template_directory();
		
        require $theme_dir . '/template-parts/builder.php';
    }
}

if ( ! function_exists( 'nevo_customizer_builder' ) ) {

    function nevo_customizer_builder() {

        return Nevo_Customizer_Builder::instance();
    }
    nevo_customizer_builder()->run();
}
