<?php

class Nevo_Font_Icons {
	static $_instance;
	static $_icons;
	static $enqueued;
	static $get_bootstrap_icons;
	private $picked_types = array();

	static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Get support icons
	 *
	 * @return array
	 */
	function get_icons() {
		if ( is_null( self::$_icons ) ) {
			$icons        = array(
				'bootstrap-icons' => array(
					'name'         => __( 'Bootstrap Icons', 'nevo' ),
					'icons'        => $this->get_bootstrap_icons(),
					'url'          => esc_url( get_template_directory_uri() ) . '/assets/fonts/bootstrap-icons.min.css',
					'class_config' => '__icon_name__', // __icon_name__ will replace by icon class name
				),
			);
			self::$_icons = apply_filters( 'nevo/customizer/font_icons', $icons );
		}

		return self::$_icons;

	}

	function is_used() {
		if ( is_customize_preview() ) {
			return true;
		}
		$check = apply_filters( 'nevo/load-icons', true );
		if ( is_null( $check ) ) {
			$builders = array( 'header_builder_panel', 'footer_builder_panel' );
			$list     = apply_filters( 'nevo/icon_used', array() );

			foreach ( $builders as $setting_key ) {
				$data = Nevo()->get_setting( $setting_key );
				if ( is_array( $data ) ) {
					foreach ( $data as $devices => $rows ) {
						foreach ( (array) $rows as $row_id => $items ) {
							foreach ( (array) $items as $item ) {
								if ( is_array( $item ) ) {
									if ( isset( $list[ $item['id'] ] ) && $list[ $item['id'] ] ) {
										return true;
									}
								}
							}
						}
					}
				}
			}
		}

		return $check;
	}

	function enqueue() {
		if ( $this->is_used() ) {
			if ( is_null( self::$enqueued ) ) {
				foreach ( $this->get_icons() as $icon_id => $icon ) {
					wp_dequeue_style( $icon_id );
					wp_enqueue_style( $icon_id, $icon['url'], array(), '5.0.0' );
				}
				self::$enqueued = true;
			}

			if ( did_action( 'elementor/loaded' ) ) {
				$load_shim = get_option( 'elementor_load_fa4_shim', false );
				if ( 'yes' != $load_shim ) {
					update_option( 'elementor_load_fa4_shim', 'yes' );
				}
			}
		}
	}

	/**
	 * Get Bootstrap Icons
	 *
	 * @return array
	 */
	function get_bootstrap_icons() {
		$icons = array(
			0 => 'bi-123',
			1 => 'bi-activity',
			2 => 'bi-alarm-fill',
			3 => 'bi-alarm',
			4 => 'bi-align-bottom',
			5 => 'bi-align-center',
			6 => 'bi-align-end',
			7 => 'bi-align-middle',
			8 => 'bi-align-start',
			9 => 'bi-align-top',
			10 => 'bi-alt',
			11 => 'bi-app-indicator',
			12 => 'bi-app',
			13 => 'bi-apple',
			14 => 'bi-archive-fill',
			15 => 'bi-archive',
			16 => 'bi-arrow-90deg-down',
			17 => 'bi-arrow-90deg-left',
			18 => 'bi-arrow-90deg-right',
			19 => 'bi-arrow-90deg-up',
			20 => 'bi-arrow-bar-down',
			21 => 'bi-arrow-bar-left',
			22 => 'bi-arrow-bar-right',
			23 => 'bi-arrow-bar-up',
			24 => 'bi-arrow-clockwise',
			25 => 'bi-arrow-counterclockwise',
			26 => 'bi-arrow-down-circle-fill',
			27 => 'bi-arrow-down-circle',
			28 => 'bi-arrow-down-left-circle-fill',
			29 => 'bi-arrow-down-left-circle',
			30 => 'bi-arrow-down-left-square-fill',
			31 => 'bi-arrow-down-left-square',
			32 => 'bi-arrow-down-left',
			33 => 'bi-arrow-down-right-circle-fill',
			34 => 'bi-arrow-down-right-circle',
			35 => 'bi-arrow-down-right-square-fill',
			36 => 'bi-arrow-down-right-square',
			37 => 'bi-arrow-down-right',
			38 => 'bi-arrow-down-short',
			39 => 'bi-arrow-down-square-fill',
			40 => 'bi-arrow-down-square',
			41 => 'bi-arrow-down-up',
			42 => 'bi-arrow-down',
			43 => 'bi-arrow-left-circle-fill',
			44 => 'bi-arrow-left-circle',
			45 => 'bi-arrow-left-right',
			46 => 'bi-arrow-left-short',
			47 => 'bi-arrow-left-square-fill',
			48 => 'bi-arrow-left-square',
			49 => 'bi-arrow-left',
			50 => 'bi-arrow-repeat',
			51 => 'bi-arrow-return-left',
			52 => 'bi-arrow-return-right',
			53 => 'bi-arrow-right-circle-fill',
			54 => 'bi-arrow-right-circle',
			55 => 'bi-arrow-right-short',
			56 => 'bi-arrow-right-square-fill',
			57 => 'bi-arrow-right-square',
			58 => 'bi-arrow-right',
			59 => 'bi-arrow-through-heart-fill',
			60 => 'bi-arrow-through-heart',
			61 => 'bi-arrow-up-circle-fill',
			62 => 'bi-arrow-up-circle',
			63 => 'bi-arrow-up-left-circle-fill',
			64 => 'bi-arrow-up-left-circle',
			65 => 'bi-arrow-up-left-square-fill',
			66 => 'bi-arrow-up-left-square',
			67 => 'bi-arrow-up-left',
			68 => 'bi-arrow-up-right-circle-fill',
			69 => 'bi-arrow-up-right-circle',
			70 => 'bi-arrow-up-right-square-fill',
			71 => 'bi-arrow-up-right-square',
			72 => 'bi-arrow-up-right',
			73 => 'bi-arrow-up-short',
			74 => 'bi-arrow-up-square-fill',
			75 => 'bi-arrow-up-square',
			76 => 'bi-arrow-up',
			77 => 'bi-arrows-angle-contract',
			78 => 'bi-arrows-angle-expand',
			79 => 'bi-arrows-collapse',
			80 => 'bi-arrows-expand',
			81 => 'bi-arrows-fullscreen',
			82 => 'bi-arrows-move',
			83 => 'bi-aspect-ratio-fill',
			84 => 'bi-aspect-ratio',
			85 => 'bi-asterisk',
			86 => 'bi-at',
			87 => 'bi-award-fill',
			88 => 'bi-award',
			89 => 'bi-back',
			90 => 'bi-backspace-fill',
			91 => 'bi-backspace-reverse-fill',
			92 => 'bi-backspace-reverse',
			93 => 'bi-backspace',
			94 => 'bi-badge-3d-fill',
			95 => 'bi-badge-3d',
			96 => 'bi-badge-4k-fill',
			97 => 'bi-badge-4k',
			98 => 'bi-badge-8k-fill',
			99 => 'bi-badge-8k',
			100 => 'bi-badge-ad-fill',
			101 => 'bi-badge-ad',
			102 => 'bi-badge-ar-fill',
			103 => 'bi-badge-ar',
			104 => 'bi-badge-cc-fill',
			105 => 'bi-badge-cc',
			106 => 'bi-badge-hd-fill',
			107 => 'bi-badge-hd',
			108 => 'bi-badge-sd-fill',
			109 => 'bi-badge-sd',
			110 => 'bi-badge-tm-fill',
			111 => 'bi-badge-tm',
			112 => 'bi-badge-vo-fill',
			113 => 'bi-badge-vo',
			114 => 'bi-badge-vr-fill',
			115 => 'bi-badge-vr',
			116 => 'bi-badge-wc-fill',
			117 => 'bi-badge-wc',
			118 => 'bi-bag-check-fill',
			119 => 'bi-bag-check',
			120 => 'bi-bag-dash-fill',
			121 => 'bi-bag-dash',
			122 => 'bi-bag-fill',
			123 => 'bi-bag-heart-fill',
			124 => 'bi-bag-heart',
			125 => 'bi-bag-plus-fill',
			126 => 'bi-bag-plus',
			127 => 'bi-bag-x-fill',
			128 => 'bi-bag-x',
			129 => 'bi-bag',
			130 => 'bi-balloon-fill',
			131 => 'bi-balloon-heart-fill',
			132 => 'bi-balloon-heart',
			133 => 'bi-balloon',
			134 => 'bi-bandaid-fill',
			135 => 'bi-bandaid',
			136 => 'bi-bank',
			137 => 'bi-bank2',
			138 => 'bi-bar-chart-fill',
			139 => 'bi-bar-chart-line-fill',
			140 => 'bi-bar-chart-line',
			141 => 'bi-bar-chart-steps',
			142 => 'bi-bar-chart',
			143 => 'bi-basket-fill',
			144 => 'bi-basket',
			145 => 'bi-basket2-fill',
			146 => 'bi-basket2',
			147 => 'bi-basket3-fill',
			148 => 'bi-basket3',
			149 => 'bi-battery-charging',
			150 => 'bi-battery-full',
			151 => 'bi-battery-half',
			152 => 'bi-battery',
			153 => 'bi-behance',
			154 => 'bi-bell-fill',
			155 => 'bi-bell-slash-fill',
			156 => 'bi-bell-slash',
			157 => 'bi-bell',
			158 => 'bi-bezier',
			159 => 'bi-bezier2',
			160 => 'bi-bicycle',
			161 => 'bi-binoculars-fill',
			162 => 'bi-binoculars',
			163 => 'bi-blockquote-left',
			164 => 'bi-blockquote-right',
			165 => 'bi-bluetooth',
			166 => 'bi-body-text',
			167 => 'bi-book-fill',
			168 => 'bi-book-half',
			169 => 'bi-book',
			170 => 'bi-bookmark-check-fill',
			171 => 'bi-bookmark-check',
			172 => 'bi-bookmark-dash-fill',
			173 => 'bi-bookmark-dash',
			174 => 'bi-bookmark-fill',
			175 => 'bi-bookmark-heart-fill',
			176 => 'bi-bookmark-heart',
			177 => 'bi-bookmark-plus-fill',
			178 => 'bi-bookmark-plus',
			179 => 'bi-bookmark-star-fill',
			180 => 'bi-bookmark-star',
			181 => 'bi-bookmark-x-fill',
			182 => 'bi-bookmark-x',
			183 => 'bi-bookmark',
			184 => 'bi-bookmarks-fill',
			185 => 'bi-bookmarks',
			186 => 'bi-bookshelf',
			187 => 'bi-boombox-fill',
			188 => 'bi-boombox',
			189 => 'bi-bootstrap-fill',
			190 => 'bi-bootstrap-reboot',
			191 => 'bi-bootstrap',
			192 => 'bi-border-all',
			193 => 'bi-border-bottom',
			194 => 'bi-border-center',
			195 => 'bi-border-inner',
			196 => 'bi-border-left',
			197 => 'bi-border-middle',
			198 => 'bi-border-outer',
			199 => 'bi-border-right',
			200 => 'bi-border-style',
			201 => 'bi-border-top',
			202 => 'bi-border-width',
			203 => 'bi-border',
			204 => 'bi-bounding-box-circles',
			205 => 'bi-bounding-box',
			206 => 'bi-box-arrow-down-left',
			207 => 'bi-box-arrow-down-right',
			208 => 'bi-box-arrow-down',
			209 => 'bi-box-arrow-in-down-left',
			210 => 'bi-box-arrow-in-down-right',
			211 => 'bi-box-arrow-in-down',
			212 => 'bi-box-arrow-in-left',
			213 => 'bi-box-arrow-in-right',
			214 => 'bi-box-arrow-in-up-left',
			215 => 'bi-box-arrow-in-up-right',
			216 => 'bi-box-arrow-in-up',
			217 => 'bi-box-arrow-left',
			218 => 'bi-box-arrow-right',
			219 => 'bi-box-arrow-up-left',
			220 => 'bi-box-arrow-up-right',
			221 => 'bi-box-arrow-up',
			222 => 'bi-box-seam',
			223 => 'bi-box',
			224 => 'bi-box2-fill',
			225 => 'bi-box2-heart-fill',
			226 => 'bi-box2-heart',
			227 => 'bi-box2',
			228 => 'bi-boxes',
			229 => 'bi-braces-asterisk',
			230 => 'bi-braces',
			231 => 'bi-bricks',
			232 => 'bi-briefcase-fill',
			233 => 'bi-briefcase',
			234 => 'bi-brightness-alt-high-fill',
			235 => 'bi-brightness-alt-high',
			236 => 'bi-brightness-alt-low-fill',
			237 => 'bi-brightness-alt-low',
			238 => 'bi-brightness-high-fill',
			239 => 'bi-brightness-high',
			240 => 'bi-brightness-low-fill',
			241 => 'bi-brightness-low',
			242 => 'bi-broadcast-pin',
			243 => 'bi-broadcast',
			244 => 'bi-brush-fill',
			245 => 'bi-brush',
			246 => 'bi-bucket-fill',
			247 => 'bi-bucket',
			248 => 'bi-bug-fill',
			249 => 'bi-bug',
			250 => 'bi-building',
			251 => 'bi-bullseye',
			252 => 'bi-calculator-fill',
			253 => 'bi-calculator',
			254 => 'bi-calendar-check-fill',
			255 => 'bi-calendar-check',
			256 => 'bi-calendar-date-fill',
			257 => 'bi-calendar-date',
			258 => 'bi-calendar-day-fill',
			259 => 'bi-calendar-day',
			260 => 'bi-calendar-event-fill',
			261 => 'bi-calendar-event',
			262 => 'bi-calendar-fill',
			263 => 'bi-calendar-heart-fill',
			264 => 'bi-calendar-heart',
			265 => 'bi-calendar-minus-fill',
			266 => 'bi-calendar-minus',
			267 => 'bi-calendar-month-fill',
			268 => 'bi-calendar-month',
			269 => 'bi-calendar-plus-fill',
			270 => 'bi-calendar-plus',
			271 => 'bi-calendar-range-fill',
			272 => 'bi-calendar-range',
			273 => 'bi-calendar-week-fill',
			274 => 'bi-calendar-week',
			275 => 'bi-calendar-x-fill',
			276 => 'bi-calendar-x',
			277 => 'bi-calendar',
			278 => 'bi-calendar2-check-fill',
			279 => 'bi-calendar2-check',
			280 => 'bi-calendar2-date-fill',
			281 => 'bi-calendar2-date',
			282 => 'bi-calendar2-day-fill',
			283 => 'bi-calendar2-day',
			284 => 'bi-calendar2-event-fill',
			285 => 'bi-calendar2-event',
			286 => 'bi-calendar2-fill',
			287 => 'bi-calendar2-heart-fill',
			288 => 'bi-calendar2-heart',
			289 => 'bi-calendar2-minus-fill',
			290 => 'bi-calendar2-minus',
			291 => 'bi-calendar2-month-fill',
			292 => 'bi-calendar2-month',
			293 => 'bi-calendar2-plus-fill',
			294 => 'bi-calendar2-plus',
			295 => 'bi-calendar2-range-fill',
			296 => 'bi-calendar2-range',
			297 => 'bi-calendar2-week-fill',
			298 => 'bi-calendar2-week',
			299 => 'bi-calendar2-x-fill',
			300 => 'bi-calendar2-x',
			301 => 'bi-calendar2',
			302 => 'bi-calendar3-event-fill',
			303 => 'bi-calendar3-event',
			304 => 'bi-calendar3-fill',
			305 => 'bi-calendar3-range-fill',
			306 => 'bi-calendar3-range',
			307 => 'bi-calendar3-week-fill',
			308 => 'bi-calendar3-week',
			309 => 'bi-calendar3',
			310 => 'bi-calendar4-event',
			311 => 'bi-calendar4-range',
			312 => 'bi-calendar4-week',
			313 => 'bi-calendar4',
			314 => 'bi-camera-fill',
			315 => 'bi-camera-reels-fill',
			316 => 'bi-camera-reels',
			317 => 'bi-camera-video-fill',
			318 => 'bi-camera-video-off-fill',
			319 => 'bi-camera-video-off',
			320 => 'bi-camera-video',
			321 => 'bi-camera',
			322 => 'bi-camera2',
			323 => 'bi-capslock-fill',
			324 => 'bi-capslock',
			325 => 'bi-card-checklist',
			326 => 'bi-card-heading',
			327 => 'bi-card-image',
			328 => 'bi-card-list',
			329 => 'bi-card-text',
			330 => 'bi-caret-down-fill',
			331 => 'bi-caret-down-square-fill',
			332 => 'bi-caret-down-square',
			333 => 'bi-caret-down',
			334 => 'bi-caret-left-fill',
			335 => 'bi-caret-left-square-fill',
			336 => 'bi-caret-left-square',
			337 => 'bi-caret-left',
			338 => 'bi-caret-right-fill',
			339 => 'bi-caret-right-square-fill',
			340 => 'bi-caret-right-square',
			341 => 'bi-caret-right',
			342 => 'bi-caret-up-fill',
			343 => 'bi-caret-up-square-fill',
			344 => 'bi-caret-up-square',
			345 => 'bi-caret-up',
			346 => 'bi-cart-check-fill',
			347 => 'bi-cart-check',
			348 => 'bi-cart-dash-fill',
			349 => 'bi-cart-dash',
			350 => 'bi-cart-fill',
			351 => 'bi-cart-plus-fill',
			352 => 'bi-cart-plus',
			353 => 'bi-cart-x-fill',
			354 => 'bi-cart-x',
			355 => 'bi-cart',
			356 => 'bi-cart2',
			357 => 'bi-cart3',
			358 => 'bi-cart4',
			359 => 'bi-cash-coin',
			360 => 'bi-cash-stack',
			361 => 'bi-cash',
			362 => 'bi-cast',
			363 => 'bi-chat-dots-fill',
			364 => 'bi-chat-dots',
			365 => 'bi-chat-fill',
			366 => 'bi-chat-heart-fill',
			367 => 'bi-chat-heart',
			368 => 'bi-chat-left-dots-fill',
			369 => 'bi-chat-left-dots',
			370 => 'bi-chat-left-fill',
			371 => 'bi-chat-left-heart-fill',
			372 => 'bi-chat-left-heart',
			373 => 'bi-chat-left-quote-fill',
			374 => 'bi-chat-left-quote',
			375 => 'bi-chat-left-text-fill',
			376 => 'bi-chat-left-text',
			377 => 'bi-chat-left',
			378 => 'bi-chat-quote-fill',
			379 => 'bi-chat-quote',
			380 => 'bi-chat-right-dots-fill',
			381 => 'bi-chat-right-dots',
			382 => 'bi-chat-right-fill',
			383 => 'bi-chat-right-heart-fill',
			384 => 'bi-chat-right-heart',
			385 => 'bi-chat-right-quote-fill',
			386 => 'bi-chat-right-quote',
			387 => 'bi-chat-right-text-fill',
			388 => 'bi-chat-right-text',
			389 => 'bi-chat-right',
			390 => 'bi-chat-square-dots-fill',
			391 => 'bi-chat-square-dots',
			392 => 'bi-chat-square-fill',
			393 => 'bi-chat-square-heart-fill',
			394 => 'bi-chat-square-heart',
			395 => 'bi-chat-square-quote-fill',
			396 => 'bi-chat-square-quote',
			397 => 'bi-chat-square-text-fill',
			398 => 'bi-chat-square-text',
			399 => 'bi-chat-square',
			400 => 'bi-chat-text-fill',
			401 => 'bi-chat-text',
			402 => 'bi-chat',
			403 => 'bi-check-all',
			404 => 'bi-check-circle-fill',
			405 => 'bi-check-circle',
			406 => 'bi-check-lg',
			407 => 'bi-check-square-fill',
			408 => 'bi-check-square',
			409 => 'bi-check',
			410 => 'bi-check2-all',
			411 => 'bi-check2-circle',
			412 => 'bi-check2-square',
			413 => 'bi-check2',
			414 => 'bi-chevron-bar-contract',
			415 => 'bi-chevron-bar-down',
			416 => 'bi-chevron-bar-expand',
			417 => 'bi-chevron-bar-left',
			418 => 'bi-chevron-bar-right',
			419 => 'bi-chevron-bar-up',
			420 => 'bi-chevron-compact-down',
			421 => 'bi-chevron-compact-left',
			422 => 'bi-chevron-compact-right',
			423 => 'bi-chevron-compact-up',
			424 => 'bi-chevron-contract',
			425 => 'bi-chevron-double-down',
			426 => 'bi-chevron-double-left',
			427 => 'bi-chevron-double-right',
			428 => 'bi-chevron-double-up',
			429 => 'bi-chevron-down',
			430 => 'bi-chevron-expand',
			431 => 'bi-chevron-left',
			432 => 'bi-chevron-right',
			433 => 'bi-chevron-up',
			434 => 'bi-circle-fill',
			435 => 'bi-circle-half',
			436 => 'bi-circle-square',
			437 => 'bi-circle',
			438 => 'bi-clipboard-check-fill',
			439 => 'bi-clipboard-check',
			440 => 'bi-clipboard-data-fill',
			441 => 'bi-clipboard-data',
			442 => 'bi-clipboard-fill',
			443 => 'bi-clipboard-heart-fill',
			444 => 'bi-clipboard-heart',
			445 => 'bi-clipboard-minus-fill',
			446 => 'bi-clipboard-minus',
			447 => 'bi-clipboard-plus-fill',
			448 => 'bi-clipboard-plus',
			449 => 'bi-clipboard-pulse',
			450 => 'bi-clipboard-x-fill',
			451 => 'bi-clipboard-x',
			452 => 'bi-clipboard',
			453 => 'bi-clipboard2-check-fill',
			454 => 'bi-clipboard2-check',
			455 => 'bi-clipboard2-data-fill',
			456 => 'bi-clipboard2-data',
			457 => 'bi-clipboard2-fill',
			458 => 'bi-clipboard2-heart-fill',
			459 => 'bi-clipboard2-heart',
			460 => 'bi-clipboard2-minus-fill',
			461 => 'bi-clipboard2-minus',
			462 => 'bi-clipboard2-plus-fill',
			463 => 'bi-clipboard2-plus',
			464 => 'bi-clipboard2-pulse-fill',
			465 => 'bi-clipboard2-pulse',
			466 => 'bi-clipboard2-x-fill',
			467 => 'bi-clipboard2-x',
			468 => 'bi-clipboard2',
			469 => 'bi-clock-fill',
			470 => 'bi-clock-history',
			471 => 'bi-clock',
			472 => 'bi-cloud-arrow-down-fill',
			473 => 'bi-cloud-arrow-down',
			474 => 'bi-cloud-arrow-up-fill',
			475 => 'bi-cloud-arrow-up',
			476 => 'bi-cloud-check-fill',
			477 => 'bi-cloud-check',
			478 => 'bi-cloud-download-fill',
			479 => 'bi-cloud-download',
			480 => 'bi-cloud-drizzle-fill',
			481 => 'bi-cloud-drizzle',
			482 => 'bi-cloud-fill',
			483 => 'bi-cloud-fog-fill',
			484 => 'bi-cloud-fog',
			485 => 'bi-cloud-fog2-fill',
			486 => 'bi-cloud-fog2',
			487 => 'bi-cloud-hail-fill',
			488 => 'bi-cloud-hail',
			489 => 'bi-cloud-haze-fill',
			490 => 'bi-cloud-haze',
			491 => 'bi-cloud-haze2-fill',
			492 => 'bi-cloud-haze2',
			493 => 'bi-cloud-lightning-fill',
			494 => 'bi-cloud-lightning-rain-fill',
			495 => 'bi-cloud-lightning-rain',
			496 => 'bi-cloud-lightning',
			497 => 'bi-cloud-minus-fill',
			498 => 'bi-cloud-minus',
			499 => 'bi-cloud-moon-fill',
			500 => 'bi-cloud-moon',
			501 => 'bi-cloud-plus-fill',
			502 => 'bi-cloud-plus',
			503 => 'bi-cloud-rain-fill',
			504 => 'bi-cloud-rain-heavy-fill',
			505 => 'bi-cloud-rain-heavy',
			506 => 'bi-cloud-rain',
			507 => 'bi-cloud-slash-fill',
			508 => 'bi-cloud-slash',
			509 => 'bi-cloud-sleet-fill',
			510 => 'bi-cloud-sleet',
			511 => 'bi-cloud-snow-fill',
			512 => 'bi-cloud-snow',
			513 => 'bi-cloud-sun-fill',
			514 => 'bi-cloud-sun',
			515 => 'bi-cloud-upload-fill',
			516 => 'bi-cloud-upload',
			517 => 'bi-cloud',
			518 => 'bi-clouds-fill',
			519 => 'bi-clouds',
			520 => 'bi-cloudy-fill',
			521 => 'bi-cloudy',
			522 => 'bi-code-slash',
			523 => 'bi-code-square',
			524 => 'bi-code',
			525 => 'bi-coin',
			526 => 'bi-collection-fill',
			527 => 'bi-collection-play-fill',
			528 => 'bi-collection-play',
			529 => 'bi-collection',
			530 => 'bi-columns-gap',
			531 => 'bi-columns',
			532 => 'bi-command',
			533 => 'bi-compass-fill',
			534 => 'bi-compass',
			535 => 'bi-cone-striped',
			536 => 'bi-cone',
			537 => 'bi-controller',
			538 => 'bi-cpu-fill',
			539 => 'bi-cpu',
			540 => 'bi-credit-card-2-back-fill',
			541 => 'bi-credit-card-2-back',
			542 => 'bi-credit-card-2-front-fill',
			543 => 'bi-credit-card-2-front',
			544 => 'bi-credit-card-fill',
			545 => 'bi-credit-card',
			546 => 'bi-crop',
			547 => 'bi-cup-fill',
			548 => 'bi-cup-straw',
			549 => 'bi-cup',
			550 => 'bi-currency-bitcoin',
			551 => 'bi-currency-dollar',
			552 => 'bi-currency-euro',
			553 => 'bi-currency-exchange',
			554 => 'bi-currency-pound',
			555 => 'bi-currency-yen',
			556 => 'bi-cursor-fill',
			557 => 'bi-cursor-text',
			558 => 'bi-cursor',
			559 => 'bi-dash-circle-dotted',
			560 => 'bi-dash-circle-fill',
			561 => 'bi-dash-circle',
			562 => 'bi-dash-lg',
			563 => 'bi-dash-square-dotted',
			564 => 'bi-dash-square-fill',
			565 => 'bi-dash-square',
			566 => 'bi-dash',
			567 => 'bi-device-hdd-fill',
			568 => 'bi-device-hdd',
			569 => 'bi-device-ssd-fill',
			570 => 'bi-device-ssd',
			571 => 'bi-diagram-2-fill',
			572 => 'bi-diagram-2',
			573 => 'bi-diagram-3-fill',
			574 => 'bi-diagram-3',
			575 => 'bi-diamond-fill',
			576 => 'bi-diamond-half',
			577 => 'bi-diamond',
			578 => 'bi-dice-1-fill',
			579 => 'bi-dice-1',
			580 => 'bi-dice-2-fill',
			581 => 'bi-dice-2',
			582 => 'bi-dice-3-fill',
			583 => 'bi-dice-3',
			584 => 'bi-dice-4-fill',
			585 => 'bi-dice-4',
			586 => 'bi-dice-5-fill',
			587 => 'bi-dice-5',
			588 => 'bi-dice-6-fill',
			589 => 'bi-dice-6',
			590 => 'bi-disc-fill',
			591 => 'bi-disc',
			592 => 'bi-discord',
			593 => 'bi-display-fill',
			594 => 'bi-display',
			595 => 'bi-displayport-fill',
			596 => 'bi-displayport',
			597 => 'bi-distribute-horizontal',
			598 => 'bi-distribute-vertical',
			599 => 'bi-door-closed-fill',
			600 => 'bi-door-closed',
			601 => 'bi-door-open-fill',
			602 => 'bi-door-open',
			603 => 'bi-dot',
			604 => 'bi-download',
			605 => 'bi-dpad-fill',
			606 => 'bi-dpad',
			607 => 'bi-dribbble',
			608 => 'bi-droplet-fill',
			609 => 'bi-droplet-half',
			610 => 'bi-droplet',
			611 => 'bi-ear-fill',
			612 => 'bi-ear',
			613 => 'bi-earbuds',
			614 => 'bi-easel-fill',
			615 => 'bi-easel',
			616 => 'bi-easel2-fill',
			617 => 'bi-easel2',
			618 => 'bi-easel3-fill',
			619 => 'bi-easel3',
			620 => 'bi-egg-fill',
			621 => 'bi-egg-fried',
			622 => 'bi-egg',
			623 => 'bi-eject-fill',
			624 => 'bi-eject',
			625 => 'bi-emoji-angry-fill',
			626 => 'bi-emoji-angry',
			627 => 'bi-emoji-dizzy-fill',
			628 => 'bi-emoji-dizzy',
			629 => 'bi-emoji-expressionless-fill',
			630 => 'bi-emoji-expressionless',
			631 => 'bi-emoji-frown-fill',
			632 => 'bi-emoji-frown',
			633 => 'bi-emoji-heart-eyes-fill',
			634 => 'bi-emoji-heart-eyes',
			635 => 'bi-emoji-kiss-fill',
			636 => 'bi-emoji-kiss',
			637 => 'bi-emoji-laughing-fill',
			638 => 'bi-emoji-laughing',
			639 => 'bi-emoji-neutral-fill',
			640 => 'bi-emoji-neutral',
			641 => 'bi-emoji-smile-fill',
			642 => 'bi-emoji-smile-upside-down-fill',
			643 => 'bi-emoji-smile-upside-down',
			644 => 'bi-emoji-smile',
			645 => 'bi-emoji-sunglasses-fill',
			646 => 'bi-emoji-sunglasses',
			647 => 'bi-emoji-wink-fill',
			648 => 'bi-emoji-wink',
			649 => 'bi-envelope-check-fill',
			650 => 'bi-envelope-check',
			651 => 'bi-envelope-dash-fill',
			652 => 'bi-envelope-dash',
			653 => 'bi-envelope-exclamation-fill',
			654 => 'bi-envelope-exclamation',
			655 => 'bi-envelope-fill',
			656 => 'bi-envelope-heart-fill',
			657 => 'bi-envelope-heart',
			658 => 'bi-envelope-open-fill',
			659 => 'bi-envelope-open-heart-fill',
			660 => 'bi-envelope-open-heart',
			661 => 'bi-envelope-open',
			662 => 'bi-envelope-paper-fill',
			663 => 'bi-envelope-paper-heart-fill',
			664 => 'bi-envelope-paper-heart',
			665 => 'bi-envelope-paper',
			666 => 'bi-envelope-plus-fill',
			667 => 'bi-envelope-plus',
			668 => 'bi-envelope-slash-fill',
			669 => 'bi-envelope-slash',
			670 => 'bi-envelope-x-fill',
			671 => 'bi-envelope-x',
			672 => 'bi-envelope',
			673 => 'bi-eraser-fill',
			674 => 'bi-eraser',
			675 => 'bi-ethernet',
			676 => 'bi-exclamation-circle-fill',
			677 => 'bi-exclamation-circle',
			678 => 'bi-exclamation-diamond-fill',
			679 => 'bi-exclamation-diamond',
			680 => 'bi-exclamation-lg',
			681 => 'bi-exclamation-octagon-fill',
			682 => 'bi-exclamation-octagon',
			683 => 'bi-exclamation-square-fill',
			684 => 'bi-exclamation-square',
			685 => 'bi-exclamation-triangle-fill',
			686 => 'bi-exclamation-triangle',
			687 => 'bi-exclamation',
			688 => 'bi-exclude',
			689 => 'bi-explicit-fill',
			690 => 'bi-explicit',
			691 => 'bi-eye-fill',
			692 => 'bi-eye-slash-fill',
			693 => 'bi-eye-slash',
			694 => 'bi-eye',
			695 => 'bi-eyedropper',
			696 => 'bi-eyeglasses',
			697 => 'bi-facebook',
			698 => 'bi-fan',
			699 => 'bi-file-arrow-down-fill',
			700 => 'bi-file-arrow-down',
			701 => 'bi-file-arrow-up-fill',
			702 => 'bi-file-arrow-up',
			703 => 'bi-file-bar-graph-fill',
			704 => 'bi-file-bar-graph',
			705 => 'bi-file-binary-fill',
			706 => 'bi-file-binary',
			707 => 'bi-file-break-fill',
			708 => 'bi-file-break',
			709 => 'bi-file-check-fill',
			710 => 'bi-file-check',
			711 => 'bi-file-code-fill',
			712 => 'bi-file-code',
			713 => 'bi-file-diff-fill',
			714 => 'bi-file-diff',
			715 => 'bi-file-earmark-arrow-down-fill',
			716 => 'bi-file-earmark-arrow-down',
			717 => 'bi-file-earmark-arrow-up-fill',
			718 => 'bi-file-earmark-arrow-up',
			719 => 'bi-file-earmark-bar-graph-fill',
			720 => 'bi-file-earmark-bar-graph',
			721 => 'bi-file-earmark-binary-fill',
			722 => 'bi-file-earmark-binary',
			723 => 'bi-file-earmark-break-fill',
			724 => 'bi-file-earmark-break',
			725 => 'bi-file-earmark-check-fill',
			726 => 'bi-file-earmark-check',
			727 => 'bi-file-earmark-code-fill',
			728 => 'bi-file-earmark-code',
			729 => 'bi-file-earmark-diff-fill',
			730 => 'bi-file-earmark-diff',
			731 => 'bi-file-earmark-easel-fill',
			732 => 'bi-file-earmark-easel',
			733 => 'bi-file-earmark-excel-fill',
			734 => 'bi-file-earmark-excel',
			735 => 'bi-file-earmark-fill',
			736 => 'bi-file-earmark-font-fill',
			737 => 'bi-file-earmark-font',
			738 => 'bi-file-earmark-image-fill',
			739 => 'bi-file-earmark-image',
			740 => 'bi-file-earmark-lock-fill',
			741 => 'bi-file-earmark-lock',
			742 => 'bi-file-earmark-lock2-fill',
			743 => 'bi-file-earmark-lock2',
			744 => 'bi-file-earmark-medical-fill',
			745 => 'bi-file-earmark-medical',
			746 => 'bi-file-earmark-minus-fill',
			747 => 'bi-file-earmark-minus',
			748 => 'bi-file-earmark-music-fill',
			749 => 'bi-file-earmark-music',
			750 => 'bi-file-earmark-pdf-fill',
			751 => 'bi-file-earmark-pdf',
			752 => 'bi-file-earmark-person-fill',
			753 => 'bi-file-earmark-person',
			754 => 'bi-file-earmark-play-fill',
			755 => 'bi-file-earmark-play',
			756 => 'bi-file-earmark-plus-fill',
			757 => 'bi-file-earmark-plus',
			758 => 'bi-file-earmark-post-fill',
			759 => 'bi-file-earmark-post',
			760 => 'bi-file-earmark-ppt-fill',
			761 => 'bi-file-earmark-ppt',
			762 => 'bi-file-earmark-richtext-fill',
			763 => 'bi-file-earmark-richtext',
			764 => 'bi-file-earmark-ruled-fill',
			765 => 'bi-file-earmark-ruled',
			766 => 'bi-file-earmark-slides-fill',
			767 => 'bi-file-earmark-slides',
			768 => 'bi-file-earmark-spreadsheet-fill',
			769 => 'bi-file-earmark-spreadsheet',
			770 => 'bi-file-earmark-text-fill',
			771 => 'bi-file-earmark-text',
			772 => 'bi-file-earmark-word-fill',
			773 => 'bi-file-earmark-word',
			774 => 'bi-file-earmark-x-fill',
			775 => 'bi-file-earmark-x',
			776 => 'bi-file-earmark-zip-fill',
			777 => 'bi-file-earmark-zip',
			778 => 'bi-file-earmark',
			779 => 'bi-file-easel-fill',
			780 => 'bi-file-easel',
			781 => 'bi-file-excel-fill',
			782 => 'bi-file-excel',
			783 => 'bi-file-fill',
			784 => 'bi-file-font-fill',
			785 => 'bi-file-font',
			786 => 'bi-file-image-fill',
			787 => 'bi-file-image',
			788 => 'bi-file-lock-fill',
			789 => 'bi-file-lock',
			790 => 'bi-file-lock2-fill',
			791 => 'bi-file-lock2',
			792 => 'bi-file-medical-fill',
			793 => 'bi-file-medical',
			794 => 'bi-file-minus-fill',
			795 => 'bi-file-minus',
			796 => 'bi-file-music-fill',
			797 => 'bi-file-music',
			798 => 'bi-file-pdf-fill',
			799 => 'bi-file-pdf',
			800 => 'bi-file-person-fill',
			801 => 'bi-file-person',
			802 => 'bi-file-play-fill',
			803 => 'bi-file-play',
			804 => 'bi-file-plus-fill',
			805 => 'bi-file-plus',
			806 => 'bi-file-post-fill',
			807 => 'bi-file-post',
			808 => 'bi-file-ppt-fill',
			809 => 'bi-file-ppt',
			810 => 'bi-file-richtext-fill',
			811 => 'bi-file-richtext',
			812 => 'bi-file-ruled-fill',
			813 => 'bi-file-ruled',
			814 => 'bi-file-slides-fill',
			815 => 'bi-file-slides',
			816 => 'bi-file-spreadsheet-fill',
			817 => 'bi-file-spreadsheet',
			818 => 'bi-file-text-fill',
			819 => 'bi-file-text',
			820 => 'bi-file-word-fill',
			821 => 'bi-file-word',
			822 => 'bi-file-x-fill',
			823 => 'bi-file-x',
			824 => 'bi-file-zip-fill',
			825 => 'bi-file-zip',
			826 => 'bi-file',
			827 => 'bi-files-alt',
			828 => 'bi-files',
			829 => 'bi-filetype-aac',
			830 => 'bi-filetype-ai',
			831 => 'bi-filetype-bmp',
			832 => 'bi-filetype-cs',
			833 => 'bi-filetype-css',
			834 => 'bi-filetype-csv',
			835 => 'bi-filetype-doc',
			836 => 'bi-filetype-docx',
			837 => 'bi-filetype-exe',
			838 => 'bi-filetype-gif',
			839 => 'bi-filetype-heic',
			840 => 'bi-filetype-html',
			841 => 'bi-filetype-java',
			842 => 'bi-filetype-jpg',
			843 => 'bi-filetype-js',
			844 => 'bi-filetype-json',
			845 => 'bi-filetype-jsx',
			846 => 'bi-filetype-key',
			847 => 'bi-filetype-m4p',
			848 => 'bi-filetype-md',
			849 => 'bi-filetype-mdx',
			850 => 'bi-filetype-mov',
			851 => 'bi-filetype-mp3',
			852 => 'bi-filetype-mp4',
			853 => 'bi-filetype-otf',
			854 => 'bi-filetype-pdf',
			855 => 'bi-filetype-php',
			856 => 'bi-filetype-png',
			857 => 'bi-filetype-ppt',
			858 => 'bi-filetype-pptx',
			859 => 'bi-filetype-psd',
			860 => 'bi-filetype-py',
			861 => 'bi-filetype-raw',
			862 => 'bi-filetype-rb',
			863 => 'bi-filetype-sass',
			864 => 'bi-filetype-scss',
			865 => 'bi-filetype-sh',
			866 => 'bi-filetype-tiff',
			867 => 'bi-filetype-tsx',
			868 => 'bi-filetype-ttf',
			869 => 'bi-filetype-txt',
			870 => 'bi-filetype-wav',
			871 => 'bi-filetype-woff',
			872 => 'bi-filetype-xls',
			873 => 'bi-filetype-xlsx',
			874 => 'bi-filetype-xml',
			875 => 'bi-filetype-yml',
			876 => 'bi-film',
			877 => 'bi-filter-circle-fill',
			878 => 'bi-filter-circle',
			879 => 'bi-filter-left',
			880 => 'bi-filter-right',
			881 => 'bi-filter-square-fill',
			882 => 'bi-filter-square',
			883 => 'bi-filter',
			884 => 'bi-fingerprint',
			885 => 'bi-flag-fill',
			886 => 'bi-flag',
			887 => 'bi-flower1',
			888 => 'bi-flower2',
			889 => 'bi-flower3',
			890 => 'bi-folder-check',
			891 => 'bi-folder-fill',
			892 => 'bi-folder-minus',
			893 => 'bi-folder-plus',
			894 => 'bi-folder-symlink-fill',
			895 => 'bi-folder-symlink',
			896 => 'bi-folder-x',
			897 => 'bi-folder',
			898 => 'bi-folder2-open',
			899 => 'bi-folder2',
			900 => 'bi-fonts',
			901 => 'bi-forward-fill',
			902 => 'bi-forward',
			903 => 'bi-front',
			904 => 'bi-fullscreen-exit',
			905 => 'bi-fullscreen',
			906 => 'bi-funnel-fill',
			907 => 'bi-funnel',
			908 => 'bi-gear-fill',
			909 => 'bi-gear-wide-connected',
			910 => 'bi-gear-wide',
			911 => 'bi-gear',
			912 => 'bi-gem',
			913 => 'bi-gender-ambiguous',
			914 => 'bi-gender-female',
			915 => 'bi-gender-male',
			916 => 'bi-gender-trans',
			917 => 'bi-geo-alt-fill',
			918 => 'bi-geo-alt',
			919 => 'bi-geo-fill',
			920 => 'bi-geo',
			921 => 'bi-gift-fill',
			922 => 'bi-gift',
			923 => 'bi-git',
			924 => 'bi-github',
			925 => 'bi-globe',
			926 => 'bi-globe2',
			927 => 'bi-google',
			928 => 'bi-gpu-card',
			929 => 'bi-graph-down-arrow',
			930 => 'bi-graph-down',
			931 => 'bi-graph-up-arrow',
			932 => 'bi-graph-up',
			933 => 'bi-grid-1x2-fill',
			934 => 'bi-grid-1x2',
			935 => 'bi-grid-3x2-gap-fill',
			936 => 'bi-grid-3x2-gap',
			937 => 'bi-grid-3x2',
			938 => 'bi-grid-3x3-gap-fill',
			939 => 'bi-grid-3x3-gap',
			940 => 'bi-grid-3x3',
			941 => 'bi-grid-fill',
			942 => 'bi-grid',
			943 => 'bi-grip-horizontal',
			944 => 'bi-grip-vertical',
			945 => 'bi-hammer',
			946 => 'bi-hand-index-fill',
			947 => 'bi-hand-index-thumb-fill',
			948 => 'bi-hand-index-thumb',
			949 => 'bi-hand-index',
			950 => 'bi-hand-thumbs-down-fill',
			951 => 'bi-hand-thumbs-down',
			952 => 'bi-hand-thumbs-up-fill',
			953 => 'bi-hand-thumbs-up',
			954 => 'bi-handbag-fill',
			955 => 'bi-handbag',
			956 => 'bi-hash',
			957 => 'bi-hdd-fill',
			958 => 'bi-hdd-network-fill',
			959 => 'bi-hdd-network',
			960 => 'bi-hdd-rack-fill',
			961 => 'bi-hdd-rack',
			962 => 'bi-hdd-stack-fill',
			963 => 'bi-hdd-stack',
			964 => 'bi-hdd',
			965 => 'bi-hdmi-fill',
			966 => 'bi-hdmi',
			967 => 'bi-headphones',
			968 => 'bi-headset-vr',
			969 => 'bi-headset',
			970 => 'bi-heart-arrow',
			971 => 'bi-heart-fill',
			972 => 'bi-heart-half',
			973 => 'bi-heart-pulse-fill',
			974 => 'bi-heart-pulse',
			975 => 'bi-heart',
			976 => 'bi-heartbreak-fill',
			977 => 'bi-heartbreak',
			978 => 'bi-hearts',
			979 => 'bi-heptagon-fill',
			980 => 'bi-heptagon-half',
			981 => 'bi-heptagon',
			982 => 'bi-hexagon-fill',
			983 => 'bi-hexagon-half',
			984 => 'bi-hexagon',
			985 => 'bi-hospital-fill',
			986 => 'bi-hospital',
			987 => 'bi-hourglass-bottom',
			988 => 'bi-hourglass-split',
			989 => 'bi-hourglass-top',
			990 => 'bi-hourglass',
			991 => 'bi-house-door-fill',
			992 => 'bi-house-door',
			993 => 'bi-house-fill',
			994 => 'bi-house-heart-fill',
			995 => 'bi-house-heart',
			996 => 'bi-house',
			997 => 'bi-hr',
			998 => 'bi-hurricane',
			999 => 'bi-hypnotize',
			1000 => 'bi-image-alt',
			1001 => 'bi-image-fill',
			1002 => 'bi-image',
			1003 => 'bi-images',
			1004 => 'bi-inbox-fill',
			1005 => 'bi-inbox',
			1006 => 'bi-inboxes-fill',
			1007 => 'bi-inboxes',
			1008 => 'bi-incognito',
			1009 => 'bi-infinity',
			1010 => 'bi-info-circle-fill',
			1011 => 'bi-info-circle',
			1012 => 'bi-info-lg',
			1013 => 'bi-info-square-fill',
			1014 => 'bi-info-square',
			1015 => 'bi-info',
			1016 => 'bi-input-cursor-text',
			1017 => 'bi-input-cursor',
			1018 => 'bi-instagram',
			1019 => 'bi-intersect',
			1020 => 'bi-journal-album',
			1021 => 'bi-journal-arrow-down',
			1022 => 'bi-journal-arrow-up',
			1023 => 'bi-journal-bookmark-fill',
			1024 => 'bi-journal-bookmark',
			1025 => 'bi-journal-check',
			1026 => 'bi-journal-code',
			1027 => 'bi-journal-medical',
			1028 => 'bi-journal-minus',
			1029 => 'bi-journal-plus',
			1030 => 'bi-journal-richtext',
			1031 => 'bi-journal-text',
			1032 => 'bi-journal-x',
			1033 => 'bi-journal',
			1034 => 'bi-journals',
			1035 => 'bi-joystick',
			1036 => 'bi-justify-left',
			1037 => 'bi-justify-right',
			1038 => 'bi-justify',
			1039 => 'bi-kanban-fill',
			1040 => 'bi-kanban',
			1041 => 'bi-key-fill',
			1042 => 'bi-key',
			1043 => 'bi-keyboard-fill',
			1044 => 'bi-keyboard',
			1045 => 'bi-ladder',
			1046 => 'bi-lamp-fill',
			1047 => 'bi-lamp',
			1048 => 'bi-laptop-fill',
			1049 => 'bi-laptop',
			1050 => 'bi-layer-backward',
			1051 => 'bi-layer-forward',
			1052 => 'bi-layers-fill',
			1053 => 'bi-layers-half',
			1054 => 'bi-layers',
			1055 => 'bi-layout-sidebar-inset-reverse',
			1056 => 'bi-layout-sidebar-inset',
			1057 => 'bi-layout-sidebar-reverse',
			1058 => 'bi-layout-sidebar',
			1059 => 'bi-layout-split',
			1060 => 'bi-layout-text-sidebar-reverse',
			1061 => 'bi-layout-text-sidebar',
			1062 => 'bi-layout-text-window-reverse',
			1063 => 'bi-layout-text-window',
			1064 => 'bi-layout-three-columns',
			1065 => 'bi-layout-wtf',
			1066 => 'bi-life-preserver',
			1067 => 'bi-lightbulb-fill',
			1068 => 'bi-lightbulb-off-fill',
			1069 => 'bi-lightbulb-off',
			1070 => 'bi-lightbulb',
			1071 => 'bi-lightning-charge-fill',
			1072 => 'bi-lightning-charge',
			1073 => 'bi-lightning-fill',
			1074 => 'bi-lightning',
			1075 => 'bi-line',
			1076 => 'bi-link-45deg',
			1077 => 'bi-link',
			1078 => 'bi-linkedin',
			1079 => 'bi-list-check',
			1080 => 'bi-list-columns-reverse',
			1081 => 'bi-list-columns',
			1082 => 'bi-list-nested',
			1083 => 'bi-list-ol',
			1084 => 'bi-list-stars',
			1085 => 'bi-list-task',
			1086 => 'bi-list-ul',
			1087 => 'bi-list',
			1088 => 'bi-lock-fill',
			1089 => 'bi-lock',
			1090 => 'bi-magic',
			1091 => 'bi-magnet-fill',
			1092 => 'bi-magnet',
			1093 => 'bi-mailbox',
			1094 => 'bi-mailbox2',
			1095 => 'bi-map-fill',
			1096 => 'bi-map',
			1097 => 'bi-markdown-fill',
			1098 => 'bi-markdown',
			1099 => 'bi-mask',
			1100 => 'bi-mastodon',
			1101 => 'bi-medium',
			1102 => 'bi-megaphone-fill',
			1103 => 'bi-megaphone',
			1104 => 'bi-memory',
			1105 => 'bi-menu-app-fill',
			1106 => 'bi-menu-app',
			1107 => 'bi-menu-button-fill',
			1108 => 'bi-menu-button-wide-fill',
			1109 => 'bi-menu-button-wide',
			1110 => 'bi-menu-button',
			1111 => 'bi-menu-down',
			1112 => 'bi-menu-up',
			1113 => 'bi-messenger',
			1114 => 'bi-meta',
			1115 => 'bi-mic-fill',
			1116 => 'bi-mic-mute-fill',
			1117 => 'bi-mic-mute',
			1118 => 'bi-mic',
			1119 => 'bi-microsoft',
			1120 => 'bi-minecart-loaded',
			1121 => 'bi-minecart',
			1122 => 'bi-modem-fill',
			1123 => 'bi-modem',
			1124 => 'bi-moisture',
			1125 => 'bi-moon-fill',
			1126 => 'bi-moon-stars-fill',
			1127 => 'bi-moon-stars',
			1128 => 'bi-moon',
			1129 => 'bi-mortarboard-fill',
			1130 => 'bi-mortarboard',
			1131 => 'bi-motherboard-fill',
			1132 => 'bi-motherboard',
			1133 => 'bi-mouse-fill',
			1134 => 'bi-mouse',
			1135 => 'bi-mouse2-fill',
			1136 => 'bi-mouse2',
			1137 => 'bi-mouse3-fill',
			1138 => 'bi-mouse3',
			1139 => 'bi-music-note-beamed',
			1140 => 'bi-music-note-list',
			1141 => 'bi-music-note',
			1142 => 'bi-music-player-fill',
			1143 => 'bi-music-player',
			1144 => 'bi-newspaper',
			1145 => 'bi-nintendo-switch',
			1146 => 'bi-node-minus-fill',
			1147 => 'bi-node-minus',
			1148 => 'bi-node-plus-fill',
			1149 => 'bi-node-plus',
			1150 => 'bi-nut-fill',
			1151 => 'bi-nut',
			1152 => 'bi-octagon-fill',
			1153 => 'bi-octagon-half',
			1154 => 'bi-octagon',
			1155 => 'bi-optical-audio-fill',
			1156 => 'bi-optical-audio',
			1157 => 'bi-option',
			1158 => 'bi-outlet',
			1159 => 'bi-paint-bucket',
			1160 => 'bi-palette-fill',
			1161 => 'bi-palette',
			1162 => 'bi-palette2',
			1163 => 'bi-paperclip',
			1164 => 'bi-paragraph',
			1165 => 'bi-patch-check-fill',
			1166 => 'bi-patch-check',
			1167 => 'bi-patch-exclamation-fill',
			1168 => 'bi-patch-exclamation',
			1169 => 'bi-patch-minus-fill',
			1170 => 'bi-patch-minus',
			1171 => 'bi-patch-plus-fill',
			1172 => 'bi-patch-plus',
			1173 => 'bi-patch-question-fill',
			1174 => 'bi-patch-question',
			1175 => 'bi-pause-btn-fill',
			1176 => 'bi-pause-btn',
			1177 => 'bi-pause-circle-fill',
			1178 => 'bi-pause-circle',
			1179 => 'bi-pause-fill',
			1180 => 'bi-pause',
			1181 => 'bi-paypal',
			1182 => 'bi-pc-display-horizontal',
			1183 => 'bi-pc-display',
			1184 => 'bi-pc-horizontal',
			1185 => 'bi-pc',
			1186 => 'bi-pci-card',
			1187 => 'bi-peace-fill',
			1188 => 'bi-peace',
			1189 => 'bi-pen-fill',
			1190 => 'bi-pen',
			1191 => 'bi-pencil-fill',
			1192 => 'bi-pencil-square',
			1193 => 'bi-pencil',
			1194 => 'bi-pentagon-fill',
			1195 => 'bi-pentagon-half',
			1196 => 'bi-pentagon',
			1197 => 'bi-people-fill',
			1198 => 'bi-people',
			1199 => 'bi-percent',
			1200 => 'bi-person-badge-fill',
			1201 => 'bi-person-badge',
			1202 => 'bi-person-bounding-box',
			1203 => 'bi-person-check-fill',
			1204 => 'bi-person-check',
			1205 => 'bi-person-circle',
			1206 => 'bi-person-dash-fill',
			1207 => 'bi-person-dash',
			1208 => 'bi-person-fill',
			1209 => 'bi-person-heart',
			1210 => 'bi-person-hearts',
			1211 => 'bi-person-lines-fill',
			1212 => 'bi-person-plus-fill',
			1213 => 'bi-person-plus',
			1214 => 'bi-person-rolodex',
			1215 => 'bi-person-square',
			1216 => 'bi-person-video',
			1217 => 'bi-person-video2',
			1218 => 'bi-person-video3',
			1219 => 'bi-person-workspace',
			1220 => 'bi-person-x-fill',
			1221 => 'bi-person-x',
			1222 => 'bi-person',
			1223 => 'bi-phone-fill',
			1224 => 'bi-phone-flip',
			1225 => 'bi-phone-landscape-fill',
			1226 => 'bi-phone-landscape',
			1227 => 'bi-phone-vibrate-fill',
			1228 => 'bi-phone-vibrate',
			1229 => 'bi-phone',
			1230 => 'bi-pie-chart-fill',
			1231 => 'bi-pie-chart',
			1232 => 'bi-piggy-bank-fill',
			1233 => 'bi-piggy-bank',
			1234 => 'bi-pin-angle-fill',
			1235 => 'bi-pin-angle',
			1236 => 'bi-pin-fill',
			1237 => 'bi-pin-map-fill',
			1238 => 'bi-pin-map',
			1239 => 'bi-pin',
			1240 => 'bi-pinterest',
			1241 => 'bi-pip-fill',
			1242 => 'bi-pip',
			1243 => 'bi-play-btn-fill',
			1244 => 'bi-play-btn',
			1245 => 'bi-play-circle-fill',
			1246 => 'bi-play-circle',
			1247 => 'bi-play-fill',
			1248 => 'bi-play',
			1249 => 'bi-playstation',
			1250 => 'bi-plug-fill',
			1251 => 'bi-plug',
			1252 => 'bi-plugin',
			1253 => 'bi-plus-circle-dotted',
			1254 => 'bi-plus-circle-fill',
			1255 => 'bi-plus-circle',
			1256 => 'bi-plus-lg',
			1257 => 'bi-plus-slash-minus',
			1258 => 'bi-plus-square-dotted',
			1259 => 'bi-plus-square-fill',
			1260 => 'bi-plus-square',
			1261 => 'bi-plus',
			1262 => 'bi-postage-fill',
			1263 => 'bi-postage-heart-fill',
			1264 => 'bi-postage-heart',
			1265 => 'bi-postage',
			1266 => 'bi-postcard-fill',
			1267 => 'bi-postcard-heart-fill',
			1268 => 'bi-postcard-heart',
			1269 => 'bi-postcard',
			1270 => 'bi-power',
			1271 => 'bi-printer-fill',
			1272 => 'bi-printer',
			1273 => 'bi-projector-fill',
			1274 => 'bi-projector',
			1275 => 'bi-puzzle-fill',
			1276 => 'bi-puzzle',
			1277 => 'bi-qr-code-scan',
			1278 => 'bi-qr-code',
			1279 => 'bi-question-circle-fill',
			1280 => 'bi-question-circle',
			1281 => 'bi-question-diamond-fill',
			1282 => 'bi-question-diamond',
			1283 => 'bi-question-lg',
			1284 => 'bi-question-octagon-fill',
			1285 => 'bi-question-octagon',
			1286 => 'bi-question-square-fill',
			1287 => 'bi-question-square',
			1288 => 'bi-question',
			1289 => 'bi-quora',
			1290 => 'bi-quote',
			1291 => 'bi-radioactive',
			1292 => 'bi-rainbow',
			1293 => 'bi-receipt-cutoff',
			1294 => 'bi-receipt',
			1295 => 'bi-reception-0',
			1296 => 'bi-reception-1',
			1297 => 'bi-reception-2',
			1298 => 'bi-reception-3',
			1299 => 'bi-reception-4',
			1300 => 'bi-record-btn-fill',
			1301 => 'bi-record-btn',
			1302 => 'bi-record-circle-fill',
			1303 => 'bi-record-circle',
			1304 => 'bi-record-fill',
			1305 => 'bi-record',
			1306 => 'bi-record2-fill',
			1307 => 'bi-record2',
			1308 => 'bi-recycle',
			1309 => 'bi-reddit',
			1310 => 'bi-reply-all-fill',
			1311 => 'bi-reply-all',
			1312 => 'bi-reply-fill',
			1313 => 'bi-reply',
			1314 => 'bi-robot',
			1315 => 'bi-router-fill',
			1316 => 'bi-router',
			1317 => 'bi-rss-fill',
			1318 => 'bi-rss',
			1319 => 'bi-rulers',
			1320 => 'bi-safe-fill',
			1321 => 'bi-safe',
			1322 => 'bi-safe2-fill',
			1323 => 'bi-safe2',
			1324 => 'bi-save-fill',
			1325 => 'bi-save',
			1326 => 'bi-save2-fill',
			1327 => 'bi-save2',
			1328 => 'bi-scissors',
			1329 => 'bi-screwdriver',
			1330 => 'bi-sd-card-fill',
			1331 => 'bi-sd-card',
			1332 => 'bi-search-heart-fill',
			1333 => 'bi-search-heart',
			1334 => 'bi-search',
			1335 => 'bi-segmented-nav',
			1336 => 'bi-send-check-fill',
			1337 => 'bi-send-check',
			1338 => 'bi-send-dash-fill',
			1339 => 'bi-send-dash',
			1340 => 'bi-send-exclamation-fill',
			1341 => 'bi-send-exclamation',
			1342 => 'bi-send-fill',
			1343 => 'bi-send-plus-fill',
			1344 => 'bi-send-plus',
			1345 => 'bi-send-slash-fill',
			1346 => 'bi-send-slash',
			1347 => 'bi-send-x-fill',
			1348 => 'bi-send-x',
			1349 => 'bi-send',
			1350 => 'bi-server',
			1351 => 'bi-share-fill',
			1352 => 'bi-share',
			1353 => 'bi-shield-check',
			1354 => 'bi-shield-exclamation',
			1355 => 'bi-shield-fill-check',
			1356 => 'bi-shield-fill-exclamation',
			1357 => 'bi-shield-fill-minus',
			1358 => 'bi-shield-fill-plus',
			1359 => 'bi-shield-fill-x',
			1360 => 'bi-shield-fill',
			1361 => 'bi-shield-lock-fill',
			1362 => 'bi-shield-lock',
			1363 => 'bi-shield-minus',
			1364 => 'bi-shield-plus',
			1365 => 'bi-shield-shaded',
			1366 => 'bi-shield-slash-fill',
			1367 => 'bi-shield-slash',
			1368 => 'bi-shield-x',
			1369 => 'bi-shield',
			1370 => 'bi-shift-fill',
			1371 => 'bi-shift',
			1372 => 'bi-shop-window',
			1373 => 'bi-shop',
			1374 => 'bi-shuffle',
			1375 => 'bi-signal',
			1376 => 'bi-signpost-2-fill',
			1377 => 'bi-signpost-2',
			1378 => 'bi-signpost-fill',
			1379 => 'bi-signpost-split-fill',
			1380 => 'bi-signpost-split',
			1381 => 'bi-signpost',
			1382 => 'bi-sim-fill',
			1383 => 'bi-sim',
			1384 => 'bi-skip-backward-btn-fill',
			1385 => 'bi-skip-backward-btn',
			1386 => 'bi-skip-backward-circle-fill',
			1387 => 'bi-skip-backward-circle',
			1388 => 'bi-skip-backward-fill',
			1389 => 'bi-skip-backward',
			1390 => 'bi-skip-end-btn-fill',
			1391 => 'bi-skip-end-btn',
			1392 => 'bi-skip-end-circle-fill',
			1393 => 'bi-skip-end-circle',
			1394 => 'bi-skip-end-fill',
			1395 => 'bi-skip-end',
			1396 => 'bi-skip-forward-btn-fill',
			1397 => 'bi-skip-forward-btn',
			1398 => 'bi-skip-forward-circle-fill',
			1399 => 'bi-skip-forward-circle',
			1400 => 'bi-skip-forward-fill',
			1401 => 'bi-skip-forward',
			1402 => 'bi-skip-start-btn-fill',
			1403 => 'bi-skip-start-btn',
			1404 => 'bi-skip-start-circle-fill',
			1405 => 'bi-skip-start-circle',
			1406 => 'bi-skip-start-fill',
			1407 => 'bi-skip-start',
			1408 => 'bi-skype',
			1409 => 'bi-slack',
			1410 => 'bi-slash-circle-fill',
			1411 => 'bi-slash-circle',
			1412 => 'bi-slash-lg',
			1413 => 'bi-slash-square-fill',
			1414 => 'bi-slash-square',
			1415 => 'bi-slash',
			1416 => 'bi-sliders',
			1417 => 'bi-sliders2-vertical',
			1418 => 'bi-sliders2',
			1419 => 'bi-smartwatch',
			1420 => 'bi-snapchat',
			1421 => 'bi-snow',
			1422 => 'bi-snow2',
			1423 => 'bi-snow3',
			1424 => 'bi-sort-alpha-down-alt',
			1425 => 'bi-sort-alpha-down',
			1426 => 'bi-sort-alpha-up-alt',
			1427 => 'bi-sort-alpha-up',
			1428 => 'bi-sort-down-alt',
			1429 => 'bi-sort-down',
			1430 => 'bi-sort-numeric-down-alt',
			1431 => 'bi-sort-numeric-down',
			1432 => 'bi-sort-numeric-up-alt',
			1433 => 'bi-sort-numeric-up',
			1434 => 'bi-sort-up-alt',
			1435 => 'bi-sort-up',
			1436 => 'bi-soundwave',
			1437 => 'bi-speaker-fill',
			1438 => 'bi-speaker',
			1439 => 'bi-speedometer',
			1440 => 'bi-speedometer2',
			1441 => 'bi-spellcheck',
			1442 => 'bi-spotify',
			1443 => 'bi-square-fill',
			1444 => 'bi-square-half',
			1445 => 'bi-square',
			1446 => 'bi-stack-overflow',
			1447 => 'bi-stack',
			1448 => 'bi-star-fill',
			1449 => 'bi-star-half',
			1450 => 'bi-star',
			1451 => 'bi-stars',
			1452 => 'bi-steam',
			1453 => 'bi-stickies-fill',
			1454 => 'bi-stickies',
			1455 => 'bi-sticky-fill',
			1456 => 'bi-sticky',
			1457 => 'bi-stop-btn-fill',
			1458 => 'bi-stop-btn',
			1459 => 'bi-stop-circle-fill',
			1460 => 'bi-stop-circle',
			1461 => 'bi-stop-fill',
			1462 => 'bi-stop',
			1463 => 'bi-stoplights-fill',
			1464 => 'bi-stoplights',
			1465 => 'bi-stopwatch-fill',
			1466 => 'bi-stopwatch',
			1467 => 'bi-strava',
			1468 => 'bi-subtract',
			1469 => 'bi-suit-club-fill',
			1470 => 'bi-suit-club',
			1471 => 'bi-suit-diamond-fill',
			1472 => 'bi-suit-diamond',
			1473 => 'bi-suit-heart-fill',
			1474 => 'bi-suit-heart',
			1475 => 'bi-suit-spade-fill',
			1476 => 'bi-suit-spade',
			1477 => 'bi-sun-fill',
			1478 => 'bi-sun',
			1479 => 'bi-sunglasses',
			1480 => 'bi-sunrise-fill',
			1481 => 'bi-sunrise',
			1482 => 'bi-sunset-fill',
			1483 => 'bi-sunset',
			1484 => 'bi-symmetry-horizontal',
			1485 => 'bi-symmetry-vertical',
			1486 => 'bi-table',
			1487 => 'bi-tablet-fill',
			1488 => 'bi-tablet-landscape-fill',
			1489 => 'bi-tablet-landscape',
			1490 => 'bi-tablet',
			1491 => 'bi-tag-fill',
			1492 => 'bi-tag',
			1493 => 'bi-tags-fill',
			1494 => 'bi-tags',
			1495 => 'bi-telegram',
			1496 => 'bi-telephone-fill',
			1497 => 'bi-telephone-forward-fill',
			1498 => 'bi-telephone-forward',
			1499 => 'bi-telephone-inbound-fill',
			1500 => 'bi-telephone-inbound',
			1501 => 'bi-telephone-minus-fill',
			1502 => 'bi-telephone-minus',
			1503 => 'bi-telephone-outbound-fill',
			1504 => 'bi-telephone-outbound',
			1505 => 'bi-telephone-plus-fill',
			1506 => 'bi-telephone-plus',
			1507 => 'bi-telephone-x-fill',
			1508 => 'bi-telephone-x',
			1509 => 'bi-telephone',
			1510 => 'bi-terminal-dash',
			1511 => 'bi-terminal-fill',
			1512 => 'bi-terminal-plus',
			1513 => 'bi-terminal-split',
			1514 => 'bi-terminal-x',
			1515 => 'bi-terminal',
			1516 => 'bi-text-center',
			1517 => 'bi-text-indent-left',
			1518 => 'bi-text-indent-right',
			1519 => 'bi-text-left',
			1520 => 'bi-text-paragraph',
			1521 => 'bi-text-right',
			1522 => 'bi-textarea-resize',
			1523 => 'bi-textarea-t',
			1524 => 'bi-textarea',
			1525 => 'bi-thermometer-half',
			1526 => 'bi-thermometer-high',
			1527 => 'bi-thermometer-low',
			1528 => 'bi-thermometer-snow',
			1529 => 'bi-thermometer-sun',
			1530 => 'bi-thermometer',
			1531 => 'bi-three-dots-vertical',
			1532 => 'bi-three-dots',
			1533 => 'bi-thunderbolt-fill',
			1534 => 'bi-thunderbolt',
			1535 => 'bi-ticket-detailed-fill',
			1536 => 'bi-ticket-detailed',
			1537 => 'bi-ticket-fill',
			1538 => 'bi-ticket-perforated-fill',
			1539 => 'bi-ticket-perforated',
			1540 => 'bi-ticket',
			1541 => 'bi-tiktok',
			1542 => 'bi-toggle-off',
			1543 => 'bi-toggle-on',
			1544 => 'bi-toggle2-off',
			1545 => 'bi-toggle2-on',
			1546 => 'bi-toggles',
			1547 => 'bi-toggles2',
			1548 => 'bi-tools',
			1549 => 'bi-tornado',
			1550 => 'bi-translate',
			1551 => 'bi-trash-fill',
			1552 => 'bi-trash',
			1553 => 'bi-trash2-fill',
			1554 => 'bi-trash2',
			1555 => 'bi-trash3-fill',
			1556 => 'bi-trash3',
			1557 => 'bi-tree-fill',
			1558 => 'bi-tree',
			1559 => 'bi-triangle-fill',
			1560 => 'bi-triangle-half',
			1561 => 'bi-triangle',
			1562 => 'bi-trophy-fill',
			1563 => 'bi-trophy',
			1564 => 'bi-tropical-storm',
			1565 => 'bi-truck-flatbed',
			1566 => 'bi-truck',
			1567 => 'bi-tsunami',
			1568 => 'bi-tv-fill',
			1569 => 'bi-tv',
			1570 => 'bi-twitch',
			1571 => 'bi-twitter',
			1572 => 'bi-type-bold',
			1573 => 'bi-type-h1',
			1574 => 'bi-type-h2',
			1575 => 'bi-type-h3',
			1576 => 'bi-type-italic',
			1577 => 'bi-type-strikethrough',
			1578 => 'bi-type-underline',
			1579 => 'bi-type',
			1580 => 'bi-ui-checks-grid',
			1581 => 'bi-ui-checks',
			1582 => 'bi-ui-radios-grid',
			1583 => 'bi-ui-radios',
			1584 => 'bi-umbrella-fill',
			1585 => 'bi-umbrella',
			1586 => 'bi-union',
			1587 => 'bi-unlock-fill',
			1588 => 'bi-unlock',
			1589 => 'bi-upc-scan',
			1590 => 'bi-upc',
			1591 => 'bi-upload',
			1592 => 'bi-usb-c-fill',
			1593 => 'bi-usb-c',
			1594 => 'bi-usb-drive-fill',
			1595 => 'bi-usb-drive',
			1596 => 'bi-usb-fill',
			1597 => 'bi-usb-micro-fill',
			1598 => 'bi-usb-micro',
			1599 => 'bi-usb-mini-fill',
			1600 => 'bi-usb-mini',
			1601 => 'bi-usb-plug-fill',
			1602 => 'bi-usb-plug',
			1603 => 'bi-usb-symbol',
			1604 => 'bi-usb',
			1605 => 'bi-valentine',
			1606 => 'bi-valentine2',
			1607 => 'bi-vector-pen',
			1608 => 'bi-view-list',
			1609 => 'bi-view-stacked',
			1610 => 'bi-vimeo',
			1611 => 'bi-vinyl-fill',
			1612 => 'bi-vinyl',
			1613 => 'bi-voicemail',
			1614 => 'bi-volume-down-fill',
			1615 => 'bi-volume-down',
			1616 => 'bi-volume-mute-fill',
			1617 => 'bi-volume-mute',
			1618 => 'bi-volume-off-fill',
			1619 => 'bi-volume-off',
			1620 => 'bi-volume-up-fill',
			1621 => 'bi-volume-up',
			1622 => 'bi-vr',
			1623 => 'bi-wallet-fill',
			1624 => 'bi-wallet',
			1625 => 'bi-wallet2',
			1626 => 'bi-watch',
			1627 => 'bi-water',
			1628 => 'bi-webcam-fill',
			1629 => 'bi-webcam',
			1630 => 'bi-whatsapp',
			1631 => 'bi-wifi-1',
			1632 => 'bi-wifi-2',
			1633 => 'bi-wifi-off',
			1634 => 'bi-wifi',
			1635 => 'bi-wind',
			1636 => 'bi-window-dash',
			1637 => 'bi-window-desktop',
			1638 => 'bi-window-dock',
			1639 => 'bi-window-fullscreen',
			1640 => 'bi-window-plus',
			1641 => 'bi-window-sidebar',
			1642 => 'bi-window-split',
			1643 => 'bi-window-stack',
			1644 => 'bi-window-x',
			1645 => 'bi-window',
			1646 => 'bi-windows',
			1647 => 'bi-wordpress',
			1648 => 'bi-wrench-adjustable-circle-fill',
			1649 => 'bi-wrench-adjustable-circle',
			1650 => 'bi-wrench-adjustable',
			1651 => 'bi-wrench',
			1652 => 'bi-x-circle-fill',
			1653 => 'bi-x-circle',
			1654 => 'bi-x-diamond-fill',
			1655 => 'bi-x-diamond',
			1656 => 'bi-x-lg',
			1657 => 'bi-x-octagon-fill',
			1658 => 'bi-x-octagon',
			1659 => 'bi-x-square-fill',
			1660 => 'bi-x-square',
			1661 => 'bi-x',
			1662 => 'bi-xbox',
			1663 => 'bi-yin-yang',
			1664 => 'bi-youtube',
			1665 => 'bi-zoom-in',
			1666 => 'bi-zoom-out',
		);

		return apply_filters( 'nevo/customizer/font_icons/bootstrap_icons', $icons );
	}
}