<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_single_blog_config' ) ) {
	function nevo_customizer_single_blog_config( $configs = array() ) {

		$panel    = 'blog_panel';
		$section  = 'post_single';
		$selector = '.single-post .site-main';
		$cb       = 'nevo_display_content';
		$config = array(
			
			array(
				'name'  => 'post_single',
				'type'  => 'section',
				'panel' => $panel,
				'priority' => 50,
				'title' => __( 'Single Post', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_page_header_layout',
				'type'            => 'radio_group',
				'section'         => $section,
				'title'           => __( 'Page Header Layout', 'nevo' ),
				'selector'        => '.single-post .page-header .nevo-container',
				'css_format'      => 'html_class',
				'default'         => 'normal',
				'choices'         => array(
					'normal'      => __( 'Contained', 'nevo' ),
					'cv-mw-100'   => __( 'Full Width', 'nevo' ),
				),
				'priority' 		  => 15,
			),
			
			array(
				'name'            => $section . '_page_header_display',
				'type'            => 'select',
				'section'         => $section,
				'device_settings' => false,
				'selector'        => '.single-post .page-header',
				'default'         => 'after',
				'label'           => __( 'Page Header Display', 'nevo' ),
				'description'     => __( 'Choose position "Before Content" only applies to "Content Layout" 1 and 7.', 'nevo' ),
				'choices'         => array(
					'disable' 	=> __( 'Disable', 'nevo' ),
					'before' 	=> __( 'Before Content', 'nevo' ),
					'after' 	=> __( 'After Header', 'nevo' ),
				),
				'priority' 		  => 16,
			),
			
			array(
				'name'            => $section . 'one_containers_padding',
				'type'            => 'css_ruler',
				'section'         => $section,
				'priority' 		  => 18,
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'right'  => 'padding-right: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
					'left'   => 'padding-left: {{value}};',
				),
				'selector'        => '.single-post .one-container .site-main .inside-page-header',
				'required'   => array(
					array( 'content_layout', '=', 'one-container' ),
					array( $section . '_page_header_display', '=', 'before' )
				),
			),
			
			array(
				'name'            => $section . '_disable_breadcrumb',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => '.page-header',
				'default'         => 0,
				'priority' 		  => 20,
				'title'  		  => __( 'Disable Breadcrumb', 'nevo' ),
			),
			
			array(
				'name'       => $section . '_page_header_style',
				'type'       => 'modal',
				'priority'   => 25,
				'section'    => $section,
				'title'      => __( 'Page Header Styling', 'nevo' ),
				'selector'   => 'body.single-post .page-header',
				'css_format' => 'styling',
				'fields'     => array(
					'tabs'          => array(
						'normal' => __( 'Normal', 'nevo' ),
					),
					'normal_fields' => array(
						array(
							'name'       => $section . '_text_color',
							'type'       => 'color',
							'label'      => __( 'Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.single-post .page-header .inside-page-header, body.single-post .page-header .entry-title, body.single-post .page-header .entry-meta',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_link_color',
							'type'       => 'color',
							'label'      => __( 'Link Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.single-post .page-header .inside-page-header a',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_hover_link_color',
							'type'       => 'color',
							'label'      => __( 'Link Color Hover', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.single-post .page-header .inside-page-header a:hover, body.single-post .page-header .inside-page-header a:focus',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						
						array(
							'name'  => $section . '_bg_heading',
							'type'  => 'heading',
							'label' => __( 'Background', 'nevo' ),
						),
						
						array(
							'name'       => $section . '_bg_color',
							'type'       => 'color',
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => 'body.single-post .page-header',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => $section . '_bg_overlay_color',
							'type'       => 'color',
							'label'      => __( 'Background overlay color', 'nevo' ),
							'selector'   => 'body.single-post .page-header:before',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => $section . '_bg_cover',
							'type'       => 'select',
							'default'    => 'cover',
							'choices'    => array(
								''        => __( 'Default', 'nevo' ),
								'auto'    => __( 'Auto', 'nevo' ),
								'cover'   => __( 'Cover', 'nevo' ),
								'contain' => __( 'Contain', 'nevo' ),
							),
							'label'      => __( 'Size', 'nevo' ),
							'class'      => 'field-half-left',
							'selector'   => 'body.single-post .page-header',
							'css_format' => '-webkit-background-size: {{value}}; -moz-background-size: {{value}}; -o-background-size: {{value}}; background-size: {{value}};',
						),
						array(
							'name'       => $section . '_bg_position',
							'type'       => 'select',
							'label'      => __( 'Position', 'nevo' ),
							'class'      => 'field-half-right',
							'default'    => 'center',
							'choices'    => array(
								''              => __( 'Default', 'nevo' ),
								'center'        => __( 'Center', 'nevo' ),
								'top left'      => __( 'Top Left', 'nevo' ),
								'top right'     => __( 'Top Right', 'nevo' ),
								'top center'    => __( 'Top Center', 'nevo' ),
								'bottom left'   => __( 'Bottom Left', 'nevo' ),
								'bottom center' => __( 'Bottom Center', 'nevo' ),
								'bottom right'  => __( 'Bottom Right', 'nevo' ),
							),
							'selector'   => 'body.single-post .page-header',
							'css_format' => 'background-position: {{value}};',
						),
						array(
							'name'       => $section . '_bg_repeat',
							'type'       => 'select',
							'label'      => __( 'Repeat', 'nevo' ),
							'class'      => 'field-half-left',
							'default'    => 'no-repeat',
							'choices'    => array(
								'repeat'    => __( 'Default', 'nevo' ),
								'no-repeat' => __( 'No repeat', 'nevo' ),
								'repeat-x'  => __( 'Repeat horizontal', 'nevo' ),
								'repeat-y'  => __( 'Repeat vertical', 'nevo' ),
							),
							'selector'   => 'body.single-post .page-header',
							'css_format' => 'background-repeat: {{value}};',
						),

						array(
							'name'       => $section . '_bg_attachment',
							'type'       => 'select',
							'label'      => __( 'Attachment', 'nevo' ),
							'class'      => 'field-half-right',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'scroll' => __( 'Scroll', 'nevo' ),
								'fixed'  => __( 'Fixed', 'nevo' ),
							),
							'selector'   => 'body.single-post .page-header',
							'css_format' => 'background-attachment: {{value}};',
						),
					),
				),
			),
			
			array(
				'name'    => $section . '_h_layout',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 30,
				'title'   => __( 'Layouts', 'nevo' ),
			),
			
			array(
				'name'    => $section . '_sidebar_layout',
				'type'    => 'image_select',
				'priority' => 32,
				'default' => 'right-sidebar',
				'section' => $section,
				'title'   => __( 'Sidebar Layout', 'nevo' ),
				'choices' => nevo_get_sidebar_layouts(),
			),
			
			array(
				'name'    => $section . '_layout',
				'type'    => 'image_select',
				'priority' => 35,
				'default' => 'single-post-1',
				'section' => $section,
				'title'   => __( 'Content Layout', 'nevo' ),
				'choices' => nevo_get_post_single_content_layouts(),
			),
			
			array(
				'name'            => $section . '_layout_4_padding',
				'type'            => 'css_ruler',
				'section'         => $section,
				'priority' 		  => 38,
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'default'         => array(
					'desktop' 	 => array(
						'top'    => 300,
						'bottom' => 30,
					),
					'tablet'  	 => array(
						'top'    => 200,
						'bottom' => 30,
					),
					'mobile'  	 => array(
						'top'    => 100,
						'bottom' => 30,
					),
				),
				'fields_disabled' => array(
					'left'  => '',
					'right' => '',
				),
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
				),
				'selector'        => '.single-post-4 .page-header .inside-page-header',
				'required' 		  => array( $section . '_layout', '=', 'single-post-4' ),
			),
			
			array(
				'name'            => $section . '_layout_5_padding',
				'type'            => 'css_ruler',
				'section'         => $section,
				'priority' 		  => 39,
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'default'         => array(
					'desktop' 	 => array(
						'top'    => 150,
						'bottom' => 150,
					),
					'tablet'  	 => array(
						'top'    => 80,
						'bottom' => 80,
					),
					'mobile'  	 => array(
						'top'    => 50,
						'bottom' => 50,
					),
				),
				'fields_disabled' => array(
					'left'  => '',
					'right' => '',
				),
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
				),
				'selector'        => '.single-post-5 .page-header .inside-page-header',
				'required' 		  => array( $section . '_layout', '=', 'single-post-5' ),
			),
			
			array(
				'name'            => $section . '_layout_6_padding',
				'type'            => 'css_ruler',
				'section'         => $section,
				'priority' 		  => 40,
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'default'         => array(
					'desktop' 	 => array(
						'top'    => 300,
						'bottom' => 100,
					),
					'tablet'  	 => array(
						'top'    => 200,
						'bottom' => 100,
					),
					'mobile'  	 => array(
						'top'    => 100,
						'bottom' => 100,
					),
				),
				'fields_disabled' => array(
					'left'  => '',
					'right' => '',
				),
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
				),
				'selector'        => '.single-post-6 .page-header .inside-page-header',
				'required' 		  => array( $section . '_layout', '=', 'single-post-6' ),
			),
			
			array(
				'name'            => $section . '_layout_padding',
				'type'            => 'css_ruler',
				'section'         => $section,
				'priority' 		  => 41,
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'fields_disabled' => array(
					'left'  => '',
					'right' => '',
				),
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
				),
				'selector'        => '.single-post .page-header .inside-page-header',
				'required' 		  => array( $section . '_layout', '=',	array( 'single-post-1', 'single-post-2', 'single-post-3', 'single-post-7', 'single-post-8', 'single-post-9', 'single-post-10' ) ),
			),
			
			array(
				'name'        => $section . '_typography',
				'type'        => 'typography',
				'section'     => $section,
				'priority' 	  => 55,
				'title'       => __( 'Title Typography', 'nevo' ),
				'css_format'  => 'typography',
				'selector'    => "{$selector} .entry-title, .single-post .page-header .entry-title",
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
			),
			
			array(
				'name'            => $section . '_header_entry_align',
				'type'            => 'text_align_no_justify',
				'section'         => $section,
				'priority' 		  => 60,
				'device_settings' => true,
				'selector'   	  => "{$selector} .entry-header, .single-post .no-sidebar .page-header",
				'css_format'      => 'text-align: {{value}};',
				'title'           => __( 'Align', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_categories',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 65,
				'default'         => 1,
				'selector'        => '.single-post .entry-header',
				'title'  		  => __( 'Display post categories', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_avatar',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 70,
				'default'         => 0,
				'selector'        => '.single-post .entry-header',
				'checkbox_label'  => __( 'Display author avatar', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_author',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 75,
				'default'         => 1,
				'selector'        => '.single-post .entry-header',
				'title'  		  => __( 'Display post author', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_date',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 80,
				'default'         => 1,
				'selector'        => '.single-post .entry-header',
				'title'  		  => __( 'Display post date', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_comment',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 85,
				'default'         => 1,
				'selector'        => '.single-post .entry-header',
				'title'  		  => __( 'Display comment cout', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_tags',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 90,
				'default'         => 1,
				'title'  		  => __( 'Display post tags', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_thumbnail_size',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 110,
				'selector'        => $selector,
				'default'         => 'full',
				'label'           => __( 'Thumbnail Size', 'nevo' ),
				'choices'         => array_merge(
					array(
						'default'	=> __( 'Default', 'nevo' ),
					),
					nevo_blog_get_image_sizes()
				),
			),
			
			array(
				'name'       => $section . '_media_radius',
				'type'       => 'slider',
				'section'    => $section,
				'priority' 	 => 120,
				'label'      => __( 'Media Radius', 'nevo' ),
				'max'        => 100,
				'min'        => 0,
				'selector'   => ".single-post .featured-image img",
				'css_format' => 'border-radius: {{value}};',
			),

			array(
				'name'    => $section . '_h_section',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 130,
				'title'   => __( 'Elements', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_comments_element',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 150,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => $cb,
				'title'  		  => __( 'Display Comments', 'nevo' ),
			),
						
			array(
				'name'             => $section . '_elements',
				'type'             => 'repeater',
				'section'          => $section,
				'priority' 		   => 160,
				'selector'         => '.single-after-entry',
				'render_callback' => 'nevo_display_post_single_elements',
				'title'            => __( 'Elements After Content', 'nevo' ),
				'description'      => __( 'Drag and drop to reorder.', 'nevo' ),
				'live_title_field' => 'title',
				'addable'          => false,
				'title_only'       => true,
				'default'          => apply_filters(
					'nevo_single_elements', array(
						array(
							'title' 	=> 'Social sharing',
							'elements'  => 'social-sharing',
						),
						array(
							'title' 	=> 'Post navigation',
							'elements'  => 'post-navigation',
						),
						array(
							'title' 	=> 'Author box',
							'elements'  => 'author-box',
						),
						array(
							'title' 	=> 'Related post',
							'elements'  => 'related-posts',
						),
						array(
							'title' 	=> 'HTML',
							'elements'  => 'html',
							'_visibility' => 'hidden',
						)
					)
				),
				'fields'           => array(
					array(
						'name'  => 'title',
						'type'  => 'hidden',
						'label' => __( 'Title', 'nevo' ),
					),
					array(
						'name' => 'elements',
						'type' => 'hidden',
					),
				),
			),
			
			array(
				'name'            => $section . '_html',
				'type'            => 'textarea',
				'section'         => $section,
				'theme_supports'  => '',
				'priority' 		  => 170,
				'selector'        => '.single-after-entry',
				'render_callback' => 'nevo_display_post_single_elements',
				'default'         => __( 'Add anything here or just remove it...', 'nevo' ),
				'title'           => __( 'HTML', 'nevo' ),
				'description'     => __( 'HTML code and Shortcode is allowed.', 'nevo' ),
			),
		);

		return array_merge( $configs, $config );

	}
}

add_filter( 'nevo/customizer/config', 'nevo_customizer_single_blog_config', 100 );

