<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_blog_config' ) ) {
	function nevo_customizer_blog_config( $configs = array() ) {

		$panel    = 'blog_panel';
		$section  = 'post_archive';
		$selector = '.blog-cols';
		$cb       = 'nevo_display_content';
		$config = array(
			
			array(
				'name'  => 'post_archive',
				'type'  => 'section',
				'panel' => $panel,
				'priority' => 5,
				'title' => __( 'Post/Archive', 'nevo' ),
			),
			
			array(
				'name'    => $section . '_h_content_header',
				'type'    => 'heading',
				'section' => $section,
				'title'   => __( 'Content Header', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_page_header_layout',
				'type'            => 'radio_group',
				'section'         => $section,
				'title'           => __( 'Page Header Layout', 'nevo' ),
				'selector'        => '.archive-post .page-header .nevo-container',
				'css_format'      => 'html_class',
				'default'         => 'normal',
				'choices'         => array(
					'normal'      => __( 'Contained', 'nevo' ),
					'cv-mw-100'   => __( 'Full Width', 'nevo' ),
				),
			),
			
			array(
				'name'            => $section . '_page_header_display',
				'type'            => 'select',
				'section'         => $section,
				'device_settings' => false,
				'selector'        => '.archive-post .page-header',
				'default'         => 'after',
				'label'           => __( 'Display', 'nevo' ),
				'choices'         => array(
					'disable' 	=> __( 'Disable', 'nevo' ),
					'before' 	=> __( 'Before Content', 'nevo' ),
					'after' 	=> __( 'After Header', 'nevo' ),
				),
			),
			
			array(
				'name'            => $section . 'one_containers_padding',
				'type'            => 'css_ruler',
				'section'         => $section,
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'right'  => 'padding-right: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
					'left'   => 'padding-left: {{value}};',
				),
				'selector'        => '.archive-post .one-container .site-main .inside-page-header',
				'required'   => array(
					array( 'content_layout', '=', 'one-container' ),
					array( 'post_archive_page_header_display', '=', 'before' )
				),
			),
			
			array(
				'name'             => $section . '_page_header_elements',
				'type'             => 'repeater',
				'section'          => $section,
				'selector'         => '.archive-post .page-header',
				'title'            => __( 'Elements', 'nevo' ),
				'description'      => __( 'Drag and drop to reorder.', 'nevo' ),
				'live_title_field' => 'title',
				'addable'          => false,
				'title_only'       => true,
				'default'          => apply_filters(
					'nevo_page_header_archive_elements', array(
						array(
							'title' 	=> 'Breadcrumb',
							'elements'  => 'breadcrumb',
						),
						array(
							'title' 	=> 'Archive Title',
							'elements'  => 'title',
						),
						array(
							'title' 	=> 'Description',
							'elements'  => 'description',
						)
					)
				),
				'fields'           => array(
					array(
						'name'  => 'title',
						'type'  => 'hidden',
						'label' => __( 'Title', 'nevo' ),
					),
					array(
						'name' => 'elements',
						'type' => 'hidden',
					),
					
				),
			),
			
			array(
				'name'            => $section . '_page_header_background_image',
				'type'            => 'select',
				'section'         => $section,
				'device_settings' => false,
				'selector'        => '.archive-post .page-header',
				'default'         => 'global',
				'label'           => __( 'Background image', 'nevo' ),
				'render_callback' => 'nevo_page_header_section',
				'choices'         => array(
					'global' 	=> __( 'Global', 'nevo' ),
					'custom' 	=> __( 'Custom', 'nevo' ),
				),
			),
			
			array(
				'name'       => $section . '_page_header_style',
				'type'       => 'modal',
				'section'    => $section,
				'title'      => __( 'Page Header Styling', 'nevo' ),
				'selector'   => 'body.archive-post .page-header',
				'css_format' => 'styling',
				'fields'     => array(
					'tabs'          => array(
						'normal' => __( 'Normal', 'nevo' ),
					),
					'normal_fields' => array(
						array(
							'name'       => $section . '_text_color',
							'type'       => 'color',
							'label'      => __( 'Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.archive-post .page-header .inside-page-header, body.archive-post .page-header .page-title',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_link_color',
							'type'       => 'color',
							'label'      => __( 'Link Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.archive-post .page-header .inside-page-header a',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_hover_link_color',
							'type'       => 'color',
							'label'      => __( 'Link Color Hover', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.archive-post .page-header .inside-page-header a:hover, body.archive-post .page-header .inside-page-header a:focus',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'            => $section . '_page_header_align',
							'type'            => 'text_align_no_justify',
							'device_settings' => true,
							'selector'   	  => ".archive-post .inside-page-header",
							'css_format'      => 'text-align: {{value}};',
							'label'           => __( 'Align', 'nevo' ),
						),
						array(
							'name'  => $section . '_bg_heading',
							'type'  => 'heading',
							'label' => __( 'Background', 'nevo' ),
						),
						
						array(
							'name'       => $section . '_bg_color',
							'type'       => 'color',
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => 'body.archive-post .page-header',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => $section . '_bg_overlay_color',
							'type'       => 'color',
							'label'      => __( 'Background overlay color', 'nevo' ),
							'selector'   => 'body.archive-post .page-header:before',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => $section . '_bg_image',
							'type'       => 'image',
							'label'      => __( 'Background Image', 'nevo' ),
							'selector'   => 'body.archive-post .page-header',
							'css_format' => 'background-image: url("{{value}}");',
							'device_settings' => false,
						),
						array(
							'name'       => $section . '_bg_cover',
							'type'       => 'select',
							'default'    => 'cover',
							'choices'    => array(
								''        => __( 'Default', 'nevo' ),
								'auto'    => __( 'Auto', 'nevo' ),
								'cover'   => __( 'Cover', 'nevo' ),
								'contain' => __( 'Contain', 'nevo' ),
							),
							'label'      => __( 'Size', 'nevo' ),
							'class'      => 'field-half-left',
							'selector'   => 'body.archive-post .page-header',
							'css_format' => '-webkit-background-size: {{value}}; -moz-background-size: {{value}}; -o-background-size: {{value}}; background-size: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),
						array(
							'name'       => $section . '_bg_position',
							'type'       => 'select',
							'label'      => __( 'Position', 'nevo' ),
							'class'      => 'field-half-right',
							'default'    => 'center',
							'choices'    => array(
								''              => __( 'Default', 'nevo' ),
								'center'        => __( 'Center', 'nevo' ),
								'top left'      => __( 'Top Left', 'nevo' ),
								'top right'     => __( 'Top Right', 'nevo' ),
								'top center'    => __( 'Top Center', 'nevo' ),
								'bottom left'   => __( 'Bottom Left', 'nevo' ),
								'bottom center' => __( 'Bottom Center', 'nevo' ),
								'bottom right'  => __( 'Bottom Right', 'nevo' ),
							),
							'selector'   => 'body.archive-post .page-header',
							'css_format' => 'background-position: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),
						array(
							'name'       => $section . '_bg_repeat',
							'type'       => 'select',
							'label'      => __( 'Repeat', 'nevo' ),
							'class'      => 'field-half-left',
							'default'    => 'no-repeat',
							'choices'    => array(
								'repeat'    => __( 'Default', 'nevo' ),
								'no-repeat' => __( 'No repeat', 'nevo' ),
								'repeat-x'  => __( 'Repeat horizontal', 'nevo' ),
								'repeat-y'  => __( 'Repeat vertical', 'nevo' ),
							),
							'selector'   => 'body.archive-post .page-header',
							'css_format' => 'background-repeat: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),

						array(
							'name'       => $section . '_bg_attachment',
							'type'       => 'select',
							'label'      => __( 'Attachment', 'nevo' ),
							'class'      => 'field-half-right',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'scroll' => __( 'Scroll', 'nevo' ),
								'fixed'  => __( 'Fixed', 'nevo' ),
							),
							'selector'   => 'body.archive-post .page-header',
							'css_format' => 'background-attachment: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),
					),
				),
			),
						
			array(
				'name'        => $section . '_page_header_typography',
				'type'        => 'typography',
				'section'     => $section,
				'title'       => __( 'Archive  Title Typography', 'nevo' ),
				'css_format'  => 'typography',
				'selector'    => ".archive-post .page-header .page-title",
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
			),
			
			array(
				'name'    => $section . '_h_sidebar_layout',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 55,
				'title'   => __( 'Sidebar Layout', 'nevo' ),
			),
			
			array(
				'name'    => $section . '_sidebar_layout',
				'type'    => 'image_select',
				'priority' => 60,
				'default' => 'right-sidebar',
				'section' => $section,
				'title'   => __( 'Sidebar Layout', 'nevo' ),
				'choices' => nevo_get_sidebar_layouts(),
			),
			
			array(
				'name'    => $section . '_h_content_layout',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 65,
				'title'   => __( 'Content Layout', 'nevo' ),
			),
			
			array(
                'name' 				=> $section . '_layout',
                'type'    			=> 'image_select',
                'label'   			=> __( 'Content Layout', 'nevo' ),
                'priority' 			=> 66,
				'default' 			=> 'content-1',
				'section' 			=> $section,
				'selector'        	=> $selector,
				'render_callback' 	=> $cb,
                'choices' => nevo_get_post_archive_content_layouts(),
            ),
			
			array(
				'name'        => $section . '_typography',
				'type'        => 'typography',
				'section'     => $section,
				'priority' 	  => 70,
				'title'       => __( 'Title Typography', 'nevo' ),
				'css_format'  => 'typography',
				'selector'    => "article.general-content .entry-title",
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
				'required' => array( $section . '_layout', '=',	array( 'content-8', 'content-9', 'content-16', 'content-26' ) ),
			),
			
			array(
				'name'            => $section . '_header_entry_align',
				'type'            => 'text_align_no_justify',
				'section'         => $section,
				'priority' 		  => 75,
				'device_settings' => true,
				'selector'   	  => "{$selector} .inside-article",
				'css_format'      => 'text-align: {{value}};',
				'title'           => __( 'Text Align', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_categories',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 80,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => $cb,
				'title'  		  => __( 'Display post categories', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_avatar',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 85,
				'default'         => 0,
				'selector'        => $selector,
				'render_callback' => $cb,
				'checkbox_label'  => __( 'Display author avatar', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_author',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 90,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => $cb,
				'title'  		  => __( 'Display post author', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_date',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 95,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => $cb,
				'title'  		  => __( 'Display post date', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_comment',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 100,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => $cb,
				'title'  		  => __( 'Display comment cout', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_thumbnail_size',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 120,
				'selector'        => $selector,
				'render_callback' => $cb,
				'default'         => 'default',
				'label'           => __( 'Thumbnail Size', 'nevo' ),
				'choices'         => array_merge(
					array(
						'default'	=> __( 'Default', 'nevo' ),
					),
					nevo_blog_get_image_sizes()
				),
				'required' => array( $section . '_layout', 'on', array( 'content-1', 'content-2', 'content-3', 'content-4', 'content-5', 'content-6', 'content-7', 'content-8', 'content-9', 'content-12', 'content-13', 'content-14', 'content-15', 'content-16', 'content-17', 'content-18', 'content-19', 'content-20', 'content-21', 'content-22', 'content-23', 'content-24', 'content-25', 'content-26', 'content-27', 'content-28', 'content-28', 'content-29', 'content-30', 'content-31', 'content-32', 'content-36', 'content-37', 'content-38' ) ),
			),
			
			array(
				'name'       => $section . '_media_radius',
				'type'       => 'slider',
				'section'    => $section,
				'priority' 	 => 130,
				'label'      => __( 'Media Radius', 'nevo' ),
				'max'        => 100,
				'min'        => 0,
				'selector'   => "{$selector} .post-image img",
				'css_format' => 'border-radius: {{value}};',
				'required'   => array( $section . '_layout', 'in', array( 'content-1', 'content-2', 'content-3', 'content-4', 'content-5', 'content-6', 'content-7', 'content-8', 'content-9', 'content-12', 'content-13', 'content-14', 'content-15', 'content-16', 'content-17', 'content-18', 'content-19', 'content-20', 'content-21', 'content-22', 'content-23', 'content-24', 'content-25', 'content-26', 'content-27', 'content-28', 'content-28', 'content-29', 'content-30', 'content-31', 'content-32', 'content-36', 'content-37', 'content-38'  ) ),
			),

			// Article Excerpt ---------------------------------------------------------------------------------.
			
			array(
				'name'            => $section . '_excerpt_type',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 145,
				'default'         => 'default',
				'choices'         => array(
					'default' => __( 'Default', 'nevo' ),
					'custom'  => __( 'Custom', 'nevo' ),
					'content' => __( 'Full content', 'nevo' ),
				),
				'selector'        => $selector,
				'render_callback' => $cb,
				'label'           => __( 'Excerpt Type', 'nevo' ),
				'required'   => array( $section . '_layout', 'in', array( 'content-1', 'content-2', 'content-3', 'content-4', 'content-5', 'content-6', 'content-7', 'content-8', 'content-9', 'content-14', 'content-16', 'content-19', 'content-20', 'content-22', 'content-23', 'content-24' ) ),
			),

			array(
				'name'            => $section . '_excerpt_length',
				'type'            => 'number',
				'section'         => $section,
				'priority' 		  => 150,
				'selector'        => $selector,
				'render_callback' => $cb,
				'default'         => '15',
				'label'           => __( 'Excerpt Length', 'nevo' ),
				'description'     => __( 'To hide the Excerpt set the value to 0.', 'nevo' ),
				'required'   => array(
					array( $section . '_layout', 'in', array( 'content-1', 'content-2', 'content-3', 'content-4', 'content-5', 'content-6', 'content-7', 'content-8', 'content-9', 'content-14', 'content-16', 'content-19', 'content-20', 'content-22', 'content-23', 'content-24' ) ),
					array( $section . '_excerpt_type', '=', 'custom' )
				),
			),
			/* 
			array(
				'name'            => $section . '_display_read_more',
				'type'            => 'checkbox',
				'section'         => $section,
				'priority' 		  => 155,
				'selector'        => $selector,
				'default'         => 0,
				'render_callback' => $cb,
				'title'  		  => __( 'Display read more button', 'nevo' ),
				'required'        => array( $section . '_excerpt_type', '=', 'custom' ),
			),
			
			array(
				'name'            => $section . '_excerpt_more',
				'type'            => 'text',
				'section'         => $section,
				'priority' 		  => 160,
				'default'         => 'Read More',
				'placeholder' 	  => 'Read More',
				'selector'        => $selector,
				'render_callback' => $cb,
				'label'           => __( 'Read More Text', 'nevo' ),
				'required'        => array( $section . '_display_read_more', '=', '1' ),
			),
			
			array(
				'name'            => $section . '_read_more_align',
				'type'            => 'text_align_no_justify',
				'section'         => $section,
				'priority' 		  => 165,
				'device_settings' => true,
				'selector'   	  => "{$selector} p.excerpt-more",
				'css_format'      => 'text-align: {{value}};',
				'title'           => __( 'Read More Button Align', 'nevo' ),
				'required'        => array( $section . '_display_read_more', '=', '1' ),
			),
			
			array(
				'name'       => $section . '_more_styling',
				'type'       => 'styling',
				'section'    => $section,
				'priority' 	 => 170,
				'selector'   => array(
					'normal'        => "{$selector } .excerpt-more a.read-more-button",
					'hover'         => "{$selector } .excerpt-more a.read-more-button:hover",
				),
				'css_format' => 'styling',
				'label'      => __( 'Read More Button Style', 'nevo' ),
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'link_color'    => false,
						'margin'        => false,
						'paddinga'      => false,
						'bg_image'      => false,
						'bg_cover'      => false,
						'bg_position'   => false,
						'bg_repeat'     => false,
						'bg_attachment' => false,
					),
					'hover_fields'  => array(
						'link_color' => false,
					),
				),
				'required'        => array( $section . '_display_read_more', '=', '1' ),
			),
			 */
			array(
				'name'       => $section . '_settings',
				'type'       => 'modal',
				'section'    => $section,
				'priority' 	 => 180,
				'title'      => __( 'Article Styling', 'nevo' ),
				'selector'   => $selector,
				'css_format' => 'styling',
				'fields'     => array(
					'tabs'          => array(
						'normal' => __( 'Normal', 'nevo' ),
					),
					'normal_fields' => array(
						array(
							'name'       => $section . '_link_color',
							'type'       => 'color',
							'label'      => __( 'Title Color', 'nevo' ),
							'selector'   => '.blog-cols .entry-title a',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_link_hover_color',
							'type'       => 'color',
							'label'      => __( 'Title Hover Color', 'nevo' ),
							'selector'   => '.blog-cols .entry-title a:hover',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_text_color',
							'type'       => 'color',
							'label'      => __( 'Text Color', 'nevo' ),
							'selector'   => '.blog-cols .inside-article .entry-summary, .blog-cols .inside-article .entry-content',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_meta_color',
							'type'       => 'color',
							'label'      => __( 'Meta Color', 'nevo' ),
							'selector'   => '.blog-cols .entry-meta, .blog-cols .entry-meta a',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_bg_color',
							'type'       => 'color',
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => '.separate-containers .blog-cols .inside-article, .one-container .blog-cols .inside-article',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'            => 'padding',
							'type'            => 'css_ruler',
							'css_format'      => array(
								'top'    => 'padding-top: {{value}};',
								'right'  => 'padding-right: {{value}};',
								'bottom' => 'padding-bottom: {{value}};',
								'left'   => 'padding-left: {{value}};',
							),
							'label'           => __( 'Padding', 'nevo' ),
							'description'     => __( 'It only works when the "Content Layout" is One Container.', 'nevo' ),
							'selector'   => '.one-container .blog-cols .inside-article',
						),
						array(
							'name'  => $section . '_border_heading',
							'type'  => 'heading',
							'label' => __( 'Border', 'nevo' ),
						),

						array(
							'name'       => $section . '_border_style',
							'type'       => 'select',
							'class'      => 'clear',
							'selector'   => '.blog-cols .inside-article',
							'label'      => __( 'Border Style', 'nevo' ),
							'default'    => '',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'none'   => __( 'None', 'nevo' ),
								'solid'  => __( 'Solid', 'nevo' ),
								'dotted' => __( 'Dotted', 'nevo' ),
								'dashed' => __( 'Dashed', 'nevo' ),
								'double' => __( 'Double', 'nevo' ),
								'ridge'  => __( 'Ridge', 'nevo' ),
								'inset'  => __( 'Inset', 'nevo' ),
								'outset' => __( 'Outset', 'nevo' ),
							),
							'css_format' => 'border-style: {{value}};',
						),

						array(
							'name'       => $section . '_border_width',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Width', 'nevo' ),
							'selector'   => '.blog-cols .inside-article',
							'required'   => array(
								array( $section . '_border_style', '!=', 'none' ),
								array( $section . '_border_style', '!=', '' ),
							),
							'css_format' => array(
								'top'    => 'border-top-width: {{value}};',
								'right'  => 'border-right-width: {{value}};',
								'bottom' => 'border-bottom-width: {{value}};',
								'left'   => 'border-left-width: {{value}};',
							),
						),
						array(
							'name'       => $section . '_border_color',
							'type'       => 'color',
							'label'      => __( 'Border Color', 'nevo' ),
							'selector'   => '.blog-cols .inside-article',
							'required'   => array(
								array( $section . '_border_style', '!=', 'none' ),
								array( $section . '_border_style', '!=', '' ),
							),
							'css_format' => 'border-color: {{value}};',
						),

						array(
							'name'       => $section . '_border_radius',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Radius', 'nevo' ),
							'selector'   => '.blog-cols .inside-article',
							'css_format' => array(
								'top'    => 'border-top-left-radius: {{value}};',
								'right'  => 'border-top-right-radius: {{value}};',
								'bottom' => 'border-bottom-right-radius: {{value}};',
								'left'   => 'border-bottom-left-radius: {{value}};',
							),
						),
					),
				),
			),
			
		);

		return $config;
	}
}


if ( ! function_exists( 'nevo_customizer_blog_posts_config' ) ) {
	function nevo_customizer_blog_posts_config( $configs ) {

		$config = array(
			array(
				'name'     => 'blog_panel',
				'type'     => 'panel',
				'priority' => 15,
				'title'    => __( 'Blog', 'nevo' ),
			),
		);

		$blog   = nevo_customizer_blog_config();
		$config = array_merge( $config, $blog );

		return array_merge( $configs, $config );
	}
}

add_filter( 'nevo/customizer/config', 'nevo_customizer_blog_posts_config' );
