<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_breadcrumb_config' ) ) {
	
	function nevo_customizer_breadcrumb_config( $configs ) {

		$section = 'global_breadcrumb';
		$selector = '.nevo-breadcrumb';
		$cb	= 'nevo_breadcrumb';
		$config = array(
			array(
				'name'  => "{$section}",
				'type'  => 'section',
				'panel' => 'general_panel',
				'title' => __( 'Global Breadcrumb', 'nevo' ),
				'priority' => 80,
			),
			
			array(
				'name'            => $section . '_type',
				'type'            => 'select',
				'section'         => $section,
				'device_settings' => false,
				'selector'        => $selector,
				'render_callback' => $cb,
				'default'         => '',
				'label'           => __( 'Breadcrumb', 'nevo' ),
				'choices'         => array(
					'' 					=> "Theme's default",
					'rank-math' 		=> 'Rank Math',
					'yoast-seo' 		=> 'Yoast SEO',
					'breadcrumb-navxt' 	=> 'Breadcrumb NavXT',
					'breadcrumb-trail' 	=> 'Breadcrumb Trail',
					'seopress' 			=> 'SEOPress (pro version)',
				),
			),
			
			array(
				'name'            => $section . '_separator',
				'type'            => 'text',
				'section'         => $section,
				'theme_supports'  => '',
				'selector'        => $selector,
				'render_callback' => $cb,
				'title'           => __( 'Separator', 'nevo' ),
				'description'     => __( 'Can use "&amp;nbsp;" to create a space. <br> Default " &amp;nbsp;&amp;raquo;&amp;nbsp; "', 'nevo' ),
				'default'         => __( '&nbsp;&raquo;&nbsp;', 'nevo' ),
			),
		
			array(
				'name'            => $section . '_home',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => $cb,
				'title'  		  => __( 'Include "Home" as the first item', 'nevo' ),
				'required'   	  => array( $section . '_type', '=', '' ),
			),
			
			array(
				'name'            => $section . '_current_page',
				'type'            => 'checkbox',
				'section'         => $section,
				'default'         => 1,
				'selector'        => $selector,
				'render_callback' => $cb,
				'checkbox_label'  => __( 'Include current page as the last item', 'nevo' ),
				'required'   	  => array( $section . '_type', '=', '' ),
			),
			
			array(
				'name'            => $section . '_home_or_current',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 0,
				'render_callback' => $cb,
				'title'  		  => __( 'Hide if home or current page is the only item', 'nevo' ),
				'required'   	  => array( $section . '_type', '=', '' ),
			),
			
			array(
				'name'  => "comments",
				'type'  => 'section',
				'panel' => 'general_panel',
				'title' => __( 'Global Comments', 'nevo' ),
				'priority' => 100,
			),
			
			array(
				'name'            => 'comment_form',
				'type'            => 'checkbox',
				'section'         => 'comments',
				'selector'        => '.comments',
				'default'         => 0,
				'title'  		  => __( 'Move Comments input above comment list.', 'nevo' ),
			),
			
			array(
				'name'            => 'comment_url',
				'type'            => 'checkbox',
				'section'         => 'comments',
				'selector'        => '.comments',
				'default'         => 0,
				'title'  		  => __( 'Remove Comments Website field.', 'nevo' ),
			),
		);

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_breadcrumb_config', 299 );