<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_color_config' ) ) {
	function nevo_customizer_color_config( $configs ) {

		$section = 'global_color';

		$config = array(

			array(
				'name'     => "{$section}",
				'type'     => 'section',
				'panel'    => 'general_panel',
				'title'    => __( 'Global Colors', 'nevo' ),
				'priority' => 10,
			),
			/* 
			array(
				'name'            => 'colors_colors',
				'type'            => 'radio_group',
				'section'         => $section,
				'title'           => __( 'Color', 'nevo' ),
				'selector'        => '.entry-summary',
				'css_format'      => 'color:var(--nvt-{{value}});',
				'default'         => 'primary',
				'choices'         => array(
					'primary'	 => __( 'Primary', 'nevo' ),
					'secondary'  => __( 'Secondary', 'nevo' ),
					'success'	 => __( 'Success', 'nevo' ),
					'info'		 => __( 'Info', 'nevo' ),
					'warning'	 => __( 'Warning', 'nevo' ),
					'link'		 => __( 'Link', 'nevo' ),
					'link-hover' => __( 'Link Hover', 'nevo' ),
					'base'		 => __( 'Base', 'nevo' ),
					'title'		 => __( 'Title', 'nevo' ),
					'meta'		 => __( 'Meta', 'nevo' ),
					'heading'	 => __( 'Heading', 'nevo' ),
					'white'	 	 => __( 'White', 'nevo' ),
				),
				'priority' 		  => 5,
			),
			 */
			array(
				'name'       => $section . '_style',
				'type'       => 'styling',
				'section'    => $section,
				'title'      => __( 'Colors', 'nevo' ),
				'description' => __( 'Theme color applied.', 'nevo' ),
				'selector'   => array(
					'normal' => ':root',
				),
				'default'   => array(
					'normal' => array(
						'primary'	=> '#4b4545',
						'secondary' => '#999395',
						'success'	=> '#198754',
						'info'	=> '#0dcaf0',
						'warning'	=> '#da5555',
						'link'	=> '#0d6efd',
						'link_hover'	=> '#0a58ca',
						'base'	=> '#212529',
						'title'	=> '#222222',
						'meta'	=> '#4b4545',
						'heading'	=> '#222222',
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'text_color'     => false,
						'link_color' 	 => false,
						'padding'        => false,
						'paddinga'       => false,
						'margin'         => false,
						'bg_heading' 	 => false,
						'bg_color' 		 => false,
						'bg_image' 		 => false,
						'border_heading' => false,
						'border_width'   => false,
						'border_color'   => false,
						'border_radius'  => false,
						'box_shadow'     => false,
						'border_style'   => false,
					),
					'hover_fields'  => false,
				),
			),
		);

		return array_merge( $configs, $config );
	}
}

add_filter( 'nevo/customizer/config', 'nevo_customizer_color_config', 199 );
