<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_footer_copyright_config' ) ) {
	function nevo_customizer_footer_copyright_config($configs = array()) {
		$section  = 'footer_copyright';
		$name     = 'footer_copyright';
		$selector = '.footer-copyright';
		$config   = array(
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'nevo_footer',
				'priority' => 150,
				'title' => __( 'Copyright', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_text',
				'type'            => 'textarea',
				'section'         => $section,
				'selector'        => $selector,
				'theme_supports'  => '',
				'render_callback' => 'nevo_refresh_footer_copyright_partials',
				'default'         => __( 'Copyright &copy; {current_year} {site_title} - Powered by {theme_author}.', 'nevo' ),
				'title'           => __( 'Text / HTML', 'nevo' ),
				'description'     => __( 'Arbitrary HTML code or shortcode. Available tags: {current_year}, {site_title}, {theme_author}', 'nevo' ),
			),

		);

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_footer_copyright_config', 599 );

function nevo_refresh_footer_copyright_partials() {
	nevo_footer_element( 'footer-copyright');
}