<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_footer_bottom_config' ) ) {

	function nevo_customizer_footer_bottom_config($configs = array()) {
		$section  = 'nevo_footer_bottom';
		$name     = 'footer_bottom';
		$selector = '.bottom-footer';
		$config = array(
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'nevo_footer',
				'priority' => 70,
				'title' => __( 'Bottom Row', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_layout',
				'type'            => 'radio_group',
				'section'         => $section,
				'title'           => __( 'Layout', 'nevo' ),
				'selector'        => '.bottom-footer .nevo-container',
				'css_format'      => 'html_class',
				'default'         => 'normal',
				'choices'         => array(
					'normal'      => __( 'Contained', 'nevo' ),
					'cv-mw-100'   => __( 'Full Width', 'nevo' ),
				),
			),
			
			array(
				'name'            => $name . '_padding',
				'type'            => 'css_ruler',
				'section'         => $section,
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'fields_disabled' => array(
					'left'  => 'nevo',
					'right' => 'nevo',
				),
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
				),
				'selector'        => '.bottom-footer .inside-footer',
			),
			
			array(
				'name'            => $name . '_margin',
				'type'            => 'css_ruler',
				'section'         => $section,
				'title'           => __( 'Margin', 'nevo' ),
				'device_settings' => true,
				'css_format'      => array(
					'top'    => 'margin-top: {{value}};',
					'right'  => 'margin-right: {{value}};',
					'bottom' => 'margin-bottom: {{value}};',
					'left'   => 'margin-left: {{value}};',
				),
				'selector'        => '.bottom-footer',
			),
			
			array(
				'name'    => $name . '_hr',
				'type'    => 'hr',
				'section' => $section,
			),
			
			array(
				'name'       => $name . '_styling',
				'type'       => 'styling',
				'section'    => $section,
				'title'      => __( 'Styling', 'nevo' ),
				'selector'   => array(
					'normal' => '.bottom-footer',
					'normal_text_color' => '.bottom-footer',
					'normal_link_color' => '.bottom-footer a, .bottom-footer .nevo-nav-menu li[class*="current-menu-"] > a',
					'hover' => '.bottom-footer a:hover',
				),
				'default'   => array(
					'normal' => array(
						//'text_color' => '#ffffff',
						//'link_color' => '#ffffff',
					),
					'hover' => array(
						//'link_color' => '#ffffff',
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'margin'     => false,
						'padding'    => false,
						'paddinga'   => false,
						'box_shadow' => false,
					),
					'hover_fields'  => array(
						'text_color'  => false,
						'margin'      => false,
						'padding'     => false,
						'bg_heading'  => false,
						'bg_color'    => false,
						'bg_image'    => false,
						'border_heading' => false,
						'border_style'   => false,
						'border_radius'  => false,
						'box_shadow'	 => false,
					),
				),
			),
			
			/* array(
				'name'       => $name . '_typography',
				'type'       => 'typography',
				'section'    => $section,
				'title'      => __( 'Typography', 'nevo' ),
				'selector'   => '.site-footer .bottom-footer',
				'css_format' => 'typography',
				'default'    => array(),
			),
			
			array(
				'name'       => $name . '_menu_typography',
				'type'       => 'typography',
				'section'    => $section,
				'title'      => __( 'Menu Typography', 'nevo' ),
				'selector'   => "{$selector} .nevo-nav-menu > li, {$selector} .nevo-nav-menu > li > a",
				'css_format' => 'typography',
				'default'    => array(),
			), */
			
			array(
				'name'       => $name . '_widgets_title',
				'type'       => 'styling',
				'section'    => $section,
				'title'      => __( 'Footer Widgets Title', 'nevo' ),
				'selector'   => array(
					'normal' => "{$selector} .heading-title",
					'normal_text_color' => "{$selector} .widget-title",
					'normal_padding' => "{$selector} .widget-title",
					'normal_margin' => "{$selector} .heading-title",
					'normal_bg_color' => "{$selector} .widget-title",
				),
				'default'   => array(
					'normal' => array(
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'link_color'  => false,
						'margin'      => false,
						'paddinga'    => false,
						'box_shadow'  => false,
					),
					'hover_fields'  => false,
				),
			),
		);

		return array_merge( $configs, $config );
	}
	
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_footer_bottom_config', 70 );