<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_header_bottom_config' ) ) {

	function nevo_customizer_header_bottom_config($configs = array()) {
		$section  = 'nevo_header_bottom';
		$name     = 'header_bottom';
		$selector = '.bottom-header';
		$config = array(
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'nevo_header',
				'priority' => 15,
				'title' => __( 'Header Bottom', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_layout',
				'type'            => 'radio_group',
				'section'         => $section,
				'title'           => __( 'Layout', 'nevo' ),
				'selector'        => '.bottom-header .nevo-container',
				'css_format'      => 'html_class',
				'default'         => 'normal',
				'choices'         => array(
					'normal'      => __( 'Contained', 'nevo' ),
					'cv-mw-100'   => __( 'Full Width', 'nevo' ),
				),
				'priority' 		  => 5,
			),
			
			array(
				'name'            => $name . '_desktop_height',
				'type'            => 'slider',
				'section'         => $section,
				'theme_supports'  => '',
				'min'             => 0,
				'max'             => 500,
				'title'           => __( 'Desktop Height', 'nevo' ),
				'selector'        => '.desktop-header .bottom-header',
				'css_format'      => 'height: {{value}};',
				'device_settings' => false,
				'default'         => 50,
				'priority' 		  => 10,
			),
			
			array(
				'name'            => $name . '_mobile_height',
				'type'            => 'slider',
				'section'         => $section,
				'theme_supports'  => '',
				'min'             => 0,
				'max'             => 500,
				'title'           => __( 'Mobile/Tablet Height', 'nevo' ),
				'selector'        => '.mobile-header .bottom-header',
				'css_format'      => 'height: {{value}};',
				'device_settings' => false,
				'default'         => 50,
				'priority' 		  => 15,
			),
			
			array(
				'name'       => $name . '_settings',
				'type'       => 'modal',
				'section'    => $section,
				'title'      => __( 'Styling', 'nevo' ),
				'selector'   => $selector,
				'css_format' => 'styling',
				'priority' 	 => 20,
				'fields'     => array(
					'tabs'          => array(
						'normal' => __( 'Normal', 'nevo' ),
					),
					'normal_fields' => array(
						array(
							'name'       => $name . '_text_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color', 'nevo' ),
							'selector'   => '.bottom-header .inside-header, .bottom-header .search-button',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_link_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Link Color', 'nevo' ),
							'selector'   => '.bottom-header a, .bottom-header .nevo-nav-menu li[class*="current-menu-"] > a',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_hover_link_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Link Color Hover', 'nevo' ),
							'selector'   => '.bottom-header .inside-header a:hover',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_bg_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => ".bottom-header",
							'css_format' => 'background-color .nevo-section-inner: {{value}};',
						),
						array(
							'name'       => $name . '_border_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Border Color', 'nevo' ),
							'selector'   => ".bottom-header .nevo-section-inner",
							'css_format' => 'border-color: {{value}}',
						),
						array(
							'name'            => $name . '_border_bottom_size',
							'type'            => 'slider',
							'section'         => $section,
							'theme_supports'  => '',
							'min'             => 0,
							'max'             => 50,
							'label'           => __( 'Border Bottom Size', 'nevo' ),
							'selector'        => '.bottom-header .nevo-section-inner',
							'css_format'      => 'border-bottom-width: {{value}};',
							'device_settings' => true,
							'default'         => array(
								'desktop' => array(
									'unit' => 'px',
									'value' => '',
								),
								'tablet'  => array(
									'unit' => 'px',
									'value' => '',
								),
								'mobile'  => array(
									'unit' => 'px',
									'value' => '',
								),
							),
						),
						array(
							'name'            => $name . '_padding',
							'type'            => 'css_ruler',
							'device_settings' => true,
							'selector'        => '.bottom-header .inside-header',
							'label'           => __( 'Padding', 'nevo' ),
							'fields_disabled' => array(
								'left'  => 'nevo',
								'right' => 'nevo',
							),
							'css_format'      => array(
								'top'    => 'padding-top: {{value}};',
								'bottom' => 'padding-bottom: {{value}};',
							),
						),
					),
				),
			),
			
			array(
				'name'            => $name . '_menu_highlight',
				'type'            => 'select',
				'section'         => $section,
				'title'           => __( 'Top level menu items highlight', 'nevo' ),
				'selector'        => $selector,
				'css_format'      => 'html_class',
				'default'         => 'highlight-menu-normal',
				'choices'         => array(
					'highlight-menu-normal' 		 => __( 'None', 'nevo' ),
					'highlight-menu-color'       => __( 'Color', 'nevo' ),
					'highlight-menu-border'      => __( 'Border', 'nevo' ),
					'highlight-menu-background'  => __( 'Background', 'nevo' ),
				),
				'priority' 		  => 70,
			),
			
			array(
				'name'       => $name . '_menu_highlight_color',
				'type'       => 'color',
				'section'    => $section,
				'title'      => __( 'Highlight Color', 'nevo' ),
				'selector'   => "{$selector} .nevo-nav-menu > li.menu-item:hover > .nevo-menu-link, {$selector} .nevo-nav-menu > li.menu-item > .nevo-menu-link:focus, {$selector} .nevo-nav-menu > li.menu-item > .nevo-menu-link:hover, {$selector} .nevo-nav-menu > li[class*='current-menu-'] > .nevo-menu-link",
				'css_format' => 'color: {{value}}',
				'priority' 	 => 75,
				'required'   => array( $name . '_menu_highlight', '!=', 'highlight-menu-normal' ),
			),
			
			array(
				'name'       => $name . '_menu_highlight_border_color',
				'type'       => 'color',
				'section'    => $section,
				'title'      => __( 'Highlight Border Color', 'nevo' ),
				'selector'   => "
								{$selector}.highlight-menu-border .nevo-nav-menu > .menu-item:focus > .nevo-menu-link:before,
								{$selector}.highlight-menu-border .nevo-nav-menu > .menu-item:hover > .nevo-menu-link:before,
								{$selector}.highlight-menu-border .nevo-nav-menu > .current-menu-item > .nevo-menu-link:before,
								{$selector}.highlight-menu-border .nevo-nav-menu > li[class*='current-menu-'] > .nevo-menu-link:before,
								{$selector}.highlight-menu-border .nevo-nav-menu > .current-menu-ancestor > .nevo-menu-link:before",
				'css_format' => 'background-color: {{value}}',
				'priority' 	 => 80,
				'required'   => array( $name . '_menu_highlight', '=', 'highlight-menu-border' ),
			),
			
			array(
				'name'       => $name . '_menu_highlight_background_color',
				'type'       => 'color',
				'section'    => $section,
				'title'      => __( 'Highlight Background Color', 'nevo' ),
				'selector'   => "{$selector}.highlight-menu-background .nevo-nav-menu > .menu-item:focus,
								{$selector}.highlight-menu-background .nevo-nav-menu > .menu-item:hover,
								{$selector}.highlight-menu-background .nevo-nav-menu > .current-menu-item,
								{$selector}.highlight-menu-background .nevo-nav-menu > li[class*='current-menu-']",
				'css_format' => 'background-color: {{value}}',
				'priority' 	 => 85,
				'required'   => array( $name . '_menu_highlight', '=', 'highlight-menu-background' ),
			),
			
			array(
				'name'    => $name . '_hr',
				'type'    => 'hr',
				'section' => $section,
				'priority' => 90,
			),
			
		);

		return array_merge( $configs, $config );
	}
	
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_header_bottom_config', 5 );