<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_header_search_config' ) ) {
	function nevo_customizer_header_search_config($configs = array()) {
		$section  = 'header_search';
		$name     = 'header_search';
		$selector = '.header-search';
		$config   = array(
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'nevo_header',
				'priority' => 70,
				'title' => __( 'Search', 'nevo' ),
			),
			
			array(
				'name'       => $name . '_setting',
				'type'       => 'modal',
				'priority'   => 20,
				'section'    => $section,
				'selector'   => "{$selector} button.search-button",
				'css_format' => 'styling',
				'title'      => __( 'Search Icon Style', 'nevo' ),
				'fields'     => array(
					'tabs'           => array(
						'default' => __( 'Normal', 'nevo' ),
						'hover'   => __( 'Hover / Focus', 'nevo' ),
					),
					'default_fields' => array(
						array(
							'name'       => $name . '_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color', 'nevo' ),
							'selector'   => "{$selector} button.search-button",
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_bg_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => "{$selector} button.search-button",
							'css_format' => 'background-color: {{value}};',
						),
						
						array(
							'name'            => $name . '_padding',
							'type'            => 'css_ruler',
							'device_settings' => true,
							'selector'   	  => "{$selector} button.search-button",
							'css_format'      => array(
								'top'    => 'padding-top: {{value}};',
								'right'  => 'padding-right: {{value}};',
								'bottom' => 'padding-bottom: {{value}};',
								'left'   => 'padding-left: {{value}};',
							),
							'label'           => __( 'Padding', 'nevo' ),
						),
						
						array(
							'name'  => $name . '_border_heading',
							'type'  => 'heading',
							'label' => __( 'Border', 'nevo' ),
						),

						array(
							'name'       => $name . '_border_style',
							'type'       => 'select',
							'class'      => 'clear',
							'selector'   => "{$selector} button.search-button",
							'label'      => __( 'Border Style', 'nevo' ),
							'default'    => '',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'none'   => __( 'None', 'nevo' ),
								'solid'  => __( 'Solid', 'nevo' ),
								'dotted' => __( 'Dotted', 'nevo' ),
								'dashed' => __( 'Dashed', 'nevo' ),
								'double' => __( 'Double', 'nevo' ),
								'ridge'  => __( 'Ridge', 'nevo' ),
								'inset'  => __( 'Inset', 'nevo' ),
								'outset' => __( 'Outset', 'nevo' ),
							),
							'css_format' => 'border-style: {{value}};',
						),

						array(
							'name'       => $name . '_border_width',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Width', 'nevo' ),
							'selector'   => "{$selector} button.search-button",
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => array(
								'top'    => 'border-top-width: {{value}};',
								'right'  => 'border-right-width: {{value}};',
								'bottom' => 'border-bottom-width: {{value}};',
								'left'   => 'border-left-width: {{value}};',
							),
						),
						array(
							'name'       => $name . '_border_color',
							'type'       => 'color',
							'label'      => __( 'Border Color', 'nevo' ),
							'selector'   => "{$selector} button.search-button",
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => 'border-color: {{value}};',
						),

						array(
							'name'       => $name . '_border_radius',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Radius', 'nevo' ),
							'selector'   => "{$selector} button.search-button",
							'css_format' => array(
								'top'    => 'border-top-left-radius: {{value}};',
								'right'  => 'border-top-right-radius: {{value}};',
								'bottom' => 'border-bottom-right-radius: {{value}};',
								'left'   => 'border-bottom-left-radius: {{value}};',
							),
						),
					),
					'hover_fields'   => array(
						array(
							'name'       => $name . '_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color', 'nevo' ),
							'selector'   => ".header-search.focus button.search-button, {$selector} button.search-button:hover",
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_bg_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => ".header-search.focus button.search-button, {$selector} button.search-button:hover",
							'css_format' => 'background-color: {{value}};',
						),
						
					),
				),
			),
						
			array(
				'name'            => $section . '_dropdown_width',
				'type'            => 'slider',
				'priority'   	  => 30,
				'device_settings' => true,
				'section'         => $section,
				'min'             => 200,
				'step'            => 1,
				'max'             => 500,
				'default'         => array(
					'desktop' => array(
						'unit' => 'px',
						'value' => '250',
					),
					'tablet'  => array(
						'unit' => 'px',
						'value' => '250',
					),
					'mobile'  => array(
						'unit' => 'px',
						'value' => '250',
					),
				),
				'selector'        => "$selector .sub-dropdown",
				'css_format'      => 'width: {{value}};',
				'label'           => __( 'Form Dropdown Width', 'nevo' ),
			),
			
			array(
				'name'    => $name . '_h_search',
				'type'    => 'hr',
				'priority'   => 40,
				'section' => $section,
			),
			
			array(
				'name'        => $section . '_styling',
				'type'        => 'styling',
				'priority'    => 50,
				'section'     => $section,
				'css_format'  => 'styling',
				'title'       => __( 'Search Box Style', 'nevo' ),
				'selector'    => array(
					'normal' => "{$selector} .search-form button.search-submit",
					'normal_border_radius' => "{$selector} .search-form .search-field, {$selector} .search-form button.search-submit",
					'hover'  => "{$selector} .search-form button.search-submit:hover",
					'normal_text_color' => "{$selector} .search-form button.search-submit",
				),
				'fields'      => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'link_color'    => false,
						'bg_cover'      => false,
						'bg_image'      => false,
						'bg_repeat'     => false,
						'bg_attachment' => false,
						'margin'        => false,
						'padding'        => false,
						'paddinga'    	 => false,
						'margin'         => false,
						'border_width'   => false,
						'border_color'   => false,
						'box_shadow'     => false,
						'border_style'   => false,
					),
					'hover_fields'  => array(
						'link_color'    => false,
						'padding'       => false,
						'bg_cover'      => false,
						'bg_image'      => false,
						'bg_repeat'     => false,
						'bg_attachment' => false,
						'border_radius' => false,
						'padding'        => false,
						'margin'         => false,
						'border_heading' => false,
						'border_width'   => false,
						'border_color'   => false,
						'border_radius'  => false,
						'box_shadow'     => false,
						'border_style'   => false,
					),
				),
			),
			
			array(
				'name'            => $section . '_width',
				'type'            => 'slider',
				'priority'   	  => 60,
				'device_settings' => true,
				'section'         => $section,
				'min'             => 5,
				'step'            => 1,
				'max'             => 100,
				'unit' 			  => '%',
				'default'         => array(
					'desktop' => array(
						'value' => '100',
					),
					'tablet'  => array(
						'value' => '100',
					),
					'mobile'  => array(
						'value' => '100',
					),
				),
				'selector'        => "$selector.search-box",
				'css_format'      => 'width: {{value_no_unit}}%;',
				'label'           => __( 'Search box Width', 'nevo' ),
			),

		);
		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_header_search_config', 399 );