<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_layouts_config' ) ) {
	/**
	 * Add layout settings.
	 *
	 * @param array $configs
	 * @return array
	 */
	function nevo_customizer_layouts_config( $configs ) {
		$config = array(

			// General panel.
			array(
				'name'           => 'general_panel',
				'type'           => 'panel',
				'priority'       => 1,
				'theme_supports' => '',
				'title'          => __( 'General', 'nevo' ),
			),

			// Global layout section.
			array(
				'name'           => 'global_layouts',
				'type'           => 'section',
				'panel'          => 'general_panel',
				'theme_supports' => '',
				'priority' 		 => 30,
				'title'          => __( 'Global Layouts', 'nevo' ),
			),
			
			array(
				'name'        => 'site_layout',
				'type'        => 'radio_group',
				'section'     => 'global_layouts',
				'title'       => __( 'Site layout', 'nevo' ),
				'description' => __( 'Select global site layout.', 'nevo' ),
				'default'     => 'full-width',
				'css_format'  => 'html_class',
				'selector'    => '#page',
				'choices'     => array(
					'full-width' 		=> __( 'Full Width', 'nevo' ),
					'nevo-container'	=> __( 'Boxed', 'nevo' ),
				),
			),

			array(
				'name'       => 'site_box_shadow',
				'type'       => 'radio_group',
				'section'    => 'global_layouts',
				'title'      => __( 'Site boxed shadow', 'nevo' ),
				'choices'    => array(
					'box-shadow'    => __( 'Yes', 'nevo' ),
					'no-box-shadow' => __( 'No', 'nevo' ),
				),
				'default'    => 'box-shadow',
				'css_format' => 'html_class',
				'selector'   => '#page',
				'required'   => array(
					array( 'site_layout', '=', 'nevo-container' ),
				),
			),

			array(
				'name'            => 'container_width',
				'type'            => 'slider',
				'device_settings' => false,
				'default'         => 1200,
				'min'             => 500,
				'step'            => 10,
				'max'             => 2000,
				'section'         => 'global_layouts',
				'title'           => __( 'Container width', 'nevo' ),
				'selector'        => 'format',
				'css_format'      => '.site .nevo-container, .site.nevo-container { max-width: {{value}}; }',
			),
			
			array(
				'name'            => 'container_narrow_width',
				'type'            => 'slider',
				'device_settings' => false,
				'default'         => 840,
				'min'             => 500,
				'step'            => 10,
				'max'             => 2000,
				'section'         => 'global_layouts',
				'title'           => __( 'Content Narrow Max width', 'nevo' ),
				'selector'        => 'format',
				'css_format'      => '.content-narrow .site-content { max-width: {{value}}; }',
			),
			
			array(
				'name'            => 'sidebar_width',
				'type'            => 'slider',
				'device_settings' => false,
				'section'         => 'global_layouts',
				'label'           => __( 'Sidebar Width', 'nevo' ),
				'selector'        => 'format',
				'css_format'      =>'.left-sidebar .sidebar, .right-sidebar .sidebar, .both-sidebars .sidebar, .both-left .sidebar, .both-right .sidebar{ width: {{value_no_unit}}%; } .left-sidebar .site-content .content-area, .right-sidebar .site-content .content-area { width: calc(100% - {{value_no_unit}}%); } .both-sidebars .site-content .content-area, .both-left .site-content .content-area, .both-right .site-content .content-area { width: calc(100% - {{value_no_unit}}% - {{value_no_unit}}%); }',
				'default'         => 30,
				'max'             => 100,
				'min'             => 0,
				'unit'            => '%',
			),
		
			array(
				'name'        => 'content_layout',
				'type'        => 'radio_group',
				'section'     => 'global_layouts',
				'title'       => __( 'Content layout', 'nevo' ),
				'description' => __( 'Select global Content layout.', 'nevo' ),
				'default'     => 'separate-containers',
				'css_format'  => 'html_class',
				'selector'    => '#page',
				'choices'     => array(
					'separate-containers' => __( 'Separate Containers', 'nevo' ),
					'one-container'		  => __( 'One Container', 'nevo' ),
				),
			),
			
			array(
				'name'            => 'separating_space',
				'type'            => 'slider',
				'device_settings' => false,
				'default'         => 20,
				'min'             => 0,
				'step'            => 2,
				'max'             => 100,
				'section'         => 'global_layouts',
				'title'           => __( 'Separating Space', 'nevo' ),
				'selector'        => 'format',
				'css_format'      => '.separate-containers .site-main { margin: {{value}}; } .separate-containers .site-content .inside-right-sidebar, .separate-containers .site-content .inside-left-sidebar { margin-top: {{value}};margin-bottom: {{value}}; } .separate-containers.both-right .inside-left-sidebar, .separate-containers.both-left .inside-left-sidebar { margin-right: calc({{value}} / 2);} .separate-containers.both-right .inside-right-sidebar, .separate-containers.both-left .inside-right-sidebar { margin-left: calc({{value}} / 2);} .separate-containers .blog-cols > article, .separate-containers .single-after-entry > *, .sidebar .widget, .site-main .page-header, .site-main > * { margin-bottom: {{value}}; } .separate-containers .blog-cols { margin-left: -{{value}}; } .separate-containers .blog-cols > article { padding-left: {{value}}; } .separate-containers .blog-cols .paging-navigation { margin-left: {{value}}; }',
				'required'   => array(
					array( 'content_layout', '=', 'separate-containers' ),
				),
			),
			
			array(
				'name'            => 'separate_containers_padding',
				'type'            => 'css_ruler',
				'section'         => '',
				'title'           => __( 'Content Padding', 'nevo' ),
				'device_settings' => false,
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'right'  => 'padding-right: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
					'left'   => 'padding-left: {{value}};',
				),
				'selector'        => '.separate-containers .widget-area .widget,.separate-containers .paging-navigation,.separate-containers .inside-article,.separate-containers .comments-area,.separate-containers .single-after-entry > *',
				'required'   => array(
					array( 'content_layout', '=', 'separate-containers' ),
				),
			),
			
			array(
				'name'            => 'one_container_padding',
				'type'            => 'css_ruler',
				'section'         => 'global_layouts',
				'title'           => __( 'Content Padding', 'nevo' ),
				'device_settings' => true,
				
				'fields_disabled' => array(
					'left'  => '',
					'right' => '',
				),
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
				),
				'selector'        => '.one-container .site-content',
				'required'   => array(
					array( 'content_layout', '=', 'one-container' ),
				),
			),
			
			// Page layout.
			array(
				'name'           => 'global_sidebar_layouts',
				'type'           => 'section',
				'panel'          => 'general_panel',
				'priority' 		 => 40,
				'title'          => __( 'Global Sidebars', 'nevo' ),
			),
			
			// Global sidebar layout.
			array(
				'name'    => 'sidebar_layout',
				'type'    => 'image_select',
				'priority' => 50,
				'default' => 'right-sidebar',
				'section' => 'global_sidebar_layouts',
				'title'   => __( 'Default Sidebar Layout', 'nevo' ),
				'choices' => array(
					'content-narrow' => array(
						'img' => esc_url( get_template_directory_uri() ) . '/assets/images/sidebar/no-sidebar-narrow.png',
					),
					'no-sidebar' 	=> array(
						'img' => esc_url( get_template_directory_uri() ) . '/assets/images/sidebar/content-no-sidebar.png',
					),
					'left-sidebar' => array(
						'img' => esc_url( get_template_directory_uri() ) . '/assets/images/sidebar/sidebar-content.png',
					),
					'right-sidebar' => array(
						'img' => esc_url( get_template_directory_uri() ) . '/assets/images/sidebar/content-sidebar.png',
					),
					'both-sidebars' => array(
						'img' => esc_url( get_template_directory_uri() ) . '/assets/images/sidebar/sidebar-content-sidebar.png',
					),
					'both-left' => array(
						'img' => esc_url( get_template_directory_uri() ) . '/assets/images/sidebar/sidebar-sidebar-content.png',
					),
					'both-right' => array(
						'img' => esc_url( get_template_directory_uri() ) . '/assets/images/sidebar/content-sidebar-sidebar.png',
					),
				),
			),
			
			array(
				'name'           => 'global_social_sharing',
				'type'           => 'section',
				'panel'          => 'general_panel',
				'priority' 		 => 80,
				'title'          => __( 'Global Social Sharing', 'nevo' ),
			),
				
			array(
				'name'             => 'social_sharing_button',
				'type'             => 'repeater',
				'section'          => 'global_social_sharing',
				'priority' 		   => 200,
				'selector'         => '.social-general',
				'render_callback'  => 'nevo_refresh_single_social_partials',
				'title'            => __( 'Social Sharing', 'nevo' ),
				'description'      => __( 'Drag and drop to reorder.', 'nevo' ),
				'live_title_field' => 'title',
				'addable'          => false,
				'title_only'       => true,
				'default'          => array(
					array(
						'title' => __( 'Facebook', 'nevo' ),
						'items' => 'facebook',
					),
					array(
						'title' => __( 'Twitter', 'nevo' ),
						'items' => 'twitter',
					),
					array(
						'title' => __( 'Pinterest', 'nevo' ),
						'items' => 'pinterest',
					),
					array(
						'title' => __( 'Linkedin', 'nevo' ),
						'items' => 'linkedin',
						'_visibility' => 'hidden',
					),
					array(
						'title' => __( 'Vk', 'nevo' ),
						'items' => 'vk',
						'_visibility' => 'hidden',
					),
					array(
						'title' => __( 'Reddit', 'nevo' ),
						'items' => 'reddit',
						'_visibility' => 'hidden',
					),
					array(
						'title' => __( 'Tumblr', 'nevo' ),
						'items' => 'tumblr',
						'_visibility' => 'hidden',
					),
					array(
						'title' => __( 'Viadeo', 'nevo' ),
						'items' => 'viadeo',
						'_visibility' => 'hidden',
					),
					array(
						'title' => __( 'Buffer', 'nevo' ),
						'items' => 'buffer',
						'_visibility' => 'hidden',
					),
					array(
						'title' => __( 'Whatsapp', 'nevo' ),
						'items' => 'whatsapp',
						'_visibility' => 'hidden',
					),
					array(
						'title' => __( 'Viber', 'nevo' ),
						'items' => 'viber',
						'_visibility' => 'hidden',
					),
					array(
						'title' => __( 'Email', 'nevo' ),
						'items' => 'email',
						'_visibility' => 'hidden',
					),
				),
				'fields'           => array(
					array(
						'name'  => 'title',
						'type'  => 'hidden',
						'label' => __( 'Title', 'nevo' ),
					),

					array(
						'name' => 'items',
						'type' => 'hidden',
					),
					
				),
			),
		);
		return array_merge( $configs, $config );
	}
}

add_filter( 'nevo/customizer/config', 'nevo_customizer_layouts_config' );

function nevo_refresh_single_social_partials() {
	if ( is_single ){
		nevo_get_template_part('blog/social', 'sharing');
	}
	else {
		nevo_get_template_part('social', 'sharing');
	}
}