<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_page_header_config' ) ) {
	function nevo_customizer_page_header_config( $configs = array() ) {
		$section = 'page_header';
		
		$config = array(
			
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel'    => 'general_panel',
				'title'    => __( 'Global Page Header', 'nevo' ),
				'description' => __( 'General settings for Content Header of Pages, Posts, Post Type and Archives.', 'nevo' ),
				'priority' => 100,
			),
			
			array(
				'name'            => $section . '_display',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => '.page-header',
				'default'         => 1,
				'title'  		  => __( 'Display Page Header', 'nevo' ),
			),
			
			array(
				'name'       => $section . '_overlay_color',
				'type'       => 'color',
				'section'    => $section,
				'title'      => __( 'Background overlay color', 'nevo' ),
				'placeholder' => '#212529',
				'default'     => 'rgba(0,0,0,0.39)',
				'selector'   => '.page-header:before',
				'css_format' => 'background-color: {{value}}',
			),
			
			array(
				'name'       => $section . '_style',
				'type'       => 'styling',
				'section'    => $section,
				'title'      => __( 'Page Header Styling', 'nevo' ),
				'selector'   => array(
					'normal' => '.page-header',
					'normal_bg_color' => '.page-header',
					'normal_paddinga' => '.page-header .inside-page-header',
					'normal_text_color' => '.page-header .inside-page-header, .page-header .page-title, .page-header .entry-title, .page-header .inside-page-header .entry-meta, .page-header .search-field',
					'normal_link_color' => '.page-header .inside-page-header a',
					'hover_link_color' => '.page-header .inside-page-header a:hover, .page-header .inside-page-header a:focus',
				),
				'default'   => array(
					'normal' => array(
						'text_color' => '#ffffff',
						'link_color' => '#ffffff',
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'margin'    => false,
						'padding'   => false,
						'box_shadow' => false,
					),
					'hover_fields'  => array(
						'text_color'     => false,
						'padding'        => false,
						'margin'         => false,
						'bg_heading' 	 => false,
						'bg_color' 		 => false,
						'bg_image' 		 => false,
						'border_heading' => false,
						'border_width'   => false,
						'border_color'   => false,
						'border_radius'  => false,
						'box_shadow'     => false,
						'border_style'   => false,
					),
				),
			),
		);
		return array_merge( $configs, $config );
	}
}

add_filter( 'nevo/customizer/config', 'nevo_customizer_page_header_config' );