<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_typography_config' ) ) {
	
	function nevo_customizer_typography_config( $configs ) {

		$section = 'global_typography';

		$config = array(
			array(
				'name'  => "{$section}",
				'type'  => 'section',
				'panel' => 'general_panel',
				'title' => __( 'Global Typography', 'nevo' ),
				'priority' => 50,
			),
			
			array(
				'name'    => "{$section}_h_site_tt",
				'type'    => 'heading',
				'section' => "{$section}",
				'title'   => __( 'Site Title & Tagline Font', 'nevo' ),
			),

			array(
				'name'       => "{$section}_site_tt_title",
				'type'       => 'typography',
				'section'    => "{$section}",
				'title'      => __( 'Site Title', 'nevo' ),
				'css_format' => 'typography',
				'selector'   => '.site-branding .main-title, .site-branding .main-title a',
			),

			array(
				'name'       => "{$section}_site_tt_desc",
				'type'       => 'typography',
				'section'    => "{$section}",
				'title'      => __( 'Tagline', 'nevo' ),
				'css_format' => 'typography',
				'selector'   => '.site-branding .site-description',
			),

			array(
				'name'    => "{$section}_h_base",
				'type'    => 'heading',
				'section' => "{$section}",
				'title'   => __( 'Base Font', 'nevo' ),
			),
			
			array(
				'name'    	 => 'content_link_text_decoration',
				'type'    	 => 'select',
				'section'    => "{$section}",
				'css_format' => 'typography',
				'selector'   => '.entry-content a',
				'label'    	 => __( 'Content Link Text Decoration', 'nevo' ),
				'default'    => 'underline',
				'css_format' => 'text-decoration: {{value}};',
				'choices' => array(
					''             => __( 'Default', 'nevo' ),
					'underline'    => __( 'Underline', 'nevo' ),
					'overline'     => __( 'Overline', 'nevo' ),
					'line-through' => __( 'Line through', 'nevo' ),
					'none'         => __( 'None', 'nevo' ),
				),
			),
			
			array(
				'name'        => "{$section}_base_p",
				'type'        => 'typography',
				'section'     => "{$section}",
				'title'       => __( 'Body', 'nevo' ),
				'description' => __( 'Apply to body and paragraph text.', 'nevo' ),
				'css_format'  => 'typography',
				'selector'    => 'body',
			),

			array(
				'name'        => "{$section}_base_entry_title",
				'type'        => 'typography',
				'section'     => "{$section}",
				'title'       => __( 'Title', 'nevo' ),
				'description' => __( 'Apply to post, page and Archive title.', 'nevo' ),
				'css_format'  => 'typography',
				'selector'    => '.page-title, .entry-title',
				'fields'      => array(
					'font_size'      => false,
				),
			),
			
			array(
				'name'        => "{$section}_blockquote",
				'type'        => 'typography',
				'section'     => "{$section}",
				'title'       => __( 'Blockquote', 'nevo' ),
				'css_format'  => 'typography',
				'selector'    => 'blockquote, .wp-block-quote p, .wp-block-pullquote blockquote p',
			),

			array(
				'name'        => "{$section}_base_widget_title",
				'type'        => 'typography',
				'section'     => "{$section}",
				'title'       => __( 'Heading Title', 'nevo' ),
				'description' => __( 'Used for global titles like Modules, Section,</br> Related Posts, Comments, Widget Title.', 'nevo' ),
				'css_format'  => 'typography',
				'selector'    => '.heading-title .general-title, .comments .comment-reply-title',
			),

			// Content.
			
			array(
				'name'    => "{$section}_h_heading",
				'type'    => 'heading',
				'section' => "{$section}",
				'title'   => __( 'Heading Font', 'nevo' ),
			),

			array(
				'name'        => "{$section}_base_heading",
				'type'        => 'typography',
				'section'     => "{$section}",
				'title'       => __( 'Heading', 'nevo' ),
				'description' => __( 'Apply to all headings elements.', 'nevo' ),
				'css_format'  => 'typography',
				'selector'    => 'h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6',
				'fields'      => array(
					'font_size'      => false,
				),
			),
			
			array(
				'name'       => "{$section}_heading_h1",
				'type'       => 'typography',
				'section'    => "{$section}",
				'title'      => __( 'Heading H1', 'nevo' ),
				'css_format' => 'typography',
				'selector'   => '.entry-content h1, .wp-block h1',
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
			),

			array(
				'name'       => "{$section}_heading_h2",
				'type'       => 'typography',
				'section'    => "{$section}",
				'title'      => __( 'Heading H2', 'nevo' ),
				'css_format' => 'typography',
				'selector'   => '.entry-content h2, .wp-block h2',
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
			),

			array(
				'name'       => "{$section}_heading_h3",
				'type'       => 'typography',
				'section'    => "{$section}",
				'title'      => __( 'Heading H3', 'nevo' ),
				'css_format' => 'typography',
				'selector'   => '.entry-content h3, .wp-block h3',
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
			),

			array(
				'name'       => "{$section}_heading_h4",
				'type'       => 'typography',
				'section'    => "{$section}",
				'title'      => __( 'Heading H4', 'nevo' ),
				'css_format' => 'typography',
				'selector'   => '.entry-content h4, .wp-block h4',
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
			),

			array(
				'name'       => "{$section}_heading_h5",
				'type'       => 'typography',
				'section'    => "{$section}",
				'title'      => __( 'Heading H5', 'nevo' ),
				'css_format' => 'typography',
				'selector'   => '.entry-content h5, .wp-block h5',
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
			),

			array(
				'name'       => "{$section}_heading_h6",
				'type'       => 'typography',
				'section'    => "{$section}",
				'title'      => __( 'Heading H6', 'nevo' ),
				'css_format' => 'typography',
				'selector'   => '.entry-content h6, .wp-block h6',
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
			),
		);

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_typography_config', 299 );