<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( is_admin() || is_customize_preview() ) {

	add_filter( 'nevo/customizer/config', 'nevo_pro_upsell', 9999 );

	function nevo_pro_upsell( $configs ) {

		if ( class_exists( 'Nevo_Pro' ) ) {
			return $configs;
		}

		$configs[] = array(
			'name'          => 'nevo-pro',
			'type'          => 'section',
			'section_class' => 'Nevo_WP_Customize_Section_Pro',
			'priority'      => 500,
			'pro_text'      => __( 'Nevo Pro modules available', 'nevo' ),
			'pro_url'       => 'https://nevothemes.com/pro-modules/',
		);

		$configs[] = array(
			'name'          => 'header_settings_pro',
			'panel'         => 'nevo_header',
			'type'          => 'section',
			'section_class' => 'Nevo_WP_Customize_Section_Pro',
			'priority'      => 99999,
			'title'         => __( 'Header options in Nevo Pro', 'nevo' ),
			'teaser'        => true,
			'pro_url'       => 'https://nevothemes.com/pro-modules/',
			'features'      => array(
				__( 'Header Sticky', 'nevo' ),
				__( 'Header Transparent', 'nevo' ),
				__( 'More HTML Items', 'nevo' ),
				__( 'Secondary Menu', 'nevo' ),
				__( 'Vertical Menu', 'nevo' ),
				__( 'Mega Menu', 'nevo' ),
				__( 'Icon Box', 'nevo' ),
				__( 'And more header settings', 'nevo' ),
			),
		);

		$configs[] = array(
			'name'          => 'blog_settings_pro',
			'panel'         => 'blog_panel',
			'type'          => 'section',
			'section_class' => 'Nevo_WP_Customize_Section_Pro',
			'priority'      => 99999,
			'title'         => __( 'Magazine in Nevo Pro', 'nevo' ),
			'teaser'        => true,
			'pro_url'       => 'https://nevothemes.com/pro-modules/',
			'features'      => array(
				__( 'Featured Hero Category', 'nevo' ),
				__( 'Magazine Modules', 'nevo' ),
				__( 'Category Layouts', 'nevo' ),
				__( 'Single Layouts', 'nevo' ),
				__( 'Related Post Layouts', 'nevo' ),
				__( 'And more settings', 'nevo' ),
			),
		);

		$configs[] = array(
			'name'          => 'sidebar_settings_pro',
			'panel'         => 'general_panel',
			'type'          => 'section',
			'section_class' => 'Nevo_WP_Customize_Section_Pro',
			'priority'      => 99999,
			'title'         => __( 'Sidebar Sticky in Nevo Pro', 'nevo' ),
			'teaser'        => true,
			'pro_url'       => 'https://nevothemes.com/pro-modules/',
			'features'      => array(
				__( 'Sidebar Sticky', 'nevo' ),
				__( 'Sidebar Widget Styling', 'nevo' ),
				__( 'And more settings', 'nevo' ),
			),
		);

		$configs[] = array(
			'name'          => 'woo_settings_pro',
			'panel'         => 'woocommerce',
			'type'          => 'section',
			'section_class' => 'Nevo_WP_Customize_Section_Pro',
			'priority'      => 99999,
			'title'         => __( 'Woocommerce Booster in Nevo Pro', 'nevo' ),
			'teaser'        => true,
			'pro_url'       => 'https://nevothemes.com/pro-modules/',
			'features'      => array(
				__( 'Off Canvas Filter', 'nevo' ),
				__( 'Custom Add To Cart', 'nevo' ),
				__( 'Quick View', 'nevo' ),
				__( 'Single Product Layouts', 'nevo' ),
				__( 'Image Gallery', 'nevo' ),
				__( 'Social Sharing', 'nevo' ),
				__( 'Custom Cart Page', 'nevo' ),
				__( 'Custom Checkout Page', 'nevo' ),
				__( 'And more settings', 'nevo' ),
			),
		);

		$configs[] = array(
			'name'          => 'footer_settings_pro',
			'panel'         => 'nevo_footer',
			'type'          => 'section',
			'priority'      => 99999,
			'section_class' => 'Nevo_WP_Customize_Section_Pro',
			'title'         => __( 'More Footer options in Nevo Pro', 'nevo' ),
			'pro_url'       => 'https://nevothemes.com/pro-modules/',
			'teaser'        => true,
			'features'      => array(
				__( 'More HTML Items', 'nevo' ),
				__( 'Icon Box Item', 'nevo' ),
				__( 'Contact Info Item', 'nevo' ),
				__( 'Payment Methods Item', 'nevo' ),
			),
		);

		return $configs;
	}
}
