<?php
/**
 * Add compatibility for some popular third party plugins.
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_pro_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'nevo_pro_css', 100 );
	/**
	 * Add BuddyPress CSS
	 *
	 * @since 1.0
	 */
	function nevo_pro_css() {
		if ( ! class_exists( 'Nevo_Pro' ) ) {
			return;
		}

		$css = '.page-template-frontpage .separate-containers .site-main {
			margin: 0;
		}
		.page-template-frontpage .site-content.nevo-container,
		.page-template-frontpage .site-content .content-area {
			width: 100%;
			max-width: 100%;
		}';

		$css = nevo_minify_css_string( $css );
		wp_add_inline_style( 'nevo-style', $css );
	}
}

if ( ! function_exists( 'nevo_woocommerce_css' ) ) {
	//add_action( 'wp_enqueue_scripts', 'nevo_woocommerce_css', 100 );
	/**
	 * Add WooCommerce CSS
	 *
	 * @since 1.0
	 */
	function nevo_woocommerce_css() {
		if ( ! class_exists( 'WooCommerce' ) ) {
			return;
		}

		$mobile = nevo_get_media_query( 'mobile' );

		$css = '.woocommerce .entry-content,
		.woocommerce .product .entry-summary {
			margin-top: 0;
		}

		.related.products {
			clear: both;
		}

		.checkout-subscribe-prompt.clear {
			visibility: visible;
			height: initial;
			width: initial;
		}

		@media ' . esc_attr( $mobile ) . ' {
			.woocommerce .woocommerce-ordering,
			.woocommerce-page .woocommerce-ordering {
				float: none;
			}

			.woocommerce .woocommerce-ordering select {
				max-width: 100%;
			}

			.woocommerce ul.products li.product,
			.woocommerce-page ul.products li.product,
			.woocommerce-page[class*=columns-] ul.products li.product,
			.woocommerce[class*=columns-] ul.products li.product {
				width: 100%;
				float: none;
			}
		}';

		$css = str_replace( array( "\r", "\n", "\t" ), '', $css );
		wp_add_inline_style( 'woocommerce-style', $css );
	}
}

if ( ! function_exists( 'nevo_bbpress_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'nevo_bbpress_css', 100 );
	/**
	 * Add bbPress CSS
	 *
	 * @since 1.0
	 */
	function nevo_bbpress_css() {
		if ( ! class_exists( 'bbPress' ) ) {
			return;
		}

		$css = '#bbpress-forums ul.bbp-lead-topic,
		#bbpress-forums ul.bbp-topics,
		#bbpress-forums ul.bbp-forums,
		#bbpress-forums ul.bbp-replies,
		#bbpress-forums ul.bbp-search-results,
		#bbpress-forums,
		div.bbp-breadcrumb,
		div.bbp-topic-tags {
			font-size: inherit;
		}

		.single-forum #subscription-toggle {
			display: block;
			margin: 1em 0;
			clear: left;
		}

		#bbpress-forums .bbp-search-form {
			margin-bottom: 10px;
		}

		.bbp-login-form fieldset {
			border: 0;
			padding: 0;
		}';

		$css = str_replace( array( "\r", "\n", "\t" ), '', $css );
		wp_add_inline_style( 'bbp-default', $css );
	}
}

if ( ! function_exists( 'nevo_buddypress_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'nevo_buddypress_css', 100 );
	/**
	 * Add BuddyPress CSS
	 *
	 * @since 1.0
	 */
	function nevo_buddypress_css() {
		if ( ! class_exists( 'BuddyPress' ) ) {
			return;
		}

		$css = '#buddypress form#whats-new-form #whats-new-options[style] {
			min-height: 6rem;
			overflow: visible;
		}';

		$css = str_replace( array( "\r", "\n", "\t" ), '', $css );
		wp_add_inline_style( 'bp-legacy-css', $css );
	}
}

if ( ! function_exists( 'nevo_beaver_builder_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'nevo_beaver_builder_css', 100 );
	/**
	 * Add Beaver Builder CSS
	 *
	 * Beaver Builder pages set to no sidebar used to automatically be full width, however
	 * now that we have the Page Builder Container meta box, we want to give the user
	 * the option to set the page to full width or contained.
	 *
	 * We can't remove this CSS as people who are depending on it will lose their full
	 * width layout when they update.
	 *
	 * So instead, we only apply this CSS to posts older than the date of this update.
	 *
	 * @since 1.0
	 */
	function nevo_beaver_builder_css() {
		
		$body_classes = get_body_class();

		// Check is Beaver Builder is active
		// If we have the full-width-content class, we don't need to do anything else.
		if ( in_array( 'fl-builder', $body_classes ) && ! in_array( 'full-width-content', $body_classes ) && ! in_array( 'contained-content', $body_classes ) ) {
			global $post;

			if ( ! isset( $post ) ) {
				return;
			}

			$compare_date = strtotime( '2017-03-14' );
			$post_date    = strtotime( $post->post_date );
			if ( $post_date < $compare_date ) {
				$css = '.fl-builder.no-sidebar .nevo-container {
					max-width: 100%;
				}

				.fl-builder.one-container.no-sidebar .site-content {
					padding:0;
				}';
				$css = str_replace( array( "\r", "\n", "\t" ), '', $css );
				wp_add_inline_style( 'nevo-style', $css );
			}
		}
	}
}

add_action( 'wp_enqueue_scripts', 'nevo_do_third_party_plugin_css', 50 );
/**
 * Add CSS for third-party plugins.
 *
 * @since 1.0
 */
function nevo_do_third_party_plugin_css() {
	
	if ( class_exists( 'Elementor\Plugin' ) ) {
		$css = '.elementor-template-full-width .site-content {
					display: block;
				}
				.full-width-content .elementor-section.elementor-section-boxed > .elementor-container {
					max-width: 1160px;
				}';
				$css = str_replace( array( "\r", "\n", "\t" ), '', $css );
				wp_add_inline_style( 'nevo-style', $css );
	}
}