<?php
/**
 * Social function
 *
 * This file is a part of the Nevo theme and should not be edited directly.
 * Instead, all customizations should be done through Nevo Child Themes.
 *
 * @package Nevo
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_do_social_sharing' ) ) {
	/**
	 * Build the social items.
	 *
	 * @since 1.0.0
	 */
	function nevo_do_social_sharing( $class, $show = true ) {
		
		$items = Nevo()->get_setting( 'social_sharing_button' );

		if ( Nevo()->get_setting( 'social_sharing_button', 'items' ) || Nevo()->get_setting( 'social_sharing_button', '_visibility' ) ) {
			echo '<div class="social-sharing social-general d-flex align-items-center cv-col-12 justify-content-center'. esc_attr( $class ) .'">';
				if ( $show || $class !== 'position' ) {
					echo '<div class="social-share-text d-flex align-items-center">'. nevo_get_svg_icon( 'ui', 'bi-share-fill', '', 16 ) .'<span class="d-sm-block d-none">'. __( 'Share', 'nevo' ) .' </span></div>';
				}
				foreach ( $items as $item ) {
					$item = wp_parse_args(
						$item,
						array(
							'title'       => '',
							'items'    	  => '',
							'_visibility' => '',
						)
					);
					if ( 'hidden' !== $item['_visibility'] ) {
						nevo_do_social_item( $item['items'] );
					}
				} 
			echo '</div>';
		}
	}
}

/**
 * Output requested social sharing.
 *
 * @since 1.0
 *
 * @param string $item The social sharing item we're requesting.
 */
function nevo_do_social_item( $item ) {
	global $post;
	// Get current page url 
	$nevourl = urlencode(get_permalink());
	// Get current page title
	$nevoTitle = htmlspecialchars(urlencode(html_entity_decode(get_the_title(), ENT_COMPAT, 'UTF-8')), ENT_COMPAT, 'UTF-8');
	// Get Post Thumbnail for pinterest
	$nevoThumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
	if ( ! $nevoThumbnail) {
		$nevoThumbnail = 'No Thumbnail';
	}
	
	if ( 'facebook' === $item ) {
		$facebookurl = 'https://www.facebook.com/sharer/sharer.php?u='.$nevourl; // Construct sharing url without using any script
	
		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_facebook_social_output',
			sprintf(
				'<a class="social-icons nevo-facebook d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Facebook" href="%1$s">%2$s<span class="screen-reader-text">Share on Facebook</span></a>',
				$facebookurl,
				apply_filters( 'nevo_inside_social_output', '', 'facebook' )
			)
		);
	}
	if ( 'twitter' === $item ) {
		$twitterurl = 'https://twitter.com/intent/tweet?text='.$nevoTitle.'&amp;url='.$nevourl; // Construct sharing url without using any script
	
		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_twitter_social_output',
			sprintf(
				'<a class="social-icons nevo-twitter d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Twitter" href="%1$s">%2$s<span class="screen-reader-text">Share on Twitter</span></a>',
				$twitterurl,
				apply_filters( 'nevo_inside_social_output', '', 'twitter' )
			)
		);
	}
	if ( 'linkedin' === $item ) {
		$linkedInurl = 'https://www.linkedin.com/shareArticle?mini=true&url='.$nevourl.'&amp;title='.$nevoTitle; // Construct sharing url without using any script

		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_linkedin_social_output',
			sprintf(
				'<a class="social-icons nevo-linkedin d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Linkedin" href="%1$s">%2$s<span class="screen-reader-text">Share on Linkedin</span></a>',
				$linkedInurl,
				apply_filters( 'nevo_inside_social_output', '', 'linkedin' )
			)
		);
	}
	if ( 'pinterest' === $item ) {
		// Based on popular demand added Pinterest too
		$pinteresturl = 'https://pinterest.com/pin/create/button/?url='.$nevourl.'&amp;media='.$nevoThumbnail[0].'&amp;description='.$nevoTitle;

		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_pinterest_social_output',
			sprintf(
				'<a class="social-icons nevo-pinterest d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Pin on Pinterest" href="%1$s">%2$s<span class="screen-reader-text">Share on Pinterest</span></a>',
				$pinteresturl,
				apply_filters( 'nevo_inside_social_output', '', 'pinterest' )
			)
		);
	}
	if ( 'vk' === $item ) {
		$vkurl = 'https://vk.com/share.php?url='.$nevourl; // Construct sharing url without using any script
	
		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_vk_social_output',
			sprintf(
				'<a class="social-icons nevo-vk d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Vk" href="%1$s">%2$s<span class="screen-reader-text">Share on Vk</span></a>',
				$vkurl,
				apply_filters( 'nevo_inside_social_output', '', 'vk' )
			)
		);
	}
	if ( 'reddit' === $item ) {
		$redditurl = 'https://www.reddit.com/submit?url='.$nevourl.'&amp;text='.$nevoTitle; // Construct sharing url without using any script
	
		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_reddit_social_output',
			sprintf(
				'<a class="social-icons nevo-reddit d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Reddit" href="%1$s">%2$s<span class="screen-reader-text">Share on Reddit</span></a>',
				$redditurl,
				apply_filters( 'nevo_inside_social_output', '', 'reddit' )
			)
		);
	}
	if ( 'tumblr' === $item ) {
		$tumblrurl = 'https://www.tumblr.com/widgets/share/tool?canonicalUrl='.$nevourl; // Construct sharing url without using any script
	
		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_tumblr_social_output',
			sprintf(
				'<a class="social-icons nevo-tumblr d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Tumblr" href="%1$s">%2$s<span class="screen-reader-text">Share on Tumblr</span></a>',
				$tumblrurl,
				apply_filters( 'nevo_inside_social_output', '', 'tumblr' )
			)
		);
	}
	if ( 'viadeo' === $item ) {
		$viadeourl = 'https://partners.viadeo.com/share?url='.$nevourl; // Construct sharing url without using any script
	
		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_viadeo_social_output',
			sprintf(
				'<a class="social-icons nevo-viadeo d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Viadeo" href="%1$s">%2$s<span class="screen-reader-text">Share on Viadeo</span></a>',
				$viadeourl,
				apply_filters( 'nevo_inside_social_output', '', 'viadeo' )
			)
		);
	}
	if ( 'pocket' === $item ) {
		$pocketurl = 'https://getpocket.com/save?url='.$nevourl; // Construct sharing url without using any script
	
		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_pocket_social_output',
			sprintf(
				'<a class="social-icons nevo-pocket d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Pocket" href="%1$s">%2$s<span class="screen-reader-text">Share on Pocket</span></a>',
				$pocketurl,
				apply_filters( 'nevo_inside_social_output', '', 'pocket' )
			)
		);
	}
	if ( 'buffer' === $item ) {
		$bufferurl = 'https://bufferapp.com/add?url='.$nevourl.'&amp;text='.$nevoTitle; // Construct sharing url without using any script

		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_buffer_social_output',
			sprintf(
				'<a class="social-icons nevo-buffer d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Buffer" href="%1$s">%2$s<span class="screen-reader-text">Share on Buffer</span></a>',
				$bufferurl,
				apply_filters( 'nevo_inside_social_output', '', 'buffer' )
			)
		);
	}
	if ( 'whatsapp' === $item ) {
		$whatsappurl = 'whatsapp://send?text='.$nevoTitle . ' ' . $nevourl;

		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_whatsapp_social_output',
			sprintf(
				'<a class="social-icons nevo-whatsapp d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Whatsapp" href="%1$s">%2$s<span class="screen-reader-text">Share on Whatsapp</span></a>',
				$whatsappurl,
				apply_filters( 'nevo_inside_social_output', '', 'whatsapp' )
			)
		);
	}
	if ( 'viber' === $item ) {
		$viberurl = 'viber://forward?text='.$nevoTitle . ' ' . $nevourl;

		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_viber_social_output',
			sprintf(
				'<a class="social-icons nevo-viber d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Share on Viber" href="%1$s">%2$s<span class="screen-reader-text">Share on Viber</span></a>',
				$viberurl,
				apply_filters( 'nevo_inside_social_output', '', 'viber' )
			)
		);
	}
	if ( 'email' === $item ) {
		echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'nevo_whatsapp_social_output',
			sprintf(
				'<a class="social-icons nevo-email d-inline-flex align-items-center" target="_blank" rel="noopener external nofollow" title="Email to a Friend" href="mailto:?subject=%1$s&amp;body=%2$s">%3$s<span class="screen-reader-text">Share on Email</span></a>',
				$nevoTitle,
				$nevourl,
				apply_filters( 'nevo_inside_social_output', '', 'email' )
			)
		);
	}
	/**
	 * nevo_social_sharing_items hook.
	 *
	 * @since 1.0
	 */
	do_action( 'nevo_social_sharing_items', $item );
	
}

add_filter( 'nevo_inside_social_output', 'nevo_do_sharing_prefix', 10, 2 );
/**
 * Add svg icons or text to our social output.
 *
 * @since 1.0.0
 * @param string $output The existing output.
 * @param string $item The item to target.
 */
function nevo_do_sharing_prefix( $output, $item ) {
	$label = '<span class="social-label d-md-inline-block d-none">'. $item .'</span>';
	
	if ( 'facebook' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'facebook', '', 16 ) . $label;
	}
	if ( 'twitter' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'twitter', '', 22 ) . $label;
	}
	if ( 'linkedin' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'linkedin', '', 20 ) . $label;
	}
	if ( 'pinterest' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'pinterest', '', 20 ) . $label;
	}
	if ( 'vk' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'vk', '', 22 ) . $label;
	}
	if ( 'reddit' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'reddit', '', 24 ) . $label;
	}
	if ( 'tumblr' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'tumblr', '', 20 ) . $label;
	}
	if ( 'viadeo' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'viadeo', '', 20 ) . $label;
	}
	if ( 'buffer' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'buffer', '', 16 ) . $label;
	}
	if ( 'pocket' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'pocket', '', 18 ) . $label;
	}
	if ( 'whatsapp' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'whatsapp', '', 18 ) . $label;
	}
	if ( 'viber' === $item ) {
		$output = nevo_get_svg_icon( 'social', 'viber', '', 16 ) . $label;
	}
	if ( 'email' === $item ) {
		$output = nevo_get_svg_icon( 'ui', 'bi-envelope-fill', '', 18 ) . $label;
	}

	return $output;
}