<?php
/**
 * Main theme.
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Build the core framework components, structure, and hooks.
 *
 * @since 1.0.0
 */
function nevo_main_structure() {

	get_header();
	/**
	 * nevo_before_primary_content_area hook.
	 *
	 * @since 1.0
	 */
	do_action( 'nevo_before_primary_content_area' );
	?>
	<div <?php nevo_do_attr( 'content' ); ?>>
	
		<?php do_action( 'nevo_before_main' ); ?>
		
		<main <?php nevo_do_attr( 'main' ); ?>>
	
			<?php
			/**
			 * nevo_before_loop hook.
			 *
			 * @since 1.0
			 */
			do_action( 'nevo_before_loop' );
			/**
			 * nevo_loop hook.
			 *
			 * @since 1.0
			 */
			do_action( 'nevo_loop' );
			/**
			 * nevo_after_loop hook.
			 *
			 * @since 1.0
			 */
			do_action( 'nevo_after_loop' );
			?>
			
		</main><!-- .site-main -->

		<?php do_action( 'nevo_after_main' ); ?>
		
	</div>
	<?php
	/**
	 * nevo_after_primary_content_area hook.
	 *
	 * @since 1.0
	 */
	do_action( 'nevo_after_primary_content_area' );

	nevo_construct_sidebars();
	
	get_footer();
	
}