<?php
/**
 * The template for displaying 404 pages.
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
add_action( 'nevo_404_entry_content', 'nevo_do_404_entry_content' );
/**
 * Build the WordPress loop.
 *
 * @since 1.0.0
 */
function nevo_do_404_entry_content() {
	?>
	<div class="inside-article">

		<?php
		/**
		 * nevo_before_content hook.
		 *
		 * @since 1.0
		 */
		do_action( 'nevo_before_content' );
		
		/**
		 * nevo_before_entry_header hook.
		 *
		 * @since 1.0
		 */
		do_action( 'nevo_before_entry_header' );
		?>

		<header <?php nevo_do_attr( 'entry_header' ); ?>>
			<?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- HTML is allowed in filter here. ?>
			<h1 class="entry-title" itemprop="headline"><?php echo apply_filters( 'nevo_404_title', __( 'Oops! That page can&rsquo;t be found.', 'nevo' ) ); ?></h1>
		</header>

		<?php
		/**
		 * nevo_after_entry_header hook.
		 *
		 * @since 0.1
		 *
		 * @hooked nevo_post_image - 10
		 */
		do_action( 'nevo_after_entry_header' );

		$itemprop = '';

		if ( 'microdata' === nevo_get_schema_type() ) {
			$itemprop = ' itemprop="text"';
		}
		?>

		<div class="entry-content"<?php echo $itemprop; // phpcs:ignore -- No escaping needed. ?>>
			<?php
			printf(
				'<p>%s</p>',
				apply_filters( 'nevo_404_text', __( 'It looks like nothing was found at this location. Maybe try searching?', 'nevo' ) ) // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- HTML is allowed in filter here.
			);

			get_search_form();
			?>
		</div>

		<?php
		/**
		 * nevo_after_content hook.
		 *
		 * @since 0.1
		 */
		do_action( 'nevo_after_content' );
		?>

	</div>
	<?php
}