<?php
/**
 * Footer elements.
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_construct_footer' ) ) {
	add_action( 'nevo_footer', 'nevo_construct_footer' );
	/**
	 * Build our footer.
	 *
	 * @since 1.0.0
	 */
	function nevo_construct_footer() {
		?>
		<div <?php nevo_do_attr( 'footer' ); ?>>
			<?php
			/**
			 * nevo_before_footer_content hook.
			 *
			 * @since 0.1
			 */
			do_action( 'nevo_before_footer_content' );
			
			/**
			 * nevo_footer hook.
			 *
			 * @since 1.0
			 *
			 * @hooked nevo_footer_display - 10
			 */
			do_action( 'nevo_footer_content' );
			

			/**
			 * nevo_after_footer_content hook.
			 *
			 * @since 0.1
			 */
			do_action( 'nevo_after_footer_content' );
			?>
		</div>
		<?php
	}
}
if ( ! function_exists( 'nevo_footer_widget_item' ) ) {
	/**
	 * Display Footer widget
	 *
	 * @param string $footer_id
	 */
	function nevo_footer_widget_item( $footer_id = 'footer-1' ) {
		$show = false;
		
		echo '<div class="footer-widgets ' . esc_attr(apply_filters('nevo_custom_footer_widgets_classes', 'widgets-' . $footer_id)) . ' builder-item-focus" data-section="sidebar-widgets-' . $footer_id .'">';
			if ( is_active_sidebar( $footer_id ) ) {
				dynamic_sidebar( $footer_id );
				$show = true;
			} 
			if ( ! $show && current_user_can( 'edit_theme_options' ) ) {
				the_widget(
					'WP_Widget_Text',
					array(
						'title'  => sprintf( __( 'Footer Widget %s', 'nevo' ), substr( $footer_id,  7, 8) ),
						'text'   => sprintf( // WPCS: XSS ok.
							/*Translators: 1: Admin URL2: Customize URL 3: Footer ID */
							__( '<p>Replace this widget content by going to <a href="%1$s"><strong>Appearance &rarr; Customize &rarr; Footer &rarr; Footer Widget %2$s</strong></a> and adding widgets into this widget area.</p>', 'nevo' ),
							esc_url( admin_url( 'customize.php?autofocus[section]=sidebar-widgets-' . $footer_id ) ),
							substr( $footer_id,  7, 8)
						),
						'filter' => true,
						'visual' => true,
					),
					array(
						'before_widget' => '<aside id="placeholder-widget-text" class="widget inner-padding">',
						'after_widget'  => '</aside>',
						'before_title'  => apply_filters( 'nevo_start_widget_title', '<div class="heading-title"><h2 class="widget-title general-title">' ),
						'after_title'   => apply_filters( 'nevo_end_widget_title', '</h2></div>' ),
					)
				);
			}
			if ( is_customize_preview() ) {
				echo '<span class="customize-partial-edit">'. esc_html( sprintf( __( 'Footer Widget %s', 'nevo' ), substr( $footer_id,  7, 8) ) ) .'</span>';
			}
		echo '</div>';
	}
}

if ( ! function_exists( 'nevo_back_to_top' ) ) {
	add_action( 'nevo_after_footer', 'nevo_back_to_top' );
	/**
	 * Build the back to top button
	 *
	 * @since 1.0.0
	 */
	function nevo_back_to_top() {
		if ( ! intval( Nevo()->get_setting( 'scrolltop_show' ) ) ) {
			return;
		}
		$icon = Nevo()->get_setting( 'scrolltop_icon' );
		$icon = wp_parse_args(
			$icon,
			array(
				'type' => '',
				'icon' => '',
			)
		);
		?>
		<a href="#page" <?php nevo_do_element_classes('scroll_to_top'); ?>>
			<span class="nevo-icon" aria-hidden="true">
			<?php echo nevo_get_svg_icon( 'ui', '' . esc_attr( $icon['icon'] ) . '', '', 16 ); ?>
			</span>
			<span class="screen-reader-text"><?php esc_html_e( 'Back to Top', 'nevo' ); ?></span>
		</a><?php
	}
}

if ( ! function_exists( 'nevo_mobile_menu_sidebar' ) ) {
	add_action( 'wp_footer', 'nevo_mobile_menu_sidebar', 100 );
	/**
	 * Build our Mobile Menu.
	 *
	 * @since 1.0
	 */
	function nevo_mobile_menu_sidebar() {
		$position     = Nevo()->get_setting( 'mobile_menu_position' );
		?>
		<div id="nevo-vertical-header" class="nevo-popup nevo-vertical-header <?php echo esc_attr( $position ); ?>">
			<div class="popup-background popup-close"></div>
			<?php
			nevo_mobile_menu_sidebar_content();
			?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'nevo_mobile_menu_sidebar_content' ) ) {
	
	function nevo_mobile_menu_sidebar_content() {
		$items        = Nevo()->get_setting( 'mobile_menu_items' );
		$title        = Nevo()->get_setting( 'mobile_menu_title' );
		if ( ! $title ) {
			$title = __( 'Offcanvas', 'nevo' );
		}
		?>
		<div class="popup-body">
			<div class="popup-header d-flex align-items-center justify-content-between">
				<div class="popup-title"><?php echo esc_html( $title ); ?></div>
				<button class="popup-close button-close d-inline-flex align-self-center" title="Close (Esc)"><?php echo nevo_get_svg_icon( 'ui', 'close', 'popup-close', 20 ); ?></button>
			</div>
			<div class="popup-content">
				<?php
				foreach ( $items as $item ) {
					$item = wp_parse_args(
						$item,
						array(
							'title'       => '',
							'elements'    => '',
							'_visibility' => '',
						)
					);

					if ( 'hidden' !== $item['_visibility'] ) {
						$id     = esc_html($item['elements']);
						nevo_header_element( $id );
					}
				}
				?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'nevo_account_sidebar' ) ) {
	//add_action( 'wp_footer', 'nevo_account_sidebar', 99 );
	/**
	 * Build our account sidebar.
	 *
	 * @since 1.0
	 */
	function nevo_account_sidebar() {
		$position     = Nevo()->get_setting( 'header_account_position' );
		if ( intval( Nevo()->get_setting( 'header_account_disable' ) ) ) {
			return;
		}?>
		<div id="header-account-vertical" class="nevo-popup header-account-vertical <?php echo esc_html( $position ); ?>">
			<div class="popup-background popup-close"></div>
			<?php
			nevo_account_sidebar_content();
			?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'nevo_account_sidebar_content' ) ) {
	
	function nevo_account_sidebar_content() {
		$title        = Nevo()->get_setting( 'header_account_title' );
		if ( ! $title ) {
			$title = __( 'Offcanvas', 'nevo' );
		}
		?>
		<div class="popup-body">
			<div class="popup-header d-flex align-items-center justify-content-between">
				<div class="popup-title"><?php echo esc_html( $title ); ?></div>
				<button class="popup-close button-close d-inline-flex align-self-center" title="Close (Esc)"><?php echo nevo_get_svg_icon( 'ui', 'close', 'popup-close', 20 ); ?></button>
			</div>
			<div class="popup-content">
				<?php
				nevo_login_form();
				?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'nevo_login_form' ) ) {
	// Login Form
	function nevo_login_form( $login_only  = 0 ) {
		global $user_identity;
		$user 		= wp_get_current_user();
		$avatar 	= get_avatar_url( $user->ID );
		if ( ! $avatar ) {
			$avatar = get_template_directory_uri() . '/assets/images/avatar.jpg';
		}
		$redirect 	= home_url();
		
		if ( is_user_logged_in() && $user ) { ?>
			<span class="welcome-text d-block text-capitalize"><?php esc_html_e( 'Welcome', 'nevo' ) ?> <?php echo $user_identity; ?></span><?php
			if ( Nevo()->is_woocommerce_active() ) {
				echo nevo_woo_account();
			} else { ?>
				<a class="d-flex align-items-center" href="<?php echo admin_url() ?>"><span class="nevo-icon cv-me-3" aria-hidden="true"><?php echo nevo_get_svg_icon( 'ui', 'bi-inbox', '', 16 ); ?></span><?php esc_html_e( 'Dashboard', 'nevo' ) ?></a>
				<a class="d-flex align-items-center" href="<?php echo admin_url() ?>profile.php"><span class="nevo-icon cv-me-3" aria-hidden="true"><?php echo nevo_get_svg_icon( 'ui', 'bi-person', '', 16 ); ?></span><?php esc_html_e( 'Your Profile', 'nevo' ) ?></a>
				<a class="d-flex align-items-center" href="<?php echo wp_logout_url($redirect); ?>"><span class="nevo-icon cv-me-3" aria-hidden="true"><?php echo nevo_get_svg_icon( 'ui', 'bi-arrow-return-right', '', 16 ); ?></span><?php esc_html_e( 'Logout', 'nevo' ) ?></a>
				<?php
			}
		} else { ?>
			<div id="login-form" class="login-form">
				<form name="loginform" id="loginform" action="<?php echo esc_url( home_url( 'wp-login.php', 'login_post' ) ) ?>" method="post">
					<p id="log-username">
						<input class="form-control" type="text" name="log" id="log" title="<?php esc_attr_e( 'Username', 'nevo' ) ?>" value="<?php esc_attr_e( 'Username', 'nevo' ) ?>" onfocus="if (this.value == '<?php esc_attr_e( 'Username', 'nevo' ) ?>') {this.value = '';}" onblur="if (this.value == '') {this.value = '<?php esc_attr_e( 'Username', 'nevo' ) ?>';}"  size="33" />
					</p>
					<p id="log-pass">
						<input class="form-control" type="password" name="pwd" id="pwd" title="<?php esc_attr_e( 'Password', 'nevo' ) ?>" value="<?php esc_attr_e( 'Password', 'nevo' ) ?>" onfocus="if (this.value == '<?php esc_attr_e( 'Password', 'nevo' ) ?>') {this.value = '';}" onblur="if (this.value == '') {this.value = '<?php esc_attr_e( 'Password', 'nevo' ) ?>';}" size="33" />
					</p>
					<input class="btn btn-primary cv-col-12 cv-mb-3" type="submit" name="submit" value="<?php esc_attr_e( 'Log in', 'nevo' ) ?>" />
					<label class="d-lock" for="rememberme"><input name="rememberme" id="rememberme" type="checkbox" checked="checked" value="forever" /> <?php esc_attr_e( 'Remember Me', 'nevo' ) ?></label>
					<input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>"/>
				</form>
				<ul class="login-links list-inline">
					<?php echo wp_register() ?>
					<li><a href="<?php echo wp_lostpassword_url($redirect) ?>"><?php esc_html_e( 'Lost your password ?', 'nevo' ) ?></a></li>
				</ul>
			</div><?php
		}
	}
}

if ( ! function_exists( 'nevo_woo_account' ) ) {
	function nevo_woo_account() {
		if ( ! Nevo()->is_woocommerce_active() ) {
			return;
		}
		ob_start();

		$icons = array(
			'dashboard' => 'bi-inbox',
			'orders' => 'bi-bag',
			'downloads' => 'bi-cloud-download',
			'edit-address' => 'bi-geo-alt',
			'edit-account' => 'bi-person',
			'customer-logout' => 'bi-arrow-return-right',
			'my-licenses' => 'bi-key',
		);
		$default_icon = 'bi-info';
		
		if ( is_user_logged_in() ) {
			foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
				<a class="d-flex align-items-center <?php echo esc_attr( $endpoint ); ?>" href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>">
				<?php $icon = isset( $icons[ $endpoint ] ) ? $icons[ $endpoint ] : $default_icon; ?>
				<span class="nevo-icon" aria-hidden="true"><?php echo nevo_get_svg_icon( 'ui', $icon, '', 16 ); ?></span>
				<span class="info-text"><?php echo esc_html( $label ); ?></span>
				</a><?php 
			endforeach;
		}
		$content = ob_get_clean();
		return $content;
	}
}