<?php
/**
 * Build the loop.
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Build the WordPress loop.
 *
 * @since 1.0.0
 */
function nevo_display_content() {
    if ( have_posts() ) {
        /**
		 * nevo_before_while hook.
		 *
		 * @since 1.0
		 */
    	do_action( 'nevo_before_while' );
		
		if ( nevo_blog_columns() ) {
			echo '<div class="blog-cols cv-row">';
		}
		
		while ( have_posts() ) : the_post();
			
			/**
			 * nevo_before_entry hook.
			 *
			 * @since 1.0
			 */
			do_action( 'nevo_before_entry' );
			
			/**
			 * nevo_content_entry hook.
			 *
			 * @since 1.0
			 *
			 * @hooked nevo_do_post_loop - 5
			 * @hooked nevo_do_content_loop - 10
			 */
			do_action( 'nevo_content_entry' );
			
			/**
			 * nevo_after_entry hook.
			 *
			 * @since 1.0
			 */
			do_action( 'nevo_after_entry' );
			
		endwhile;
		
		/**
		 * nevo_after_endwhile hook.
		 *
		 * @since 1.0
		 */	
		do_action( 'nevo_after_endwhile' );

        if ( nevo_blog_columns() ) {
            echo '</div>';
        }

    } elseif ( is_404() ) {
		/**
		 * nevo_404_entry_content hook.
		 *
		 * @since 1.0
		 */
        do_action( 'nevo_404_entry_content' );
    } else {
		/**
		 * nevo_no_entry_content hook.
		 *
		 * @since 1.0
		 */
        do_action( 'nevo_no_entry_content' );
    }
}

add_action( 'nevo_loop', 'nevo_display_content' );