<?php
/**
 * Posts with Featured Image widget.
 *
 * @package Nevo
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Posts with Featured Image widget.
 *
 * Class nevo_posts_list_featured_widget
 */
class nevo_posts_list_featured_widget extends Nevo_Widget {

	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'widget_posts_list_with_image';
		$this->widget_name        = esc_html__( '*Νevo* Posts with Featured Image', 'nevo' );
		$this->widget_description = esc_html__( 'Posts list with thumbnail images', 'nevo' );
		
		$this->settings           = array(
			'title'         => array(
				'type'    => 'text',
				'default' => '',
				'label'   => esc_html__( 'Title:', 'nevo' ),
			),
			'number'      => array(
				'type'    => 'number',
				'default' => 5,
				'label'   => esc_html__( 'Number Posts to show:', 'nevo' ),
			),
			'all_categories' => array(
				'type'    => 'checkbox',
				'default' => 0,
				'label'   => esc_html__( 'Query from All Categories?', 'nevo' ),
			),
			'category'    => array(
				'type'    => 'categories',
				'default' => '',
				'label'   => esc_html__( 'or Choose Specific Categories:', 'nevo' ),
			),
			'show_image'   => array(
				'type'    => 'checkbox',
				'col'     => 'col-1',
				'default' => 1,
				'label'   => esc_html__( 'Show Images:', 'nevo' ),
			),
			'show_date'   => array(
				'type'    => 'checkbox',
				'col'     => 'col-2',
				'default' => 1,
				'label'   => esc_html__( 'Show Date:', 'nevo' ),
			),
			'orderby'       => array(
				'type'    => 'select',
				'col'     => 'col-1',
				'default' => 'post_date',
				'label'   => esc_html__( 'Sort By:', 'nevo' ),
				'choices' => array(
					'post_date' => esc_html__( 'Recent Published', 'nevo' ),
					'rand'      => esc_html__( 'Random', 'nevo' ),
				),
			),
			'image_position' => array(
				'type'    => 'select',
				'col'     => 'col-2',
				'default' => 'alignleft',
				'label'   => esc_html__( 'Images Position', 'nevo' ),
				'choices' => array(
					'alignleft'   => __( 'Left', 'nevo' ),
					'aligncenter' => __( 'Center', 'nevo' ),
					'alignright'  => __( 'Right', 'nevo' ),
				),
			),
		);

		parent::__construct();

	}

	/**
	 * Output widget.
	 *
	 * @param array $args     Arguments.
	 * @param array $instance Widget instance.
	 *
	 * @see WP_Widget
	 */
	public function widget( $args, $instance ) {
		global $post;
		$cats = get_categories();
		$category_default = array();
		foreach ( $cats as $cat ) $category_default[] = $cat->term_id;
		$title    		= apply_filters( 'widget_title', isset( $instance['title'] ) ? $instance['title'] : '' );
		$number   		= empty( $instance['number'] ) ? 5 : $instance['number'];
		$all_categories = isset( $instance['all_categories'] ) ? (bool) $instance['all_categories'] : false;
		$category       = isset( $instance['category'] ) ? $instance['category'] : $category_default;
		$show_image   	= isset( $instance['show_image'] ) ? $instance['show_image'] : 1;
		$show_date   	= isset( $instance['show_date'] ) ? $instance['show_date'] : 1;
		$orderby   		= isset( $instance['orderby'] ) ? $instance['orderby'] : 'post_date';
		$image_position = isset( $instance['image_position'] ) ? $instance['image_position'] : 'alignleft';

		$this->widget_start( $args );
		
		if ( $image_position === 'alignleft' ) {
			$image_position = 'cv-me-3 '. $image_position;
		}
		elseif ( $image_position === 'alignright' ) {
			$image_position = 'cv-ms-3 '. $image_position;
		} else {
			$image_position = 'cv-mb-3 '. $image_position;
		}
		
		// Displays the widget title.
		if ( ! empty( $title ) ) {
			echo ! empty( $title ) ? $args['before_title'] . $title . $args['after_title'] : '';
		}
		
		$query_args = array(
			'post_type'           => 'post',
			'posts_per_page'      => $number,
			'ignore_sticky_posts' => 1,
			'orderby'             => $orderby,
			'post_status'         => 'publish',
		);
		if ( ! $all_categories ) $query_args['cat'] = implode( ',', $category );

		$query = new WP_Query( $query_args );
		$postcounter = 1;
		ob_start();
		
		echo '<div class="post-list-wrap">';
			while ( $query->have_posts() ) :
				$query->the_post();
				?>
				<article id="post-<?php echo $post->ID; ?>" class="d-inline-block cv-col-12<?php echo esc_attr( $number == $postcounter ? '' : ' cv-mb-3 cv-pb-3' ); ?>">
					<?php
					if ( has_post_thumbnail( $post->ID ) && $show_image ) {
						$attrs = array(
							'alt' => $title,
							'itemprop' => 'image',
							'class' => 'size-full cv-col-12',
							'style' => 'aspect-ratio:4/3;'
						);
						?>
						<div class="size-full position-relative cv-w-120 <?php echo esc_attr( $image_position ); ?>">
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark">
								<?php echo get_the_post_thumbnail( $post->ID, 'thumbnail', $attrs ); ?>
							</a>
						</div>
						<?php
					}?>
					<header class="entry_header <?php echo esc_attr( $show_image ? 'small-left' : '' ); ?>">
						<h3 class="entry-title cv-fs-6 cv-mb-1">
							<a class="title-small" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a>
						</h3>
						<?php if ( $show_date ) : ?>
							<div class="entry-meta"><?php echo nevo_do_post_meta_item( 'date' ); ?></div>
						<?php endif; ?>
					</header>
				</article>
			<?php $postcounter ++;
			endwhile;
			
			// Reset Post Data.
			wp_reset_postdata();
		ob_end_flush();
		echo '</div>';
		
		$this->widget_end( $args );
	}

}