<?php
/**
 * Nevo WooCommerce hooks
 *
 * @package nevo
 */

/**
 * Homepage
 *
 * @see  nevo_product_categories()
 * @see  nevo_recent_products()
 * @see  nevo_featured_products()
 * @see  nevo_popular_products()
 * @see  nevo_on_sale_products()
 * @see  nevo_best_selling_products()
 */
add_action( 'homepage', 'nevo_product_categories', 20 );
add_action( 'homepage', 'nevo_recent_products', 30 );
add_action( 'homepage', 'nevo_featured_products', 40 );
add_action( 'homepage', 'nevo_popular_products', 50 );
add_action( 'homepage', 'nevo_on_sale_products', 60 );
add_action( 'homepage', 'nevo_best_selling_products', 70 );

// plugins\woocommerce\includes\class-wc-post-types.php 319
add_filter('woocommerce_register_post_type_product', 'remove_shop_default_description');
function remove_shop_default_description($args){
	$args['description'] = '';
	return $args;
}

add_filter( 'loop_shop_columns', 'nevo_products_per_row' );
if ( ! function_exists( 'nevo_products_per_row' ) ) {
	/**
	 * Products per row
	 */
	function nevo_products_per_row() {
		
		return intval( Nevo()->get_setting( 'product_archive_product_col', 'desktop' ) );
	}
}

add_filter( 'loop_shop_per_page', 'nevo_products_per_page' );
if ( ! function_exists( 'nevo_products_per_page' ) ) {
	/**
	 * Products per page
	 */
	function nevo_products_per_page() {

		return intval( Nevo()->get_setting( 'product_archive_product_number' ) );
	}
}

// Add script that allows adding custom quantity on Add to cart button click for archive pages.
add_action( 'template_redirect', 'quick_custom_add_to_cart_quantity_handler');
//add_action('wp_footer', 'quick_custom_add_to_cart_quantity_handler');
//add_action('init', 'quick_custom_add_to_cart_quantity_handler');
function quick_custom_add_to_cart_quantity_handler() {
    wc_enqueue_js('
		jQuery( "body" ).on( "click", ".quantity input", function() {
			return false;
		});
		jQuery( "body" ).on( "change input", ".quantity .qty", function() {
			var add_to_cart_button = jQuery( this ).parents( ".product" ).find( ".add_to_cart_button" );
			add_to_cart_button.attr( "data-quantity", jQuery( this ).val() );
			add_to_cart_button.attr( "href", "?add-to-cart=" + add_to_cart_button.attr( "data-product_id" ) + "&quantity=" + jQuery( this ).val() );
		});
	');
	if ( is_cart() || ( is_cart() && is_checkout() ) ) {
		wc_enqueue_js( '
			var timeout;

			jQuery("div.woocommerce").on("change keyup mouseup", "input.qty, select.qty", function(){ // keyup and mouseup for Firefox support
				if (timeout != undefined) clearTimeout(timeout); //cancel previously scheduled event
				if (jQuery(this).val() == "") return; //qty empty, instead of removing item from cart, do nothing
				timeout = setTimeout(function() {
					jQuery("[name=\"update_cart\"]").trigger("click");
				}, 1000 ); // schedule update cart event with delay in miliseconds specified in plugin settings
			});
			
		' );
	}
}

//add_filter('woocommerce_locate_template', 'nevo_override_default_template', 9999, 3);
function nevo_override_default_template( $template, $template_name, $template_path ) {		
	if ($template_name == 'global/quantity-input.php') {
		$path = get_template_directory() . '/template-parts/' . $template_name;		
		$template = apply_filters( 'nevo_quantity_template_path', $path );		
	}		
	return $template;
}

// Add shop messages
add_action( 'nevo_before_while', 'nevo_shop_messages', 30 );

// SHOP ARCHIVE ------------------------------------------------------------ //
// Sorting Wrapper
add_action( 'woocommerce_before_shop_loop', 'nevo_sorting_wrapper', 15 );
add_action( 'woocommerce_before_shop_loop', 'nevo_sorting_wrapper_close', 31 );
// Change Loop Start
add_filter( 'woocommerce_product_loop_start', 'nevo_woocommerce_loop_start' );
// Category
add_action( 'woocommerce_before_subcategory', 'nevo_template_loop_product_inner_open', 5 ); // Open inner column
remove_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10 ); // Remove category title
add_action( 'woocommerce_shop_loop_subcategory_title', 'nevo_template_loop_category_title_override', 10 ); // Add category title
add_action( 'woocommerce_after_subcategory', 'nevo_template_loop_product_inner_close', 100 ); // Close inner column
// Products
add_action( 'woocommerce_before_shop_loop_item', 'nevo_template_loop_product_inner_open', 5 ); // Open inner column
			
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );

// Wrap badge SALE Flash
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_template_loop_product_badge_wrap_open', 5 ); // Badge Wrap Open
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_change_sale_flash', 10 );
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_print_featured_label', 12 );
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_template_loop_product_badge_wrap_close', 15 ); // Badge Wrap Close

// Wrap Image OPEN
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_template_loop_product_image_wrapper_open', 20 ); // Image Wrap Open
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 25 );
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_template_loop_product_thumbnail_hover', 30 );
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_template_loop_product_thumbnail', 35 );
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 40 );
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_product_image_tool_wrapper_open', 45 ); // Tool Open
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_product_image_tool_wrapper_close', 85 ); // Tool Close
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_print_out_of_stock_label', 90 ); // Out of stock
add_action( 'woocommerce_before_shop_loop_item_title', 'nevo_template_loop_product_image_wrapper_close', 100 ); // Image Wrap Close

// Wrap product Content
add_action( 'woocommerce_shop_loop_item_title', 'nevo_template_loop_product_content_wrap_open', 5 ); // Content Wrap Open
add_action( 'woocommerce_shop_loop_item_title','nevo_template_loop_product_item', 20 );
add_action( 'woocommerce_shop_loop_item_title', 'nevo_template_loop_product_content_wrap_close', 30 ); // Content Wrap Close
add_action( 'woocommerce_after_shop_loop_item', 'nevo_template_loop_add_to_cart', 10 );

add_action( 'woocommerce_after_shop_loop_item', 'nevo_template_loop_product_inner_close', 100 ); // Close inner column
	
// SINGLE PRODUCT ------------------------------------------------------------ //
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );

// Wrap Single Products main
add_action( 'woocommerce_before_single_product_summary', 'nevo_template_loop_single_product_entry_wrap_open', 2 );
add_action( 'woocommerce_before_single_product_summary', 'nevo_template_loop_single_product_images_wrap_open', 5 ); // Image Wrap Open
// Wrap badge SALE Flash
add_action( 'woocommerce_before_single_product_summary', 'nevo_template_loop_product_badge_wrap_open', 6 );
add_action( 'woocommerce_before_single_product_summary', 'nevo_change_sale_flash', 10 );
add_action( 'woocommerce_before_single_product_summary', 'nevo_print_featured_label', 12 );
add_action( 'woocommerce_before_single_product_summary', 'nevo_template_loop_product_badge_wrap_close', 15 );

add_action( 'woocommerce_before_single_product_summary', 'nevo_template_loop_single_product_images_wrap_close', 30 ); // Image Wrap Close
add_action( 'woocommerce_after_single_product_summary', 'nevo_output_product_data_tabs', 10 );
add_action( 'woocommerce_after_single_product_summary', 'nevo_template_loop_single_product_entry_wrap_close', 2 );

// Wrap Single Products footer
add_action( 'woocommerce_after_single_product_summary', 'nevo_template_loop_single_product_footer_wrap_open', 5 );
add_action( 'woocommerce_after_single_product_summary', 'nevo_template_loop_single_product_footer_wrap_close', 100 );

/////////////
//add_action( 'woocommerce_single_product_summary', 'nevo_edit_post_link', 60 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
add_action( 'woocommerce_after_single_product_summary', 'nevo_upsell_display', 15 );

add_action( 'woocommerce_after_single_product_summary', 'nevo_single_product_pagination', 30 );
//add_action( 'nevo_after_footer', 'nevo_sticky_single_add_to_cart', 999 );

// WC Cart Cross Sell.
add_filter( 'woocommerce_cross_sells_columns', 'nevo_cross_sell_display_columns' );

// CheckOut Page
remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form' );
add_action( 'woocommerce_before_checkout_form', 'nevo_checkout_coupon_form', 10 );

// MY ACCOUNT PAGE.
add_filter( 'woocommerce_my_account_edit_address_title', '__return_empty_string' );
remove_action( 'woocommerce_account_navigation', 'woocommerce_account_navigation' );
add_action( 'woocommerce_account_navigation', 'nevo_override_woocommerce_account_navigation' );
			
// GLOBAL PRODUCT
add_action( 'woocommerce_before_quantity_input_field', 'nevo_before_quantity_input_field' );
add_action( 'woocommerce_after_quantity_input_field', 'nevo_after_quantity_input_field' );

/**
 * Cart fragment
 *
 * @see nevo_cart_link_fragment()
 */
add_filter( 'woocommerce_add_to_cart_fragments', 'nevo_cart_link_fragment' );

/**
 * Integrations
 *
 * @see nevo_woocommerce_brands_archive()
 * @see nevo_woocommerce_brands_single()
 * @see nevo_woocommerce_brands_homepage_section()
 */
if ( class_exists( 'WC_Brands' ) ) {
	add_action( 'woocommerce_archive_description', 'nevo_woocommerce_brands_archive', 5 );
	add_action( 'woocommerce_single_product_summary', 'nevo_woocommerce_brands_single', 4 );
}
