<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
$sidebar = apply_filters( 'nevo_default_sidebar_right', 'sidebar-1' );
?>
<div <?php nevo_do_attr( 'right_sidebar' ); ?>>
	<div class="inside-right-sidebar inside-sidebar">
		<?php
		/**
		 * nevo_before_right_sidebar_content hook.
		 *
		 * @since 0.1
		 */
		do_action( 'nevo_before_right_sidebar_content' );

		if ( ! dynamic_sidebar( $sidebar ) ) {
			nevo_default_sidebar_widgets( 'right-sidebar' );
		}

		/**
		 * nevo_after_right_sidebar_content hook.
		 *
		 * @since 0.1
		 */
		do_action( 'nevo_after_right_sidebar_content' );
		?>
	</div>
</div>
