<?php
/**
 * Template part for displaying Author box
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( is_attachment() ){
	return;
}
global $post;
	
// Detect if it is a single post with a post author.
if ( is_single() && isset( $post->post_author ) ) {
	
	$user = get_user_by( 'ID', $post->post_author );
	if ( ! $user ) {
		return;
	}

	$display_name = $user->display_name ? $user->display_name : $user->user_login;
	// Get author's biographical information or description.
	$user_description = get_the_author_meta( 'user_description', $user->ID );
	// Get author's meta URL.
	$socials = apply_filters( 'nevo_modify_user_social',
		array(
			'url' => 'Website',
			'facebook' => 'Facebook',
			'twitter' => 'Twitter',
			'instagram' => 'Instagram',
			'pinterest' => 'Pinterest',
		)
	);

	// Get link to the author archive page.
	$user_posts = get_author_posts_url( get_the_author_meta( 'ID', $user->ID ) );

	if ( ! empty( $display_name ) ) {
		$author_name = '<h3 class="author-heading text-capitalize"><a href="' . $user_posts . '" title="Author '. $display_name .'" rel="author">' . sprintf( '%s', $display_name ) . '</a></h3>';
	}

	$user_description = wptexturize( $user_description );
	$user_description = wpautop( $user_description );
	$user_description = convert_smilies( $user_description );
	
	$user_avatar = get_avatar_url( $user->ID );
	$avatar_size = apply_filters( 'nevo_author_avatar_size', 80 );
	$author_socials = '';
	
	if ( $socials ) {
		$author_socials = '<div class="author-social">';
	}
	foreach ( $socials as $item => $v ) {
		$icons = $item;
		$social = get_the_author_meta( $item, $user->ID );
		if ( $social ) {
			if ( 'url' === $item ) {
				$icons = 'globe';
			}
			$author_socials .= '<a class="social-icons" href="' . get_the_author_meta( $item, $user->ID ) . '" target="_blank" rel="nofollow">'. nevo_get_svg_icon( 'ui', 'bi-'. $icons .'', '', 16 ) .'</a>';
		}
	}
	if ( $socials ) {
		$author_socials .= '</div>';
	}
	
	$author_avatar = '<div class="author-avatar alignleft"><img class="user-avatar avatar-'. $avatar_size .'" height="'. $avatar_size .'" width="'. $avatar_size .'" src="' . $user_avatar . '" alt="" loading="lazy"></div>';
	
	$author_details = '<div class="author-content">'. $author_name .'<div class="author-desc">' . $user_description . '</div>'. $author_socials .'</div>';

	// Pass all this info to post content.
	$content = '<div class="post-author nevo-author-info" >'. $author_avatar . $author_details . '</div>';
}

echo $content;