<?php
/**
 * Template part for displaying Post Content
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$current_post = $wp_query->current_post + 1;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('cv-col-12'); ?> <?php nevo_do_microdata( 'article' ); ?>>
	<div class="inside-article">
		<?php
		/**
		 * nevo_before_content hook.
		 *
		 * @since 1.0
		 */
		do_action( 'nevo_before_content' );
		
		/**
		 * nevo_before_entry_header hook.
		 *
		 * @since 1.0
		 */
		do_action( 'nevo_before_entry_header' );

		?>
		<header <?php nevo_do_attr( 'entry_header' ); ?>>
			<?php
			/**
			 * nevo_before_entry_title hook.
			 *
			 * @since 1.0
			 */
			do_action( 'nevo_before_entry_title' );

			$params = nevo_get_the_title_parameters(' cv-fs-5 cv-fs-sm-4 post-title');
			the_title( $params['before'], $params['after'] );
			
			/**
			 * nevo_after_entry_title hook.
			 *
			 * @since 1.0
			 *
			 * @hooked nevo_post_meta - 10
			 */
			do_action( 'nevo_after_entry_title' );
			?>
		</header>
		<?php
		
		/**
		 * nevo_after_entry_header hook.
		 *
		 * @since 1.0
		 */
		do_action( 'nevo_after_entry_header' );
		
		$size = nevo_get_post_setting('thumbnail_size') === 'default' ? 'medium' : nevo_get_post_setting('thumbnail_size');
		nevo_post_image($size, 'alignleft cv-col-12 cv-col-sm-4 cv-mt-sm-3 cv-me-0 cv-me-sm-4', 'size-full cv-col-12', 'aspect-ratio:16/9;', true);
		
		/**
		 * nevo_before_entry_content hook.
		 *
		 * @since 1.0
		 */
		do_action( 'nevo_before_entry_content' );
		
		$type = Nevo()->get_setting( 'post_archive_excerpt_type' );
		$excerpt_length = Nevo()->get_setting( 'post_archive_excerpt_length' );
		
		nevo_get_entry_content(20, $type, $excerpt_length, ' cv-mt-sm-3');
		
		/**
		 * nevo_after_entry_content hook.
		 *
		 * @since 1.0
		 *
		 * @hooked nevo_footer_meta - 10
		 */
		do_action( 'nevo_after_entry_content' );

		/**
		 * nevo_after_content hook.
		 *
		 * @since 1.0
		 */
		do_action( 'nevo_after_content' );
		?>
	</div>
</article>
<?php
/**
 * nevo_after_article hook.
 *
 * @since 1.0
 */
do_action( 'nevo_after_article', $current_post );