<?php
/**
 * Add Header Builder Template
 *
 * @package Business_Aarambha
 */

/*----------------------------------------------------------------------
# Exit if accessed directly
-------------------------------------------------------------------------*/
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

?>

<script type="text/html" id="tmpl-nevo-builder-panel">
    <div class="nevo-customize-builder" data-builder="{{ data.builder }}">
        <div class="nevo-inner">
            <div class="nevo-header">
                <div class="nevo-devices-switcher">
                </div>
                <div class="nevo-actions">
                    <a class="button button-secondary nevo-panel-close" href="#">
                        <span class="close-text"><?php esc_html_e( 'Close', 'nevo' ); ?></span>
                        <span class="panel-name-text">{{ data.title }}</span>
                    </a>
                </div>
            </div>
            <div class="nevo-body" data-sidebar="{{ data.sidebar }}"></div>
        </div>
    </div>
</script>

<script type="text/html" id="tmpl-nevo-panel">
    <div class="nevo-rows">

        <# if ( data.device != 'all' ) { #>
            <# if ( ! _.isUndefined( data.rows.top ) ) { #>
            <div class="nevo-row-top nevo-row" data-row-id ="top" data-cols="{{ data.cols.top }}" data-id="{{ data.id }}_top">
                <a class="nevo-row-settings" title="{{ data.rows.top }}" data-id="top" href="#">{{ data.rows.top }}</a>
				<div class="nevo-row-inner">
                    <# for ( let i = 0; i < data.cols.top; i++ ) { #>
                    <div class="col-items-wrapper"><div data-id="nc-col-{{ i }}" class="col-items nc-col-{{ i }}"></div></div>
                    <# } #>
                </div>
            </div>
            <#  } #>

            <# if ( ! _.isUndefined( data.rows.main ) ) { #>
            <div class="nevo-row-main nevo-row" data-row-id ="main" data-cols="{{ data.cols.main }}" data-id="{{ data.id }}_main">
                <a class="nevo-row-settings" title="{{ data.rows.main }}" data-id="main" href="#">{{ data.rows.main }}</a>
                <div class="nevo-row-inner">
                    <# for ( let i = 0; i < data.cols.main; i++ ) { #>
                    <div class="col-items-wrapper"><div data-id="nc-col-{{ i }}" class="col-items nc-col-{{ i }}"></div></div>
                    <# } #>
                </div>
            </div>
            <#  } #>

            <# if ( ! _.isUndefined( data.rows.bottom ) ) { #>
            <div class="nevo-row-bottom nevo-row" data-row-id ="bottom" data-cols="{{ data.cols.bottom }}" data-id="{{ data.id }}_bottom">
                <a class="nevo-row-settings" title="{{ data.rows.bottom }}" data-id="bottom" href="#">{{ data.rows.bottom }}</a>
                <div class="nevo-row-inner">
                    <# for ( let i = 0; i < data.cols.bottom; i++ ) { #>
                    <div class="col-items-wrapper"><div data-id="nc-col-{{ i }}" class="col-items nc-col-{{ i }}"></div></div>
                    <# } #>
                </div>
            </div>
            <#  } #>
        <# } #>
    </div>
	
	<# if ( data.device != 'desktop' ) { #>
		<# if ( ! _.isUndefined( data.rows.sidebar ) ) { #>
		<div class="nevo-row-sidebar nevo-row" data-row-id ="sidebar" data-cols="{{ data.cols.sidebar }}" data-id="{{ data.id }}_sidebar">
			<a class="nevo-row-settings" title="{{ data.rows.sidebar }}" data-id="sidebar" href="#">{{ data.rows.sidebar }}</a>
			<div class="nevo-row-inner">
				<# for ( let i = 0; i < data.cols.sidebar; i++ ) { #>
				<div class="col-items-wrapper"><div data-id="nc-col-{{ i }}" class="col-items nc-col-{{ i }}"></div></div>
				<# } #>
			</div>
		</div>
		<#  } #>
	<# } #>
</script>

<script type="text/html" id="tmpl-nevo-item">
    <div class="grid-stack-item item-from-list for-s-{{ data.section }}"
         title="{{ data.name }}"
         data-id="{{ data.id }}"
         data-section="{{ data.section }}"
    >
        <div class="item-tooltip" data-section="{{ data.section }}">{{ data.name }}</div>
        <div class="grid-stack-item-content">
            <span class="nevo-item-name" data-section="{{ data.section }}">{{ data.name }}</span>
            <span class="nevo-item-remove nevo-icon"></span>
            <span class="nevo-item-setting nevo-icon" data-section="{{ data.section }}"></span>
        </div>
    </div>
</script>
