<?php
/**
 * Template part for displaying Copyright
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class="footer-copyright builder-item-focus" data-section="footer_copyright">
	<?php
	$theme = wp_get_theme();
	$tags = array(
		'current_year' 		=> date_i18n( 'Y' ),
		'site_title'   		=> get_bloginfo( 'name' ),
		'theme_author' 		=> sprintf( '<a href="'. esc_url( $theme->get( 'AuthorURI' ) ) .'" target="_blank" rel="nofollow noopener">%1$s</a>', esc_html( $theme->get( 'Author' ) ) ),
	);

	$content = Nevo()->get_setting( 'footer_copyright_text' );

	foreach ( $tags as $k => $v ) {
		$content = str_replace( '{' . $k . '}', $v, $content );
	}

	echo '<span class="copyright">'. $content .'</span>';
	if ( is_customize_preview() ) {
		echo '<span class="customize-partial-edit">'. esc_html__( 'Copyright', 'nevo' ) .'</span>';
	}
	?>
</div>