<?php
/**
 * Template part for displaying Footer Menu.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<nav <?php nevo_do_attr( 'footer_navigation' ); ?>>
	<?php
	wp_nav_menu( array(
		'theme_location'  => 'footer',
		'container'       => false,
		'container_class' => false,
		'container_id'    => false,
		'menu_class'      => 'nevo-nav-menu menu-footer',
		'depth'           => 1,
		'fallback_cb' 	  => 'nevo_unassigned_menu',
	) );
	if ( is_customize_preview() ) {
		echo '<span class="customize-partial-edit">'. esc_html__( 'Footer Menu', 'nevo' ) .'</span>';
	}
	?>
</nav>	