<?php
/**
 * Template part for displaying Account
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$text = Nevo()->get_setting( 'header_account_label' );

$user = wp_get_current_user();
if ( is_user_logged_in() && $user ) {
	$avatar = get_avatar_url( $user->ID );
	
	if ( ! $text ) {
		$text = $user->display_name;
	} else {
		$text = $user->user_login;
	}
} else {
	$avatar = get_template_directory_uri() . '/assets/images/avatar.jpg';
	$text 	= esc_html__( 'Login', 'nevo' );
}
$position     = Nevo()->get_setting( 'header_account_position' );
?>
<div class="header-account builder-item-focus" data-section="header_account">
	<button class="account-toggle nevo-popup-toggle d-flex align-items-center" type="button" data-target="header-account-vertical">
		<?php if ( intval( Nevo()->get_setting( 'header_account_show_avata' ) ) ) : ?>
			<img class="user-avatar" height="25" width="25" src="<?php echo esc_url( $avatar ); ?>" alt="">
		<?php endif; ?>
		<?php if ( intval( Nevo()->get_setting( 'header_account_show_label' ) ) ) : ?>
			<span class="user-name"><?php echo $text; // WPCS: XSS ok. ?></span>
		<?php endif; ?>
		<span class="screen-reader-text"><?php esc_html_e( 'Account', 'nevo' ); ?></span>
	</button>
	<div id="header-account-vertical" class="nevo-popup header-account-vertical <?php echo esc_attr( $position ); ?>">
		<div class="popup-background popup-close"></div>
		<?php nevo_account_sidebar_content(); ?>
	</div>
	<?php
	if ( is_customize_preview() ) {
		echo '<span class="customize-partial-edit">'. esc_html__( 'Account', 'nevo' ) .'</span>';
	} ?>
</div>