<?php
/**
 * Template part for displaying Button
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$text          = Nevo()->get_setting( 'header_button_text' );
$icon          = Nevo()->get_setting( 'header_button_icon' );
$size          = Nevo()->get_setting( 'header_button_size' );
$new_window    = Nevo()->get_setting( 'header_button_target' );
$link          = Nevo()->get_setting( 'header_button_link' );
$link_rel      = Nevo()->get_setting( 'header_button_link_rel' );
$icon_position = Nevo()->get_setting( 'header_button_position' );
$classes       = array( 'button', 'button-link', 'd-flex', 'align-items-center', 'justify-content-center' );

$rel = '';
if ( $link_rel ) {
	$rel = ' rel="'. $link_rel .'" ';
}

$icon = wp_parse_args(
	$icon,
	array(
		'type' => '',
		'icon' => '',
	)
);

$size = wp_parse_args(
	$size,
	array(
		'unit' => '',
		'value' => '20',
	)
);

$target = '';
if ( 1 == $new_window ) {
	$target = ' target="_blank" ';
}

$icon_html = '';
if ( $icon['icon'] ) {
	$icon_html = '<span class="button-icon ' . esc_attr( $icon['icon'] ) . ' d-inline-flex align-self-center">'. nevo_get_svg_icon( 'ui', '' . esc_attr( $icon['icon'] ) . '', 'cv', esc_attr( $size['value'] ) ) .'</span>';
}

if ( ! $text ) {
	$text = __( 'Button', 'nevo' );
}

if ( $text ) {
	$text = '<span class="button-label">'. esc_html( $text ) .'</span>';
}

echo '<div class="header-button builder-item-focus" data-section="header_button"><a href="' . esc_url( $link ) . '" ' . $target . ' class="' . esc_attr( join( ' ', $classes ) ) . '"'. $rel .'>';
if ( 'before' === $icon_position ) {
	echo $icon_html . $text;
} else {
	echo $text . $icon_html;
}
echo '</a>';
if ( is_customize_preview() ) {
	echo '<span class="customize-partial-edit">'. esc_html__( 'Button', 'nevo' ) .'</span>';
}
echo '</div>';