<?php
/**
 * Template part for displaying Toggle Menu
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$size     	= Nevo()->get_setting( 'toggle_menu_size' );
$label 		= Nevo()->get_setting( 'toggle_menu_label' );

$size = wp_parse_args(
	$size,
	array(
		'unit' => '',
		'value' => '20',
	)
);
?>
<div class="header-menu-toggle builder-item-focus" data-section="mobile_menu">
	<button <?php nevo_do_attr( 'menu_toggle' ); ?>>
		<span class="toggle-icon d-inline-flex align-self-center"><?php echo nevo_get_svg_icon( 'ui', 'menu', 'menu-icon', esc_attr( $size['value'] ) ); ?></span>
		<span class="screen-reader-text"><?php esc_html_e( 'Menu', 'nevo' ); ?></span>
		<?php
		if( $label ){
			echo '<span class="toggle-label">'. esc_attr( $label ) .'</span>';
		} ?>
	</button>
	<?php
	if ( is_customize_preview() ) {
		echo '<span class="customize-partial-edit">'. esc_html__( 'Toggle Menu', 'nevo' ) .'</span>';
	} ?>
</div>