jQuery( document ).ready( function( $ ) {
	var container_width_elements = 'body .wp-block,\
									html body.block-editor-page .editor-post-title__block,\
	 								html body.block-editor-page .editor-default-block-appender,\
									html body.block-editor-page .editor-block-list__block,\
									html body.block-editor-page .block-editor-block-list__block,\
									.edit-post-visual-editor .editor-block-list__block[data-align=wide]';

	$( 'input[name="nevo_page_settings[content_container]"]' ).on( 'change', function() {
		if ( 'true' === this.value ) {
			$( 'style#container_width' ).remove();
			$( 'head' ).append( '<style id="container_width">' + container_width_elements + '{max-width: 100%;}</style>' );
		} else {
			$( 'style#container_width' ).remove();
		}
	} );

	$( '[name="nevo_page_settings[sidebar_layout]"]' ).on( 'change', function() {
		if ( 'true' !== $( this ).val() ) {
			var this_value = this.value,
				content_width = '',
				calc = '',
				narrow_width = nevo_block_editor.narrow_width,
				container_width = nevo_block_editor.container_width,
				right_sidebar_width = nevo_block_editor.right_sidebar_width,
				left_sidebar_width = nevo_block_editor.left_sidebar_width,
				right_content_padding = nevo_block_editor.content_padding_right,
				left_content_padding = nevo_block_editor.content_padding_left;

			if ( '' === this_value ) {
				this_value = nevo_block_editor.global_sidebar_layout;
			}

			if ( 'content-narrow' == this_value ) {
				content_width = narrow_width;
			} else if ( 'left-sidebar' == this_value ) {
				content_width = container_width * ( ( 100 - left_sidebar_width ) / 100 );
			} else if ( 'right-sidebar' == this_value ) {
				content_width = container_width * ( ( 100 - right_sidebar_width ) / 100 );
			} else if ( 'no-sidebar' == this_value ) {
				content_width = container_width;
			} else {
				content_width = container_width * ( ( 100 - ( Number( left_sidebar_width ) + Number( right_sidebar_width ) ) ) / 100 );
			}

			calc = 'max-width: calc(' + content_width + 'px - ' + right_content_padding + ' - ' + left_content_padding + ')';

			$( 'style#content-width' ).remove();
			$( 'head' ).append( '<style id="content-width">' + container_width_elements + '{' + calc + '}</style>' );

			$( 'style#wide-width' ).remove();
			$( 'head' ).append( '<style id="wide-width">.edit-post-visual-editor .editor-block-list__block[data-align=wide]{max-width:' + content_width + 'px}' );
		}
	} );
} );