<?php
/**
 * The template for displaying the header.
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> <?php nevo_do_microdata( 'body' ); ?>>
	<?php
	/**
	 * wp_body_open hook.
	 *
	 * @since 0.1
	 */
	do_action( 'wp_body_open' ); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- core WP hook.
	?>

	<div <?php nevo_do_attr( 'page' ); ?>>
		<?php
		/**
		 * nevo_before_header hook.
		 *
		 * @since 0.1
		 */
		do_action( 'nevo_before_header' );

		/**
		 * nevo_header hook.
		 *
		 * @since 1.0
		 *
		 * @hooked nevo_construct_header - 10
		 */
		do_action( 'nevo_header' );

		/**
		 * nevo_after_header hook.
		 *
		 * @since 0.1
		 *
		 * @hooked nevo_featured_page_header - 10
		 */
		do_action( 'nevo_after_header' );
	
		?>
		<div <?php nevo_do_attr( 'site_content' ); ?>>
			<?php
			/**
			 * nevo_inside_container hook.
			 *
			 * @since 0.1
			 */
			do_action( 'nevo_inside_container' );
