<?php

class Nevo_Customizer_Control_Repeater extends Nevo_Customizer_Control_Base {
	static function field_template() {
		?>
		<script type="text/html" id="tmpl-field-nevo-repeater">
			<?php
			self::before_field();
			?>
			<?php echo self::field_header(); ?>
			<div class="nevo-field-settings-inner">
			</div>
			<?php
			self::after_field();
			?>
		</script>
		<script type="text/html" id="tmpl-customize-control-repeater-item">
			<div class="nevo--repeater-item">
				<div class="nevo--repeater-item-heading">
					<label class="nevo--repeater-visible" title="<?php esc_attr_e( 'Toggle item visible', 'nevo' ); ?>">
						<input type="checkbox" class="r-visible-input">
						<span class="r-visible-icon"></span>
						<span class="screen-reader-text"><?php _e( 'Show', 'nevo' ); ?></label>
					<span class="nevo--repeater-live-title"></span>
					<div class="nevo-nav-reorder">
						<span class="nevo--down" tabindex="-1">
							<span class="screen-reader-text"><?php _e( 'Move Down', 'nevo' ); ?></span></span>
						<span class="nevo--up" tabindex="0">
							<span class="screen-reader-text"><?php _e( 'Move Up', 'nevo' ); ?></span>
						</span>
					</div>
					<a href="#" class="nevo--repeater-item-toggle">
						<span class="screen-reader-text"><?php _e( 'Close', 'nevo' ); ?></span></a>
				</div>
				<div class="nevo--repeater-item-settings">
					<div class="nevo--repeater-item-inside">
						<div class="nevo--repeater-item-inner"></div>
						<# if ( data.addable ){ #>
						<a href="#" class="nevo--remove"><?php _e( 'Remove', 'nevo' ); ?></a>
						<# } #>
					</div>
				</div>
			</div>
		</script>
		<script type="text/html" id="tmpl-customize-control-repeater-inner">
			<div class="nevo--repeater-inner">
				<div class="nevo--settings-fields nevo--repeater-items"></div>
				<div class="nevo--repeater-actions">
				<a href="#" class="nevo--repeater-reorder"
				data-text="<?php esc_attr_e( 'Reorder', 'nevo' ); ?>"
				data-done="<?php _e( 'Done', 'nevo' ); ?>"><?php _e( 'Reorder', 'nevo' ); ?></a>
					<# if ( data.addable ){ #>
					<button type="button"
							class="button nevo--repeater-add-new"><?php _e( 'Add an item', 'nevo' ); ?></button>
					<# } #>
				</div>
			</div>
		</script>
		<?php
	}
}
