<?php
class Nevo_Customizer_Control_Typography extends Nevo_Customizer_Control_Base {
	static function field_template() {
		echo '<script type="text/html" id="tmpl-field-nevo-typography">';
		self::before_field();
		?>
		<?php echo self::field_header(); ?>
		<div class="nevo-actions">
			<a href="#" class="action--reset" data-control="{{ field.name }}" title="<?php esc_attr_e( 'Reset to default', 'nevo' ); ?>"><span class="dashicons dashicons-image-rotate"></span></a>
			<a href="#" class="action--edit" data-control="{{ field.name }}" title="<?php esc_attr_e( 'Toggle edit panel', 'nevo' ); ?>"><span class="dashicons dashicons-edit"></span></a>
		</div>
		<div class="nevo-field-settings-inner">
			<input type="hidden" class="nevo-typography-input nevo-only" data-name="{{ field.name }}" value="{{ JSON.stringify( field.value ) }}" data-default="{{ JSON.stringify( field.default ) }}">
		</div>
		<?php
		self::after_field();
		echo '</script>';
		?>
		<div id="nevo-typography-panel" class="nevo-typography-panel">
			<div class="nevo-typography-panel--inner">
				<input type="hidden" id="nevo--font-type">
				<div id="nevo-typography-panel--fields"></div>
			</div>
		</div>
		<?php
	}
}
