<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_footer_button_config' ) ) {
	function nevo_customizer_footer_button_config($configs = array()) {
		$section  = 'footer_button';
		$name     = 'footer_button';
		$selector = '.footer-button';
		$config   = array(
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'nevo_footer',
				'priority' => 80,
				'title' => __( 'Button', 'nevo' ),
			),

			array(
				'name'            => $name . '_text',
				'type'            => 'text',
				'section'         => $section,
				'theme_supports'  => '',
				'selector'        => $selector,
				'render_callback' => 'nevo_refresh_footer_button_partials',
				'priority' 		  => 5,
				'title'           => __( 'Text', 'nevo' ),
				'default'         => __( 'Button', 'nevo' ),
			),

			array(
				'name'            => $name . '_icon',
				'type'            => 'icon',
				'section'         => $section,
				'selector'        => $selector,
				'render_callback' => 'nevo_refresh_footer_button_partials',
				'theme_supports'  => '',
				'priority' 		  => 10,
				'title'           => __( 'Icon', 'nevo' ),
			),
			
			array(
				'name'       	  => $name . '_size',
				'type'       	  => 'slider',
				'device_settings' => false,
				'section'    	  => $section,
				'min'             => 0,
				'step'            => 1,
				'max'             => 100,
				'default'         => 20,
				'priority' 		  => 15,
				'label'      	  => __( 'Icon size', 'nevo' ),
				'selector'   	  => $selector,
				'render_callback' => 'nevo_refresh_footer_button_partials',
			),

			array(
				'name'            => $name . '_position',
				'type'            => 'radio_group',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 20,
				'default'         => 'after',
				'render_callback' => 'nevo_refresh_footer_button_partials',
				'title'           => __( 'Icon Position', 'nevo' ),
				'choices'         => array(
					'before' => __( 'Before', 'nevo' ),
					'after'  => __( 'After', 'nevo' ),
				),
			),

			array(
				'name'            => $name . '_link',
				'type'            => 'text',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 25,
				'default'         => '#',
				'render_callback' => 'nevo_refresh_footer_button_partials',
				'title'           => __( 'Link', 'nevo' ),
			),

			array(
				'name'            => $name . '_link_rel',
				'type'            => 'text',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 26,
				'default'         => 'noopener noreferrer',
				'render_callback' => 'nevo_refresh_footer_button_partials',
				'title'           => __( 'Link Rel', 'nevo' ),
			),

			array(
				'name'            => $name . '_target',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 30,
				'render_callback' => 'nevo_refresh_footer_button_partials',
				'checkbox_label'  => __( 'Open link in a new tab.', 'nevo' ),
			),
			
			array(
				'name'    => "hr_1",
				'type'    => 'hr',
				'section' => $section,
				'priority' => 180,
			),

			array(
				'name'        => $name . '_typography',
				'type'        => 'typography',
				'section'     => $section,
				'priority' 	  => 190,
				'title'       => __( 'Typography', 'nevo' ),
				'description' => __( 'Advanced typography for button', 'nevo' ),
				'selector'    => "$selector a.button-link",
				'css_format'  => 'typography',
				'default'     => array(),
			),

			array(
				'name'        => $name . '_styling',
				'type'        => 'styling',
				'section'     => $section,
				'priority' 	  => 200,
				'title'       => __( 'Styling', 'nevo' ),
				'description' => __( 'Advanced styling for button', 'nevo' ),
				'selector'    => array(
					'normal' => '.footer-section .footer-button a.button-link',
					'normal_text_color' => '.footer-section .footer-button a.button-link',
					'hover'  => '.footer-section .footer-button a.button-link:hover',
					'hover_text_color' => '.footer-section .footer-button a.button-link:hover',
				),
				'css_format'  => 'styling',
				'default'   => array(
					'normal' => array(
						
					),
				),
				'fields'      => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'link_color'    => false,
						'margin'        => false,
						'paddinga'      => false,
						'bg_image'      => false,
						'bg_cover'      => false,
						'bg_position'   => false,
						'bg_repeat'     => false,
						'bg_attachment' => false,
					),
					'hover_fields'  => array(
						'link_color' => false,
					),
				),
			),

		);

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_footer_button_config', 99 );

function nevo_refresh_footer_button_partials(){
	nevo_footer_element( 'footer-button');
}