<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_footer_social_config' ) ) {
	function nevo_customizer_footer_social_config($configs = array()) {
		$section  = 'footer_social';
		$name     = 'footer_social';
		$selector = ".footer-social-icons";
		$config   = array(
			array(
				'name'     => $section,
				'type'     => 'section',
				'panel'    => 'nevo_footer',
				'priority' => 100,
				'title'    => __( 'Social Icons', 'nevo' ),
			),

			array(
				'name'             => $name . '_items',
				'type'             => 'repeater',
				'section'          => $section,
				'selector'         => $selector,
				'render_callback' => 'nevo_refresh_footer_social_partials',
				'title'            => __( 'Social Profiles', 'nevo' ),
				'live_title_field' => 'title',
				'default'          => array(
					array(
						'title' => 'Facebook',
						'url'   => '#',
						'type'  => 'icon',
						'icon'  => array(
							'type' => 'bootstrap-icons',
							'icon' => 'bi-facebook',
						),
						'size'  => array(
							'unit' => 'px',
							'value' => '16',
						),
					),
					array(
						'title' => 'Twitter',
						'url'   => '#',
						'type'  => 'icon',
						'icon'  => array(
							'type' => 'bootstrap-icons',
							'icon' => 'bi-twitter',
						),
						'size'  => array(
							'unit' => 'px',
							'value' => '16',
						),
					),
					array(
						'title' => 'Pinterest',
						'url'   => '#',
						'type'  => 'icon',
						'icon'  => array(
							'type' => 'bootstrap-icons',
							'icon' => 'bi-pinterest',
						),
						'size'  => array(
							'unit' => 'px',
							'value' => '16',
						),
					),
				),
				'fields'           => array(
					array(
						'name'  => 'title',
						'type'  => 'text',
						'label' => __( 'Title', 'nevo' ),
					),

					array(
						'name'  => 'url',
						'type'  => 'text',
						'label' => __( 'URL', 'nevo' ),
					),
					
					array(
						'name'     => 'type',
						'type'     => 'select',
						'label'    => __( 'Icon Type', 'nevo' ),
						'choices'  => array(
							'icon' => __( 'Icon', 'nevo' ),
							'image' => __( 'Image', 'nevo' ),
						),
					),
					
					array(
						'name'  => 'icon',
						'type'  => 'icon',
						'label' => __( 'Icon', 'nevo' ),
						'required' => array( 'type', '==', 'icon' ),
					),
					
					array(
						'name'       => 'image',
						'type'       => 'image',
						'label'      => __( 'Image', 'nevo' ),
						'required'   => array( 'type', '==', 'image' ),
					),
					
					array(
						'name'            => 'size',
						'type'            => 'slider',
						'device_settings' => false,
						'min'             => 1,
						'step'            => 1,
						'max'             => 200,
						'default'         => 16,
						'label'           => __( 'Size', 'nevo' ),
					),
					
				),
			),

			array(
				'name'            => $name . '_target',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => 'nevo_refresh_footer_social_partials',
				'checkbox_label'  => __( 'Open link in a new tab.', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_label',
				'type'            => 'checkbox',
				'default'         => array(
					'desktop' => 0,
					'tablet'  => 0,
					'mobile'  => 0,
				),
				'section'         => $section,
				'selector'        => $selector,
				'device_settings' => true,
				'render_callback' => 'nevo_refresh_footer_social_partials',
				'label'           => __( 'Show Icon Label?', 'nevo' ),
				'checkbox_label'  => __( 'Show Icon Label?', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_padding',
				'type'            => 'slider',
				'device_settings' => false,
				'section'         => $section,
				'min'             => 0,
				'step'            => 1,
				'max'             => 20,
				'default'         => 6,
				'selector'        => "$selector .social-icons",
				'css_format'      => 'padding: {{value}};',
				'label'           => __( 'Padding', 'nevo' ),
			),

			array(
				'name'            => $name . '_spacing',
				'type'            => 'slider',
				'device_settings' => false,
				'section'         => $section,
				'min'             => 0,
				'max'             => 30,
				'default'         => 6,
				'selector'        => "$selector > * + *",
				'css_format'      => 'margin-left: {{value}};',
				'label'           => __( 'Icon Spacing', 'nevo' ),
			),

			array(
				'name'       	=> $name . '_border_radius',
				'type'       	=> 'slider',
				'device_settings' => false,
				'section'    	=> $section,
				'min'             => 0,
				'step'            => 1,
				'max'             => 100,
				'default'         => 3,
				'label'      	=> __( 'Border Radius', 'nevo' ),
				'selector'   	=> "$selector .social-icons",
				'css_format' 	=> 'border-radius: {{value}};',
			),

			array(
				'name'       => $name . '_custom_color',
				'type'       => 'modal',
				'section'    => $section,
				'selector'   => "{$selector} .social-icons",
				'css_format' => 'styling',
				'title'      => __( 'Custom Color', 'nevo' ),
				'fields'     => array(
					'tabs'           => array(
						'default' => __( 'Normal', 'nevo' ),
						'hover'   => __( 'Hover', 'nevo' ),
					),
					'default_fields' => array(
						array(
							'name'       => 'secondary',
							'type'       => 'color',
							'label'      => __( 'Icon Color', 'nevo' ),
							'selector'   => "$selector .social-icons",
							'css_format' => 'color: {{value}};',
						),
						array(
							'name'       => 'primary',
							'type'       => 'color',
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => "$selector .social-icons",
							'css_format' => 'background-color: {{value}};',
						),
					),
					'hover_fields'   => array(
						array(
							'name'       => 'secondary',
							'type'       => 'color',
							'label'      => __( 'Icon Color', 'nevo' ),
							'selector'   => "$selector .social-icons:hover",
							'css_format' => 'color: {{value}};',
						),
						array(
							'name'       => 'primary',
							'type'       => 'color',
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => "$selector .social-icons:hover",
							'css_format' => 'background-color: {{value}};',
						),
					),
				),
			),
		);
		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_footer_social_config', 399 );

function nevo_refresh_footer_social_partials() {
	nevo_footer_element( 'footer-social');
}