<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_footer_html_config' ) ) {
	function nevo_customizer_footer_html_config($configs = array()) {
		$section  = 'footer_html';
		$name     = 'footer_html_1';
		$selector = '.footer-html';
		$config = array(
			array(
				'name'     => $section,
				'type'     => 'section',
				'panel'    => 'nevo_footer',
				'priority' => 90,
				'title'    => __( 'HTML', 'nevo' ),
			),
			
			array(
				'name'            => $name,
				'type'            => 'textarea',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 5,
				'theme_supports'  => '',
				'render_callback' => 'nevo_refresh_footer_html_1_partials',
				'default'         => __( '<div>Add anything here or just remove it...</div>', 'nevo' ),
				'title'           => __( 'HTML 1', 'nevo' ),
				'description'     => __( 'HTML code and Shortcode is allowed.', 'nevo' ),
			),
		);
		
		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_footer_html_config', 399 );

function nevo_refresh_footer_html_1_partials() {
	nevo_footer_element( 'html-1');
}