<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_scrolltop_config' ) ) {
	function nevo_customizer_scrolltop_config($configs = array()) {

        $section = 'scrolltop';
        $selector = '.nevo-scroll-to-top';
        $fn = 'nevo_back_to_top';
        $config = array(
            // Global layout section.
            array(
                'name'     => $section,
                'type'     => 'section',
                'panel'    => 'nevo_footer',
                'title'    => __('Scroll To Top', 'nevo'),
                'priority' => 200,
            ),

            array(
                'name'            => "{$section}_show",
                'type'            => 'checkbox',
                'section'         => $section,
                'default'         => 0,
                'checkbox_label'  => __('Show Scroll To Top Button', 'nevo'),
                'selector'        => $selector,
                'render_callback' => $fn,
            ),

			array(
				'name'            => "{$section}_visibility",
				'type'            => 'checkbox',
				'default'         => array(
					'desktop' => 1,
					'tablet'  => 1,
					'mobile'  => 1,
				),
				'section'         => $section,
				'selector'        => $selector,
				'device_settings' => true,
				'render_callback' => $fn,
				'label'           => __( 'Visibility', 'nevo' ),
				'checkbox_label'  => __( 'Visibility', 'nevo' ),
			),
			
            array(
                'name'            => "{$section}_icon",
                'type'            => 'icon',
                'section'         => $section,
                'default'         => array(
                    'type' => 'bootstrap-icons',
                    'icon' => 'bi-chevron-up'
                ),
                'label'  => __('Icon', 'nevo'),
                'selector'        => $selector,
                'render_callback' => $fn,
            ),

            array(
                'name'            => "{$section}_position",
                'type'            => 'radio_group',
                'section'         => $section,
                'label'           => __('Position', 'nevo'),
                'choices'         => array(
                    'left'    => is_rtl() ? __( 'Right', 'nevo' ) : __( 'Left', 'nevo' ),
					'right'   => is_rtl() ? __( 'Left', 'nevo' ) : __( 'Right', 'nevo' ),
                ),
                'default'         => 'right',
                'selector'        => $selector,
                'render_callback' => $fn,
            ),

            array(
                'name'            => "{$section}_display",
                'type'            => 'radio_group',
                'section'         => $section,
                'label'           => __('Display', 'nevo'),
                'choices'         => array(
                    'static'  => __( 'Static', 'nevo' ),
					'sticky'  => __( 'Sticky', 'nevo' ),
                ),
                'default'         => 'sticky',
                'selector'        => $selector,
                'render_callback' => $fn,
				'description' => __( '<strong>Static:</strong> displayed at the very bottom of the page. <br><strong>Sticky:</strong> visible as user scrolls down through the page.', 'nevo' ),
            ),
			
            array(
                'name'            => "{$section}_mgb",
                'type'            => 'slider',
                'min'             => 1,
				'step'            => 1,
				'max'             => 300,
                'section'         => $section,
                'device_settings' => true,
                'css_format'      => 'bottom: {{value}};',
                'label'           => __('Margin bottom', 'nevo'),
                'selector'        => "a{$selector}",
            ),
            array(
                'name'            => "{$section}_mgr",
                'type'            => 'slider',
                'min'             => 1,
				'step'            => 1,
				'max'             => 300,
                'device_settings' => true,
                'section'         => $section,
                'css_format'      => 'right: {{value}};',
                'label'           => __('Margin Right', 'nevo'),
                'selector'        => "{$selector}.scrolltop-position-right",
                'required'        => array(
                    array( "{$section}_position", '!=', 'left' ),
                    array("{$section}_show", '=', '1'),
                ),
            ),

            array(
                'name'            => "{$section}_mgl",
                'type'            => 'slider',
                'min'             => 1,
				'step'            => 1,
				'max'             => 300,
                'device_settings' => true,
                'section'         => $section,
                'css_format'      => 'left: {{value}};',
                'label'           => __('Margin Left', 'nevo'),
                'selector'        => "{$selector}.scrolltop-position-left",
                'required'        => array(
                    array( "{$section}_position", '=', 'left' ),
                    array("{$section}_show", '=', '1'),
                ),
            ),
			
			array(
				'name'       => $section . '_styling',
				'type'       => 'styling',
				'section'    => $section,
				'title'      => __( 'Styling', 'nevo' ),
				'selector'   => array(
					'normal' => "a{$selector}",
					'normal_text_color' => "a{$selector}",
					'normal_link_color' => "a{$selector}",
					'hover' => "a{$selector}:hover, a{$selector}:focus",
				),
				'default'   => array(
					'normal' => array(
						//'text_color' => '#ffffff',
						//'link_color' => '#ffffff',
					),
					'hover' => array(
						//'link_color' => '#ffffff',
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields'  => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'link_color' => false,
						'margin'     => false,
						'paddinga'   => false,
						'box_shadow' => false,
					),
					'hover_fields'    => array(
						'link_color'  => false,
						'margin'      => false,
						'box_shadow'  => false,
					),
				),
			),

        );

        return array_merge($configs, $config);
    }
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_scrolltop_config', 499 );