<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_header_account_config' ) ) {
	function nevo_customizer_header_account_config($configs = array()) {
		$section  = 'header_account';
		$name     = 'header_account';
		$selector = '.header-account';
		$config   = array(
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'nevo_header',
				'priority' => 60,
				'title' => __( 'Account', 'nevo' ),
			),
			
			array(
				'name'  		  => $name . '_title',
				'type'            => 'text',
				'section'         => $section,
				'theme_supports'  => '',
				'selector'        => '.header-account-vertical .popup-body',
				'render_callback' => 'nevo_account_sidebar_content',
				'title' 	=> __( 'Popup Title', 'nevo' ),
				'default' 	=> __( 'Offcanvas', 'nevo' ),
			),

			array(
				'name'            => $name . '_position',
				'type'            => 'radio_group',
				'section'         => $section,
				'title'           => __( 'Popup Position', 'nevo' ),
				'selector'        => '.header-account-vertical',
				'render_callback' => 'nevo_mobile_menu_sidebar',
				'css_format'      => 'html_class',
				'default'         => 'position-left',
				'choices'         => array(
					'position-left'  => __( 'Left', 'nevo' ),
					'position-right' => __( 'Right', 'nevo' ),
				),
			),
			
			array(
				'name'    => $name . '_hr',
				'type'    => 'hr',
				'section' => $section,
			),

			array(
				'name'            => $name . '_show_avata',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => 'nevo_refresh_header_account_partials',
				'checkbox_label'  => __( 'Show Avata.', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_show_label',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 0,
				'render_callback' => 'nevo_refresh_header_account_partials',
				'checkbox_label'  => __( 'Show Label.', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_label',
				'type'            => 'text',
				'section'         => $section,
				'selector'        => "$selector",
				'label'           => __( 'Label', 'nevo' ),
				'default'         => __( 'Login', 'nevo' ),
				'description' 	  => __( 'Display for non logged in users.', 'nevo' ),
				'render_callback' => 'nevo_refresh_header_account_partials',
			),
		);
		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_header_account_config', 399 );

function nevo_refresh_header_account_partials(){
	nevo_header_element( 'account');
}