<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_header_button_config' ) ) {
	function nevo_customizer_header_button_config($configs = array()) {
		$section  = 'header_button';
		$name     = 'header_button';
		$selector = '.header-button';
		$config   = array(
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'nevo_header',
				'priority' => 80,
				'title' => __( 'Button', 'nevo' ),
			),

			array(
				'name'            => $name . '_text',
				'type'            => 'text',
				'section'         => $section,
				'theme_supports'  => '',
				'selector'        => $selector,
				'render_callback' => 'nevo_refresh_header_button_partials',
				'priority' 		  => 5,
				'title'           => __( 'Text', 'nevo' ),
				'default'         => __( 'Button', 'nevo' ),
			),

			array(
				'name'            => $name . '_icon',
				'type'            => 'icon',
				'section'         => $section,
				'selector'        => $selector,
				'render_callback' => 'nevo_refresh_header_button_partials',
				'theme_supports'  => '',
				'priority' 		  => 10,
				'title'           => __( 'Icon', 'nevo' ),
			),
			
			array(
				'name'       	  => $name . '_size',
				'type'       	  => 'slider',
				'device_settings' => false,
				'section'    	  => $section,
				'min'             => 0,
				'step'            => 1,
				'max'             => 100,
				'default'         => 20,
				'priority' 		  => 15,
				'label'      	  => __( 'Icon size', 'nevo' ),
				'selector'   	  => $selector,
				'render_callback' => 'nevo_refresh_header_button_partials',
			),

			array(
				'name'            => $name . '_position',
				'type'            => 'radio_group',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 20,
				'default'         => 'after',
				'render_callback' => 'nevo_refresh_header_button_partials',
				'title'           => __( 'Icon Position', 'nevo' ),
				'choices'         => array(
					'before' => __( 'Before', 'nevo' ),
					'after'  => __( 'After', 'nevo' ),
				),
			),

			array(
				'name'            => $name . '_link',
				'type'            => 'text',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 25,
				'default'         => '#',
				'render_callback' => 'nevo_refresh_header_button_partials',
				'title'           => __( 'Link', 'nevo' ),
			),

			array(
				'name'            => $name . '_link_rel',
				'type'            => 'text',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 26,
				'default'         => 'noopener noreferrer',
				'render_callback' => 'nevo_refresh_header_button_partials',
				'title'           => __( 'Link Rel', 'nevo' ),
			),

			array(
				'name'            => $name . '_target',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 30,
				'render_callback' => 'nevo_refresh_header_button_partials',
				'checkbox_label'  => __( 'Open link in a new tab.', 'nevo' ),
			),
			
			array(
				'name'    => "hr_1",
				'type'    => 'hr',
				'section' => $section,
				'priority' => 180,
			),

			array(
				'name'        => $name . '_typography',
				'type'        => 'typography',
				'section'     => $section,
				'priority' 	  => 190,
				'title'       => __( 'Typography', 'nevo' ),
				'description' => __( 'Advanced typography for button', 'nevo' ),
				'selector'    => "$selector a.button-link",
				'css_format'  => 'typography',
				'default'     => array(),
			),

			array(
				'name'       => $name . '_setting',
				'type'       => 'modal',
				'priority'   => 200,
				'section'    => $section,
				'selector'   => '.header-button a.button-link',
				'css_format' => 'styling',
				'title'      => __( 'Button Style', 'nevo' ),
				'fields'     => array(
					'tabs'           => array(
						'default' => __( 'Normal', 'nevo' ),
						'hover'   => __( 'Hover', 'nevo' ),
					),
					'default_fields' => array(
						array(
							'name'       => $name . '_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color', 'nevo' ),
							'selector'   => '.header-button a.button-link',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_bg_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => '.header-button a.button-link',
							'css_format' => 'background-color: {{value}};',
						),
						
						array(
							'name'            => $name . '_padding',
							'type'            => 'css_ruler',
							'device_settings' => true,
							'selector'   	  => '.header-button a.button-link',
							'css_format'      => array(
								'top'    => 'padding-top: {{value}};',
								'right'  => 'padding-right: {{value}};',
								'bottom' => 'padding-bottom: {{value}};',
								'left'   => 'padding-left: {{value}};',
							),
							'label'           => __( 'Padding', 'nevo' ),
						),
						
						array(
							'name'  => $name . '_border_heading',
							'type'  => 'heading',
							'label' => __( 'Border', 'nevo' ),
						),

						array(
							'name'       => $name . '_border_style',
							'type'       => 'select',
							'class'      => 'clear',
							'selector'   => '.header-button a.button-link',
							'label'      => __( 'Border Style', 'nevo' ),
							'default'    => '',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'none'   => __( 'None', 'nevo' ),
								'solid'  => __( 'Solid', 'nevo' ),
								'dotted' => __( 'Dotted', 'nevo' ),
								'dashed' => __( 'Dashed', 'nevo' ),
								'double' => __( 'Double', 'nevo' ),
								'ridge'  => __( 'Ridge', 'nevo' ),
								'inset'  => __( 'Inset', 'nevo' ),
								'outset' => __( 'Outset', 'nevo' ),
							),
							'css_format' => 'border-style: {{value}};',
						),

						array(
							'name'       => $name . '_border_width',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Width', 'nevo' ),
							'selector'   => '.header-button a.button-link',
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => array(
								'top'    => 'border-top-width: {{value}};',
								'right'  => 'border-right-width: {{value}};',
								'bottom' => 'border-bottom-width: {{value}};',
								'left'   => 'border-left-width: {{value}};',
							),
						),
						array(
							'name'       => $name . '_border_color',
							'type'       => 'color',
							'label'      => __( 'Border Color', 'nevo' ),
							'selector'   => '.header-button a.button-link',
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => 'border-color: {{value}};',
						),

						array(
							'name'       => $name . '_border_radius',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Radius', 'nevo' ),
							'selector'   => '.header-button a.button-link',
							'css_format' => array(
								'top'    => 'border-top-left-radius: {{value}};',
								'right'  => 'border-top-right-radius: {{value}};',
								'bottom' => 'border-bottom-right-radius: {{value}};',
								'left'   => 'border-bottom-left-radius: {{value}};',
							),
						),
					),
					'hover_fields'   => array(
						array(
							'name'       => $name . '_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color', 'nevo' ),
							'selector'   => ".header-button a.button-link:hover",
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_bg_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => ".header-button a.button-link:hover",
							'css_format' => 'background-color: {{value}};',
						),
						
						array(
							'name'  => $name . '_border_heading',
							'type'  => 'heading',
							'label' => __( 'Border', 'nevo' ),
						),

						array(
							'name'       => $name . '_border_style',
							'type'       => 'select',
							'class'      => 'clear',
							'selector'   => '.header-button a.button-link:hover',
							'label'      => __( 'Border Style', 'nevo' ),
							'default'    => '',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'none'   => __( 'None', 'nevo' ),
								'solid'  => __( 'Solid', 'nevo' ),
								'dotted' => __( 'Dotted', 'nevo' ),
								'dashed' => __( 'Dashed', 'nevo' ),
								'double' => __( 'Double', 'nevo' ),
								'ridge'  => __( 'Ridge', 'nevo' ),
								'inset'  => __( 'Inset', 'nevo' ),
								'outset' => __( 'Outset', 'nevo' ),
							),
							'css_format' => 'border-style: {{value}};',
						),

						array(
							'name'       => $name . '_border_width',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Width', 'nevo' ),
							'selector'   => '.header-button a.button-link:hover',
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => array(
								'top'    => 'border-top-width: {{value}};',
								'right'  => 'border-right-width: {{value}};',
								'bottom' => 'border-bottom-width: {{value}};',
								'left'   => 'border-left-width: {{value}};',
							),
						),
						array(
							'name'       => $name . '_border_color',
							'type'       => 'color',
							'label'      => __( 'Border Color', 'nevo' ),
							'selector'   => '.header-button a.button-link:hover',
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => 'border-color: {{value}};',
						),

						array(
							'name'       => $name . '_border_radius',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Radius', 'nevo' ),
							'selector'   => '.header-button a.button-link:hover',
							'css_format' => array(
								'top'    => 'border-top-left-radius: {{value}};',
								'right'  => 'border-top-right-radius: {{value}};',
								'bottom' => 'border-bottom-right-radius: {{value}};',
								'left'   => 'border-bottom-left-radius: {{value}};',
							),
						),
					),
				),
			),
		);

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_header_button_config', 99 );

function nevo_refresh_header_button_partials(){
	nevo_header_element( 'button');
}