<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_header_html_config' ) ) {
	function nevo_customizer_header_html_config($configs = array()) {
		$section  = 'header_html';
		$name     = 'header_html';
		$selector = '.item-html-1';
		$config = array(
			array(
				'name'     => $section,
				'type'     => 'section',
				'panel'    => 'nevo_header',
				'priority' => 90,
				'title'    => __( 'HTML', 'nevo' ),
			),
			
			array(
				'name'            => $name .'_1',
				'type'            => 'textarea',
				'section'         => $section,
				'selector'        => $selector,
				'priority' 		  => 5,
				'theme_supports'  => '',
				'render_callback' => 'nevo_refresh_header_html_1_partials',
				'default'         => __( 'Add anything here or just remove it...', 'nevo' ),
				'title'           => __( 'HTML 1', 'nevo' ),
				'description'     => __( 'HTML code and Shortcode is allowed.', 'nevo' ),
			),
/* 
			array(
				'name'       => $name . '_typo',
				'type'       => 'typography',
				'section'    => $section,
				'priority' 	 => 100,
				'selector'   => '.header-section .header-html, .header-html .html-inner',
				'css_format' => 'typography',
				'title'      => __( 'Typography', 'nevo' ),
			), */

		);
		
		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_header_html_config', 399 );

function nevo_refresh_header_html_1_partials() {
	nevo_header_element( 'html-1');
}