<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_logo_config' ) ) {
	function nevo_customizer_logo_config($configs) {
		$section  = 'title_tagline';
		$name     = 'header_logo';
		$selector = '.site-branding';
		
		$config       = array(
			
			array(
				'name'            => 'logo_max_width',
				'type'            => 'slider',
				'section'         => $section,
				'theme_supports'  => '',
				'max'             => 400,
				'priority'        => 7,
				'device_settings' => true,
				'title'           => __( 'Logo Max Width', 'nevo' ),
				'selector'        => "{$selector } img.is-logo-image",
				'css_format'      => "max-width: {{value}};",
				'default'         => array(
					'desktop' => array(
						'value' => 100,
					),
					'tablet'  => array(
						'value' => '',
					),
					'mobile'  => array(
						'value' => '',
					),
				),
			),
			
			array(
				'name'            => 'header_logo_retina',
				'type'            => 'image',
				'section'         => $section,
				'device_settings' => false,
				'selector'        => $selector,
				'priority'        => 8,
				'render_callback' => 'nevo_refresh_header_logo',
				'title'           => __( 'Logo Retina', 'nevo' ),
			),
			
			array(
				'name'       => $name . '_site_title_color',
				'type'       => 'color',
				'section'    => $section,
				'title'      => __( 'Site Title Color', 'nevo' ),
				'selector'   => "{$selector} .main-title a",
				'css_format' => 'color: {{value}}',
				'priority' 	 => 2,
			),
			
			array(
				'name'            => 'header_logo_name',
				'type'            => 'radio_group',
				'section'         => $section,
				'selector'        => $selector,
				'priority'        => 3,
				'render_callback' => 'nevo_refresh_header_logo',
				'title'           => __( 'Show Site Title', 'nevo' ),
				'default'         => 'yes',
				'choices'         => array(
					'yes' => __( 'Yes', 'nevo' ),
					'no'  => __( 'No', 'nevo' ),
				),
			),

			array(
				'name'            => 'header_logo_desc',
				'type'            => 'radio_group',
				'section'         => $section,
				'selector'        => $selector,
				'priority'        => 5,
				'render_callback' => 'nevo_refresh_header_logo',
				'title'           => __( 'Show Site Tagline', 'nevo' ),
				'default'         => 'no',
				'choices'         => array(
					'yes' => __( 'Yes', 'nevo' ),
					'no'  => __( 'No', 'nevo' ),
				),
			),

		);

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_logo_config' );

function nevo_refresh_header_logo() {
	nevo_header_element( 'title-tagline');
}

function nevo_refresh_header_logo_partials( WP_Customize_Manager $wp_customize ) {

	if ( ! isset( $wp_customize->selective_refresh ) ) {
	      return;
	 }

	// Account
	$wp_customize->selective_refresh->add_partial( 'title-tagline', array(
	    'selector' => '.site-branding',
	    'container_inclusive' => true,
	    'settings' => array('custom_logo', 'blogname', 'blogdescription'),
	    'render_callback' => function() {
	        get_template_part('template-parts/header/title','tagline');
	    },
	) );
}
add_action( 'customize_register', 'nevo_refresh_header_logo_partials' );