<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_header_mobile_menu_config' ) ) {
	function nevo_customizer_header_mobile_menu_config($configs = array()) {
		$section  = 'mobile_menu';
		$name     = 'mobile_menu';
		$selector = ".mobile-vertical-header";
		$config   = array(
			array(
				'name'     => $section,
				'type'     => 'section',
				'panel'    => 'nevo_header',
				'priority' => 30,
				'title'    => __( 'Toggle Menu / Popup', 'nevo' ),
			),
			
			array(
				'name'    => $section . '_h_popup',
				'type'    => 'heading',
				'section' => $section,
				'title'   => __( 'Popup', 'nevo' ),
			),
			
			array(
				'name'  		  => $name . '_title',
				'type'            => 'text',
				'section'         => $section,
				'theme_supports'  => '',
				'selector'        => '.mobile-vertical-header .popup-body',
				'render_callback' => 'nevo_mobile_menu_sidebar_content',
				'title' 	=> __( 'Popup Title', 'nevo' ),
				'default' 	=> __( 'Offcanvas', 'nevo' ),
			),

			array(
				'name'             => $name . '_items',
				'type'             => 'repeater',
				'section'          => $section,
				'selector'         => '.mobile-vertical-header .popup-body',
				'render_callback' => 'nevo_mobile_menu_sidebar_content',
				'title'            => __( 'Mobile Menu Elements', 'nevo' ),
				'live_title_field' => 'title',
				'default'          => array(
					array(
						'title' 	=> 'Search Box',
						'elements'  => 'search-box',
					),
					array(
						'title' 	=> 'Mobile Menu',
						'elements'  => 'mobile-menu',
					),
				),
				'fields'           => array(
					array(
						'name'  => 'title',
						'type'  => 'text',
						'label' => __( 'Title', 'nevo' ),
					),

					array(
						'name'     => 'elements',
						'type'     => 'select',
						'label'    => __( 'Menu Elements', 'nevo' ),
						'choices'  => apply_filters(
							'nevo_mobile_menu_items' ,array(
							'html'   		=> __( 'HTML', 'nevo' ),
							'search-box'   	=> __( 'Search Box', 'nevo' ),
							'mobile-menu'  	=> __( 'Mobile Menu', 'nevo' ),
							'social-icons' 	=> __( 'Social Icons', 'nevo' ),
						) ),
					),
					
				),
			),
			
			array(
				'name'            => $name . '_position',
				'type'            => 'radio_group',
				'section'         => $section,
				'title'           => __( 'Popup Position', 'nevo' ),
				'selector'        => $selector,
				'render_callback' => 'nevo_mobile_menu_sidebar',
				'css_format'      => 'html_class',
				'default'         => 'position-left',
				'choices'         => array(
					'position-left'  => __( 'Left', 'nevo' ),
					'position-right' => __( 'Right', 'nevo' ),
				),
			),
			
			array(
				'name'       => $name . '_color',
				'type'       => 'color',
				'section'    => $section,
				'title'      => __( 'Text Color', 'nevo' ),
				'selector'   => "{$selector} .menu-mobile > li.menu-item, {$selector} .menu-mobile li.menu-item .nevo-menu-link, .mobile-vertical-header .popup-body, .popup-body .popup-title, .popup-body .button-close",
				'css_format' => 'color: {{value}}',
			),
			
			array(
				'name'       => $name . '_highlight_color',
				'type'       => 'color',
				'section'    => $section,
				'title'      => __( 'Menu Highlight Color', 'nevo' ),
				'selector'   => '.menu-mobile > li.menu-item > .nevo-menu-link:hover, .menu-mobile > li.menu-item > .nevo-menu-link:focus, .menu-mobile > li[class*="current-menu-"] > .nevo-menu-link',
				'css_format' => 'color: {{value}}',
			),
			
			array(
				'name'       => $name . '_menu_typography',
				'type'       => 'typography',
				'section'    => $section,
				'title'      => __( 'Menu Typography', 'nevo' ),
				'selector'   => "{$selector} .menu-mobile > li, {$selector} .menu-mobile > li > a",
				'css_format' => 'typography',
				'default'    => array(),
			),

			array(
				'name'       => $name . '_submenu_typography',
				'type'       => 'typography',
				'section'    => $section,
				'title'      => __( 'Submenu Typography', 'nevo' ),
				'selector'   => "{$selector} .menu-mobile .sub-menu, {$selector} .menu-mobile .sub-menu p, {$selector} .menu-mobile .sub-menu a",
				'css_format' => 'typography',
				'default'    => array(),
			),
		);
		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_header_mobile_menu_config', 299 );