<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_menu_icon_config' ) ) {
	function nevo_customizer_menu_icon_config($configs = array()) {
		$section  = 'mobile_menu';
		$name     = 'toggle_menu';
		$selector = '.header-menu-toggle';
		$config   = array(
			/* array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'nevo_header',
				'priority' => 45,
				'title' => __( 'Toggle Menu', 'nevo' ),
			), */
			
			array(
				'name'            => $name . '_label',
				'type'            => 'text',
				'section'         => $section,
				'theme_supports'  => '',
				'selector'        => $selector,
				'render_callback' => 'nevo_refresh_header_toggle_partials',
				'title'           => __( 'Menu Label', 'nevo' ),
				'priority' 		  => 1,
			),

			array(
				'name'            => $section . '_size',
				'type'            => 'slider',
				'device_settings' => false,
				'section'         => $section,
				'min'             => 10,
				'step'            => 1,
				'max'             => 50,
				'selector'        => "$selector",
				'render_callback' => 'nevo_refresh_header_toggle_partials',
				'label'           => __( 'Icon Size', 'nevo' ),
				'default'         => 20,
				'priority' 		  => 2,
			),

			array(
				'name'       => $name . '_settings',
				'type'       => 'modal',
				'priority' 	 => 3,
				'section'    => $section,
				'title'      => __( 'Styling', 'nevo' ),
				'selector'   => $selector,
				'css_format' => 'styling',
				'fields'     => array(
					'tabs'          => array(
						'normal' => __( 'Normal', 'nevo' ),
					),
					'normal_fields' => array(
						array(
							'name'       => $name . '_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color', 'nevo' ),
							'selector'   => "{$selector} .menu-toggle",
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_hover_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color Hover', 'nevo' ),
							'selector'   => "{$selector} .menu-toggle:hover, {$selector} .menu-toggle:focus",
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_bg_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => "{$selector} .menu-toggle",
							'css_format' => 'background-color: {{value}};',
						),
						
						array(
							'name'            => $name . '_padding',
							'type'            => 'css_ruler',
							'device_settings' => true,
							'selector'   => "{$selector} .menu-toggle",
							'css_format'      => array(
								'top'    => 'padding-top: {{value}};',
								'right'  => 'padding-right: {{value}};',
								'bottom' => 'padding-bottom: {{value}};',
								'left'   => 'padding-left: {{value}};',
							),
							'label'           => __( 'Padding', 'nevo' ),
						),

						array(
							'name'  => $name . '_border_heading',
							'type'  => 'heading',
							'label' => __( 'Border', 'nevo' ),
						),

						array(
							'name'       => $name . '_border_style',
							'type'       => 'select',
							'class'      => 'clear',
							'selector'   => "{$selector} .menu-toggle",
							'label'      => __( 'Border Style', 'nevo' ),
							'default'    => '',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'none'   => __( 'None', 'nevo' ),
								'solid'  => __( 'Solid', 'nevo' ),
								'dotted' => __( 'Dotted', 'nevo' ),
								'dashed' => __( 'Dashed', 'nevo' ),
								'double' => __( 'Double', 'nevo' ),
								'ridge'  => __( 'Ridge', 'nevo' ),
								'inset'  => __( 'Inset', 'nevo' ),
								'outset' => __( 'Outset', 'nevo' ),
							),
							'css_format' => 'border-style: {{value}};',
						),

						array(
							'name'       => $name . '_border_width',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Width', 'nevo' ),
							'selector'   => "{$selector} .menu-toggle",
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => array(
								'top'    => 'border-top-width: {{value}};',
								'right'  => 'border-right-width: {{value}};',
								'bottom' => 'border-bottom-width: {{value}};',
								'left'   => 'border-left-width: {{value}};',
							),
						),
						array(
							'name'       => $name . '_border_color',
							'type'       => 'color',
							'label'      => __( 'Border Color', 'nevo' ),
							'selector'   => "{$selector} .menu-toggle",
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => 'border-color: {{value}};',
						),

						array(
							'name'       => $name . '_border_radius',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Radius', 'nevo' ),
							'selector'   => "{$selector} .menu-toggle",
							'css_format' => array(
								'top'    => 'border-top-left-radius: {{value}};',
								'right'  => 'border-top-right-radius: {{value}};',
								'bottom' => 'border-bottom-right-radius: {{value}};',
								'left'   => 'border-bottom-left-radius: {{value}};',
							),
						),
					),
				),
			),
		);
		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_menu_icon_config', 399 );

function nevo_refresh_header_toggle_partials() {
	nevo_header_element( 'toggle-menu');
}