<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_other_page_config' ) ) {
	
	function nevo_customizer_other_page_config( $configs ) {

		$config = array(
			// General panel.
			array(
				'name'           => 'other_page_panel',
				'type'           => 'panel',
				'priority'       => 20,
				'theme_supports' => '',
				'title'          => __( 'Page', 'nevo' ),
			),
			
			array(
				'name'  => "other_page_static",
				'type'  => 'section',
				'panel' => 'other_page_panel',
				'title' => __( 'Static Page', 'nevo' ),
				'priority' => 10,
			),
			
			array(
				'name'    => 'page_single_h_content_header',
				'type'    => 'heading',
				'section' => 'other_page_static',
				'title'   => __( 'Content Header', 'nevo' ),
			),
			
			array(
				'name'            => 'page_single_page_header_layout',
				'type'            => 'radio_group',
				'section'         => 'other_page_static',
				'title'           => __( 'Page Header Layout', 'nevo' ),
				'selector'        => 'body.page .page-header .nevo-container',
				'css_format'      => 'html_class',
				'default'         => 'normal',
				'choices'         => array(
					'normal'      => __( 'Contained', 'nevo' ),
					'cv-mw-100'   => __( 'Full Width', 'nevo' ),
				),
			),
			
			array(
				'name'            => 'page_single_page_header_display',
				'type'            => 'select',
				'section'         => 'other_page_static',
				'device_settings' => false,
				'selector'        => 'body.page .page-header',
				'default'         => 'after',
				'label'           => __( 'Display', 'nevo' ),
				'choices'         => array(
					'disable' 	=> __( 'Disable', 'nevo' ),
					'before' 	=> __( 'Before Content', 'nevo' ),
					'after' 	=> __( 'After Header', 'nevo' ),
				),
			),
			
			array(
				'name'            => 'page_single_one_containers_padding',
				'type'            => 'css_ruler',
				'section'         => 'other_page_static',
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'right'  => 'padding-right: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
					'left'   => 'padding-left: {{value}};',
				),
				'selector'        => 'body.page .one-container .site-main .inside-page-header',
				'required'   => array(
					array( 'content_layout', '=', 'one-container' ),
					array( 'page_single_page_header_display', '=', 'before' )
				),
			),
							
			array(
				'name'             => 'page_single_page_header_elements',
				'type'             => 'repeater',
				'section'          => 'other_page_static',
				'selector'         => 'body.page .page-header',
				'title'            => __( 'Elements', 'nevo' ),
				'description'      => __( 'Drag and drop to reorder.', 'nevo' ),
				'live_title_field' => 'title',
				'addable'          => false,
				'title_only'       => true,
				'default'          => apply_filters(
					'nevo_page_single_page_header_elements', array(
						array(
							'title' 	=> 'Breadcrumb',
							'elements'  => 'breadcrumb',
						),
						array(
							'title' 	=> 'Title',
							'elements'  => 'title',
							'_visibility' => 'hidden',
						)
					)
				),
				'fields'           => array(
					array(
						'name'  => 'title',
						'type'  => 'hidden',
						'label' => __( 'Title', 'nevo' ),
					),
					array(
						'name' => 'elements',
						'type' => 'hidden',
					),
					
				),
			),
			
			array(
				'name'            => 'page_single_page_header_background_image',
				'type'            => 'select',
				'section'         => 'other_page_static',
				'device_settings' => false,
				'selector'        => 'body.page .page-header',
				'default'         => 'global',
				'label'           => __( 'Background image', 'nevo' ),
				'render_callback' => 'nevo_page_header_section',
				'choices'         => array(
					'global' 	=> __( 'Global', 'nevo' ),
					'custom' 	=> __( 'Custom', 'nevo' ),
					'thumbnail' => __( 'Featured image', 'nevo' ),
				),
			),
			array(
				'name'       => 'page_single_page_header_style',
				'type'       => 'modal',
				'section'    => 'other_page_static',
				'title'      => __( 'Page Header Styling', 'nevo' ),
				'selector'   => 'body.page .page-header',
				'css_format' => 'styling',
				'fields'     => array(
					'tabs'          => array(
						'normal' => __( 'Normal', 'nevo' ),
					),
					'normal_fields' => array(
						array(
							'name'       => 'page_single_text_color',
							'type'       => 'color',
							'label'      => __( 'Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.page .page-header .inside-page-header, body.page .page-header .entry-title, body.page .page-header .entry-meta',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => 'page_single_link_color',
							'type'       => 'color',
							'label'      => __( 'Link Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.page .page-header .inside-page-header a',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => 'page_single_hover_link_color',
							'type'       => 'color',
							'label'      => __( 'Link Color Hover', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.page .page-header .inside-page-header a:hover, body.page .page-header .inside-page-header a:focus',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						
						array(
							'name'            => 'page_single_page_header_align',
							'type'            => 'text_align_no_justify',
							'device_settings' => true,
							'selector'   	  => "body.page .page-header .inside-page-header",
							'css_format'      => 'text-align: {{value}};',
							'label'           => __( 'Align', 'nevo' ),
						),
						array(
							'name'  => 'page_single_bg_heading',
							'type'  => 'heading',
							'label' => __( 'Background', 'nevo' ),
						),
						
						array(
							'name'       => 'page_single_bg_color',
							'type'       => 'color',
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => 'body.page .page-header',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => 'page_single_bg_overlay_color',
							'type'       => 'color',
							'label'      => __( 'Background overlay color', 'nevo' ),
							'selector'   => 'body.page .page-header:before',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => 'page_single_bg_image',
							'type'       => 'image',
							'label'      => __( 'Background Image', 'nevo' ),
							'selector'   => 'body.page .page-header',
							'css_format' => 'background-image: url("{{value}}");',
							'device_settings' => false,
						),
						array(
							'name'       => 'page_single_bg_cover',
							'type'       => 'select',
							'default'    => 'cover',
							'choices'    => array(
								''        => __( 'Default', 'nevo' ),
								'auto'    => __( 'Auto', 'nevo' ),
								'cover'   => __( 'Cover', 'nevo' ),
								'contain' => __( 'Contain', 'nevo' ),
							),
							'label'      => __( 'Size', 'nevo' ),
							'class'      => 'field-half-left',
							'selector'   => 'body.page .page-header',
							'css_format' => '-webkit-background-size: {{value}}; -moz-background-size: {{value}}; -o-background-size: {{value}}; background-size: {{value}};',
							'required'   => array( 'page_single_bg_image', 'not_empty', '' ),
						),
						array(
							'name'       => 'page_single_bg_position',
							'type'       => 'select',
							'label'      => __( 'Position', 'nevo' ),
							'class'      => 'field-half-right',
							'default'    => 'center',
							'choices'    => array(
								''              => __( 'Default', 'nevo' ),
								'center'        => __( 'Center', 'nevo' ),
								'top left'      => __( 'Top Left', 'nevo' ),
								'top right'     => __( 'Top Right', 'nevo' ),
								'top center'    => __( 'Top Center', 'nevo' ),
								'bottom left'   => __( 'Bottom Left', 'nevo' ),
								'bottom center' => __( 'Bottom Center', 'nevo' ),
								'bottom right'  => __( 'Bottom Right', 'nevo' ),
							),
							'selector'   => 'body.page .page-header',
							'css_format' => 'background-position: {{value}};',
							'required'   => array( 'page_single_bg_image', 'not_empty', '' ),
						),
						array(
							'name'       => 'page_single_bg_repeat',
							'type'       => 'select',
							'label'      => __( 'Repeat', 'nevo' ),
							'class'      => 'field-half-left',
							'default'    => 'no-repeat',
							'choices'    => array(
								'repeat'    => __( 'Default', 'nevo' ),
								'no-repeat' => __( 'No repeat', 'nevo' ),
								'repeat-x'  => __( 'Repeat horizontal', 'nevo' ),
								'repeat-y'  => __( 'Repeat vertical', 'nevo' ),
							),
							'selector'   => 'body.page .page-header',
							'css_format' => 'background-repeat: {{value}};',
							'required'   => array( 'page_single_bg_image', 'not_empty', '' ),
						),

						array(
							'name'       => 'page_single_bg_attachment',
							'type'       => 'select',
							'label'      => __( 'Attachment', 'nevo' ),
							'class'      => 'field-half-right',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'scroll' => __( 'Scroll', 'nevo' ),
								'fixed'  => __( 'Fixed', 'nevo' ),
							),
							'selector'   => 'body.page .page-header',
							'css_format' => 'background-attachment: {{value}};',
							'required'   => array( 'page_single_bg_image', 'not_empty', '' ),
						),
					),
				),
			),
			
			array(
				'name'    => 'page_single_h_content',
				'type'    => 'heading',
				'section' => 'other_page_static',
				'priority' => 55,
				'title'   => __( 'Content / Sidebar', 'nevo' ),
			),
			
			// Page sidebar layout.
			array(
				'name'    => 'page_single_sidebar_layout',
				'type'    => 'image_select',
				'priority' => 60,
				'default' => '',
				'default' => 'right-sidebar',
				'section' => 'other_page_static',
				'title'   => __( 'Sidebar Layout', 'nevo' ),
				'choices' => nevo_get_sidebar_layouts(),
			),
			
			array(
				'name'            => 'page_single_display_comments_element',
				'type'            => 'checkbox',
				'section'         => 'other_page_static',
				'priority' 		  => 80,
				'selector'        => '.page .site-main',
				'default'         => 0,
				'title'  		  => __( 'Display Comments', 'nevo' ),
			),
				
			// Search.
			array(
				'name'  => "other_page_search",
				'type'  => 'section',
				'panel' => 'other_page_panel',
				'title' => __( 'Search Results Page', 'nevo' ),
				'priority' => 50,
			),
			
			array(
				'name'    => 'search_h_content_header',
				'type'    => 'heading',
				'section' => 'other_page_search',
				'title'   => __( 'Content Header', 'nevo' ),
			),
			
			array(
				'name'            => 'search_page_header_layout',
				'type'            => 'radio_group',
				'section'         => 'other_page_search',
				'title'           => __( 'Page Header Layout', 'nevo' ),
				'selector'        => 'body.search-results:not(.archive) .page-header .nevo-container',
				'css_format'      => 'html_class',
				'default'         => 'normal',
				'choices'         => array(
					'normal'      => __( 'Contained', 'nevo' ),
					'cv-mw-100'   => __( 'Full Width', 'nevo' ),
				),
			),
			
			array(
				'name'            => 'search_page_header_display',
				'type'            => 'select',
				'section'         => 'other_page_search',
				'device_settings' => false,
				'selector'        => 'body.search-results:not(.archive) .page-header',
				'default'         => 'after',
				'label'           => __( 'Display', 'nevo' ),
				'choices'         => array(
					'disable' 	=> __( 'Disable', 'nevo' ),
					'before' 	=> __( 'Before Content', 'nevo' ),
					'after' 	=> __( 'After Header', 'nevo' ),
				),
			),
			
			array(
				'name'            => 'search_page_one_containers_padding',
				'type'            => 'css_ruler',
				'section'         => 'other_page_search',
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'right'  => 'padding-right: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
					'left'   => 'padding-left: {{value}};',
				),
				'selector'        => 'body.search-results:not(.archive) .one-container .site-main .inside-page-header',
				'required'   => array(
					array( 'content_layout', '=', 'one-container' ),
					array( 'search_page_header_display', '=', 'before' )
				),
			),
							
			array(
				'name'             => 'search_page_header_elements',
				'type'             => 'repeater',
				'section'          => 'other_page_search',
				'selector'         => 'body.search-results:not(.archive) .page-header',
				'title'            => __( 'Elements', 'nevo' ),
				'description'      => __( 'Drag and drop to reorder.', 'nevo' ),
				'live_title_field' => 'title',
				'addable'          => false,
				'title_only'       => true,
				'default'          => apply_filters(
					'nevo_search_page_header_elements', array(
						array(
							'title' 	=> 'Breadcrumb',
							'elements'  => 'breadcrumb',
							'_visibility' => 'hidden',
						),
						array(
							'title' 	=> 'Title',
							'elements'  => 'title',
						),
						array(
							'title' 	=> 'Search Form',
							'elements'  => 'search-form',
						)
					)
				),
				'fields'           => array(
					array(
						'name'  => 'title',
						'type'  => 'hidden',
						'label' => __( 'Title', 'nevo' ),
					),
					array(
						'name' => 'elements',
						'type' => 'hidden',
					),
					
				),
			),
			
			array(
				'name'            => 'search_page_header_background_image',
				'type'            => 'select',
				'section'         => 'other_page_search',
				'device_settings' => false,
				'selector'        => 'body.search-results:not(.archive) .page-header',
				'default'         => 'global',
				'label'           => __( 'Background image', 'nevo' ),
				'render_callback' => 'nevo_page_header_section',
				'choices'         => array(
					'global' 	=> __( 'Global', 'nevo' ),
					'custom' 	=> __( 'Custom', 'nevo' ),
				),
			),
			
			array(
				'name'       => 'search_page_page_header_style',
				'type'       => 'modal',
				'section'    => 'other_page_search',
				'title'      => __( 'Page Header Styling', 'nevo' ),
				'selector'   => 'body.search-results:not(.archive) .page-header',
				'css_format' => 'styling',
				'fields'     => array(
					'tabs'          => array(
						'normal' => __( 'Normal', 'nevo' ),
					),
					'normal_fields' => array(
						array(
							'name'       => 'search_page_text_color',
							'type'       => 'color',
							'label'      => __( 'Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.search-results:not(.archive) .page-header .inside-page-header, body.search-results:not(.archive) .page-header .page-title',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'            => 'search_page_page_header_align',
							'type'            => 'text_align_no_justify',
							'device_settings' => true,
							'selector'   	  => "body.search-results:not(.archive) .page-header .inside-page-header",
							'css_format'      => 'text-align: {{value}};',
							'label'           => __( 'Align', 'nevo' ),
						),
						array(
							'name'  => 'search_page_bg_heading',
							'type'  => 'heading',
							'label' => __( 'Background', 'nevo' ),
						),
						
						array(
							'name'       => 'search_page_bg_color',
							'type'       => 'color',
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => 'body.search-results:not(.archive) .page-header',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => 'search_page_bg_overlay_color',
							'type'       => 'color',
							'label'      => __( 'Background overlay color', 'nevo' ),
							'selector'   => 'body.search-results:not(.archive) .page-header:before',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => 'search_page_bg_image',
							'type'       => 'image',
							'label'      => __( 'Background Image', 'nevo' ),
							'selector'   => 'body.search-results:not(.archive) .page-header',
							'css_format' => 'background-image: url("{{value}}");',
							'device_settings' => false,
						),
						array(
							'name'       => 'search_page_bg_cover',
							'type'       => 'select',
							'default'    => 'cover',
							'choices'    => array(
								''        => __( 'Default', 'nevo' ),
								'auto'    => __( 'Auto', 'nevo' ),
								'cover'   => __( 'Cover', 'nevo' ),
								'contain' => __( 'Contain', 'nevo' ),
							),
							'label'      => __( 'Size', 'nevo' ),
							'class'      => 'field-half-left',
							'selector'   => 'body.search-results:not(.archive) .page-header',
							'css_format' => '-webkit-background-size: {{value}}; -moz-background-size: {{value}}; -o-background-size: {{value}}; background-size: {{value}};',
							'required'   => array( 'search_page_bg_image', 'not_empty', '' ),
						),
						array(
							'name'       => 'search_page_bg_position',
							'type'       => 'select',
							'label'      => __( 'Position', 'nevo' ),
							'class'      => 'field-half-right',
							'default'    => 'center',
							'choices'    => array(
								''              => __( 'Default', 'nevo' ),
								'center'        => __( 'Center', 'nevo' ),
								'top left'      => __( 'Top Left', 'nevo' ),
								'top right'     => __( 'Top Right', 'nevo' ),
								'top center'    => __( 'Top Center', 'nevo' ),
								'bottom left'   => __( 'Bottom Left', 'nevo' ),
								'bottom center' => __( 'Bottom Center', 'nevo' ),
								'bottom right'  => __( 'Bottom Right', 'nevo' ),
							),
							'selector'   => 'body.search-results:not(.archive) .page-header',
							'css_format' => 'background-position: {{value}};',
							'required'   => array( 'search_page_bg_image', 'not_empty', '' ),
						),
						array(
							'name'       => 'search_page_bg_repeat',
							'type'       => 'select',
							'label'      => __( 'Repeat', 'nevo' ),
							'class'      => 'field-half-left',
							'default'    => 'no-repeat',
							'choices'    => array(
								'repeat'    => __( 'Default', 'nevo' ),
								'no-repeat' => __( 'No repeat', 'nevo' ),
								'repeat-x'  => __( 'Repeat horizontal', 'nevo' ),
								'repeat-y'  => __( 'Repeat vertical', 'nevo' ),
							),
							'selector'   => 'body.search-results:not(.archive) .page-header',
							'css_format' => 'background-repeat: {{value}};',
							'required'   => array( 'search_page_bg_image', 'not_empty', '' ),
						),

						array(
							'name'       => 'search_page_bg_attachment',
							'type'       => 'select',
							'label'      => __( 'Attachment', 'nevo' ),
							'class'      => 'field-half-right',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'scroll' => __( 'Scroll', 'nevo' ),
								'fixed'  => __( 'Fixed', 'nevo' ),
							),
							'selector'   => 'body.search-results:not(.archive) .page-header',
							'css_format' => 'background-attachment: {{value}};',
							'required'   => array( 'search_page_bg_image', 'not_empty', '' ),
						),
					),
				),
			),
			
			array(
				'name'    => 'search_h_content',
				'type'    => 'heading',
				'section' => 'other_page_search',
				'priority' => 55,
				'title'   => __( 'Content / Sidebar', 'nevo' ),
			),
			
			array(
				'name'    => 'search_sidebar_layout',
				'type'    => 'image_select',
				'priority' => 60,
				'default' => 'right-sidebar',
				'section' => 'other_page_search',
				'title'   => __( 'Sidebar Layout', 'nevo' ),
				'choices' => nevo_get_sidebar_layouts(),
			),
			// Page 404.
			array(
				'name'  => "other_page_404",
				'type'  => 'section',
				'panel' => 'other_page_panel',
				'title' => __( '404 Page', 'nevo' ),
				'priority' => 60,
			),
			
			// 404.
			array(
				'name'    => '404_sidebar_layout',
				'type'    => 'image_select',
				'priority' => 50,
				'default' => 'right-sidebar',
				'section' => "other_page_404",
				'title'   => __( 'Sidebar Layout', 'nevo' ),
				'choices' => nevo_get_sidebar_layouts(),
			),
		);
		$post_types = Nevo()->get_post_types( false );

		if ( count( $post_types ) ) {
			foreach ( $post_types as $pt => $label ) {
				if ( $pt !== 'product' ) {
					$config[] = array(
						'name'  => "{$pt}_single_page_section",
						'type'  => 'section',
						'panel' => 'other_page_panel',
						'title' => sprintf( __( 'Single %s', 'nevo' ), $label['singular_name'] ),
						'priority' => 70,
					);
					
					$config[] = array(
						'name'    => "{$pt}_h_content_header",
						'type'    => 'heading',
						'section' => "{$pt}_single_page_section",
						'title'   => __( 'Content Header', 'nevo' ),
					);
							
					array(
						'name'            => "{$pt}_single_page_header_layout",
						'type'            => 'radio_group',
						'section'         => "{$pt}_single_page_section",
						'title'           => __( 'Page Header Layout', 'nevo' ),
						'selector'        => "body.{$pt} .page-header .nevo-container",
						'css_format'      => 'html_class',
						'default'         => 'normal',
						'choices'         => array(
							'normal'      => __( 'Contained', 'nevo' ),
							'cv-mw-100'   => __( 'Full Width', 'nevo' ),
						),
					);
					
					$config[] = array(
						'name'            => "{$pt}_single_page_header_display",
						'type'            => 'select',
						'section'         => "{$pt}_single_page_section",
						'device_settings' => false,
						'selector'        => "body.{$pt} .page-header",
						'default'         => 'after',
						'label'           => __( 'Display', 'nevo' ),
						'choices'         => array(
							'disable' 	=> __( 'Disable', 'nevo' ),
							'before' 	=> __( 'Before Content', 'nevo' ),
							'after' 	=> __( 'After Header', 'nevo' ),
						),
					);
								
					$config[] = array(
						'name'             => "{$pt}_single_page_header_elements",
						'type'             => 'repeater',
						'section'          => "{$pt}_single_page_section",
						'selector'         => "body.{$pt} .page-header",
						'title'            => __( 'Elements', 'nevo' ),
						'description'      => __( 'Drag and drop to reorder.', 'nevo' ),
						'live_title_field' => 'title',
						'addable'          => false,
						'title_only'       => true,
						'default'          => apply_filters(
							'nevo_page_single_page_header_elements', array(
								array(
									'title' 	=> 'Breadcrumb',
									'elements'  => 'breadcrumb',
								),
								array(
									'title' 	=> 'Title',
									'elements'  => 'title',
									'_visibility' => 'hidden',
								)
							)
						),
						'fields'           => array(
							array(
								'name'  => 'title',
								'type'  => 'hidden',
								'label' => __( 'Title', 'nevo' ),
							),
							array(
								'name' => 'elements',
								'type' => 'hidden',
							),
							
						),
					);
					
					$config[] = array(
						'name'            => "{$pt}_single_page_header_align",
						'type'            => 'text_align_no_justify',
						'section'         => "{$pt}_single_page_section",
						'device_settings' => true,
						'selector'   	  => "body.{$pt} .page-header",
						'css_format'      => 'text-align: {{value}};',
						'title'           => __( 'Align', 'nevo' ),
					);
					
					$config[] = array(
						'name'            => "{$pt}_single_page_header_background_image",
						'type'            => 'select',
						'section'         => "{$pt}_single_page_section",
						'device_settings' => false,
						'selector'        => "body.{$pt} .page-header",
						'default'         => 'global',
						'label'           => __( 'Background image', 'nevo' ),
						'render_callback' => 'nevo_page_header_section',
						'choices'         => array(
							'global' 	=> __( 'Global', 'nevo' ),
							'custom' 	=> __( 'Custom', 'nevo' ),
							'thumbnail' => __( 'Featured image', 'nevo' ),
						),
					);
					
					$config[] = array(
						'name'       => "{$pt}_single_overlay_color",
						'type'       => 'color',
						'section'    => "{$pt}_single_page_section",
						'title'      => __( 'Background overlay color', 'nevo' ),
						'placeholder' => '#212529',
						'selector'   => "body.{$pt} .page-header:before",
						'css_format' => 'background-color: {{value}}',
					);
					
					$config[] = array(
						'name'       => "{$pt}_single_page_header_style",
						'type'       => 'styling',
						'section'    => "{$pt}_single_page_section",
						'title'      => __( 'Custom Style', 'nevo' ),
						'selector'   => array(
							'normal' => "body.{$pt} .page-header",
							'normal_paddinga' => "body.{$pt} .page-header .inside-page-header",
							'normal_bg_image' => "body.{$pt} .page-header.custom",
							'normal_text_color' => "body.{$pt} .page-header .inside-page-header, body.{$pt} .page-header .entry-title",
							'normal_link_color' => "body.{$pt} .page-header .inside-page-header a",
							'hover_link_color' => "body.{$pt} .page-header .inside-page-header a:hover, body.{$pt} .page-header .inside-page-header a:focus",
						),
						'default'   => array(
							'normal' => array(
								//'bg_color' => '#f7f8f9',
							),
						),
						'css_format' => 'styling',
						'fields'     => array(
							'normal_fields' => array(
								'primary'	=> false,
								'secondary' => false,
								'success'	=> false,
								'info'	=> false,
								'warning'	=> false,
								'type_heading'	=> false,
								'link'	=> false,
								'link_hover'	=> false,
								'base'	=> false,
								'title'	=> false,
								'meta'	=> false,
								'heading'	=> false,
								'margin'         => false,
								'padding'    	 => false,
								'border_heading' => false,
								'border_width'   => false,
								'border_color'   => false,
								'border_radius'  => false,
								'box_shadow'     => false,
								'border_style'   => false,
							),
							'hover_fields'  => array(
								'text_color'     => false,
								'padding'        => false,
								'margin'         => false,
								'bg_heading' 	 => false,
								'bg_color' 		 => false,
								'bg_image' 		 => false,
								'border_heading' => false,
								'border_width'   => false,
								'border_color'   => false,
								'border_radius'  => false,
								'box_shadow'     => false,
								'border_style'   => false,
							),
						),
					);
					
					$config[] = array(
						'name'    => "{$pt}_h_content",
						'type'    => 'heading',
						'priority' => 120,
						'section' => "{$pt}_single_page_section",
						'title'   => __( 'Content / Sidebar', 'nevo' ),
					);
					
					$config[] = array(
						'name'    => "{$pt}_single_sidebar_layout",
						'type'    => 'image_select',
						'priority' => 130,
						'default' => 'right-sidebar',
						'section' => "{$pt}_single_page_section",
						'title'   => sprintf( __( 'Single %s', 'nevo' ), $label['singular_name'] ),
						'choices' => nevo_get_sidebar_layouts(),
					);
				}
			}
		}

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_other_page_config', 299 );